function [trans_prob_f, trans_prob_m] ...
    = trans_probs_initbyyear_mentholbanSA(age_cats, inityear_exp1_f, inityear_exp1_m, ...
    inityear_dual_f, inityear_dual_m, ...
    inityear_exp2_f, inityear_exp2_m, ...
    cf1_f, cf1_m)
% Function updated on 8/12/2019 by Esther Salazar, Statistics Branch 1
% This function creates the transition matrices by assuming independence between the product specific transition probabilities.
% This function call is assigned by Athena property mortality_func and the
% code defaults to @trans_probs.
% Inputs:
% age_cats: integer equal to the number of rows in raw.frmr_prod1_dist_f/m.
%        This integer is used throughout Athena to specify the number of
%        age categories used in population update calculations.
% AB#_$: Twenty inputs following this pattern where A=N,C, or F and B=N, C,
%        or F for sex $. These inputs are the outputs of trans_data_load.
%
%        nn1_f     nn1_m     nn2_f     nn2_m
%        nc1_f     nc1_m     nc2_f     nc2_m
%        cc1_f     cc1_m     cc2_f     cc2_m
%        cf1_f     cf1_m     cf2_f     cf2_m
%        ff1_f     ff1_m     ff2_f     ff2_m
% inityear_xxxx_$: Six input matrices with time-varying initiation rate
%                  for exclusive smokers (exp1), dual, and exclusive non-combustible (exp2)

%Updates: function updated for menthol in May 2023.

trans_prob_f=make_probs(inityear_exp1_f, inityear_dual_f, inityear_exp2_f, cf1_f, age_cats, 200);
trans_prob_m=make_probs(inityear_exp1_m, inityear_dual_m, inityear_exp2_m, cf1_m, age_cats, 200);

end

function [trans_prob]=make_probs(inityear_exp1, inityear_dual, inityear_exp2, cf1, age_cats, steps)

trans_prob=zeros(age_cats,81,steps);

[~,l] = size(inityear_exp1);

%[~,w,l]=size(sfmat);

if steps<l
    fcount=steps;
elseif steps==l
    fcount=l;
    fcountp1=steps;
else
    fcount=l;
    fcountp1=l+1;
end

cf1_baseline = cf1;

%mnthl_s_year= 4; % Menthol Ban starting year 4, for 2024 (mnthl_s_year = Menthol start year)
mnthl_s_year= 5; % Menthol Ban starting year 5, for 2025 (mnthl_s_year = Menthol start year), updated October 2023

for k=1:fcount
    % Scaling factors for exclusive smoking initiation
    % for mean (average) impact
    sfi=[0.652, 0.704, 0.747]; % average

    % Scaling factors for exclusive non-combusted initiation
    sfnc=[0.107, 0.091, 0.078]; % average


    if k< mnthl_s_year %k=1(2021), k=2(2022)
        trans_prob(10:31,2,k)=inityear_exp1(:,k);   % nn:cn (b) exclusive initiation for P1
        trans_prob(10:31,4,k)=inityear_exp2(:,k);   % nn:nc (a) exclusive initiation for P2
        trans_prob(10:31,5,k)=inityear_dual(:,k);   % nn:cc (e) dual use initiation
        trans_prob(:,1,k)=1-trans_prob(:,2,k)-trans_prob(:,4,k)-trans_prob(:,5,k); %nn:nn

    else % k=3(2023), k=4(2024), ... and over
        trans_prob(10:18,2,k)=sfi(1)*inityear_exp1(1:9,k);   % 9-17 yrs old, nn:cn (b) exclusive initiation for P1
        trans_prob(19:25,2,k)=sfi(2)*inityear_exp1(10:16,k);   % 18-24 yrs old, nn:cn (b) exclusive initiation for P1
        trans_prob(26:31,2,k)=sfi(3)*inityear_exp1(17:end,k);   % 25-30 yrs old, nn:cn (b) exclusive initiation for P1

        trans_prob(10:18,4,k)=inityear_exp2(1:9,k) + sfnc(1)*inityear_exp1(1:9,k);   % 9-17 yrs old, nn:nc (a) exclusive initiation for P2
        trans_prob(19:25,4,k)=inityear_exp2(10:16,k) + sfnc(2)*inityear_exp1(10:16,k);   % 18-24 yrs old, nn:nc (a) exclusive initiation for P2
        trans_prob(26:31,4,k)=inityear_exp2(17:end,k) + sfnc(3)*inityear_exp1(17:end,k);   % 25-30 yrs old, nn:nc (a) exclusive initiation for P2

        trans_prob(10:31,5,k)=inityear_dual(:,k);   % nn:cc (e) dual use initiation



        % Adjusting dual use initiation using equation derived using  multiplication Method
        trans_prob(10:18,5,k)=sfi(1)*inityear_dual(1:9,k) + sfi(1)*sfnc(1)*inityear_exp1(1:9,k).*inityear_exp1(1:9,k);   % 9-17 yrs old, nn:cn % nn:cc (e) dual use initiation
        trans_prob(19:25,5,k)=sfi(2)*inityear_dual(10:16,k)+ sfi(2)*sfnc(2)*inityear_exp1(10:16,k).*inityear_exp1(10:16,k);   % 18-24 yrs old, nn:cn % nn:cc (e) dual use initiation
        trans_prob(26:31,5,k)=sfi(3)*inityear_dual(17:end,k)+ sfi(3)*sfnc(3)*inityear_exp1(17:end,k).*inityear_exp1(17:end,k);   % 25-30 yrs old, nn:cn % nn:cc (e) dual use initiation



        trans_prob(:,1,k)=1-trans_prob(:,2,k)-trans_prob(:,4,k)-trans_prob(:,5,k); %nn:nn
    end

    nc1(:,k)=trans_prob(:,2,k)+trans_prob(:,5,k); %overall smoking init rate
    nc2(:,k)=trans_prob(:,4,k)+trans_prob(:,5,k); %overall NonC init rate

    %%%%%%%%%%%%%%%%%%%
    %     trans_prob(:,2,k)=sfmat(:,1,k).*nc1(:,1);   % nn:cn (b)
    %     trans_prob(:,4,k)=sfmat(:,2,k).*nc1(:,1);   % nn:nc (a)
    %     trans_prob(:,5,k)=sfmat(:,3,k).*nc1(:,1);   % nn:cc (e)
    %     trans_prob(:,1,k)=1-trans_prob(:,2,k)-trans_prob(:,4,k)-trans_prob(:,5,k); %nn:nn
    %
    %     nc2(:,k)=trans_prob(:,4,k)+trans_prob(:,5,k); %overall NonC init rate
    %%%%%%%%%%%%%%%%%%%

    % Scaling factors for smoking cessation for K=3 for Menthol Ban
    sfc=[1.631, 1.527, 1.444, 1.273]; % for mean (average) impact


    cf1_aux=cf1_baseline; % auxiliary smoking cessation rate
    cf1_aux(16:18)=sfc(1)*cf1_baseline(16:18); % 15-17 yrs old
    cf1_aux(19:25)=sfc(2)*cf1_baseline(19:25); % 18-24 yrs old
    cf1_aux(26:31)=sfc(3)*cf1_baseline(26:31); % 25-30 yrs old
    cf1_aux(32:end)=sfc(4)*cf1_baseline(32:end); % 30+ yrs old

    % Scaling factors for smoking cessation for Non-Menthol (nm) after Menthol
    % Ban for K>3
    %sfcnm=[1.121, 1.101, 1.085, 1.085]; %  for mean (average) impact
    sfcnm=1.25*[1, 1, 1, 1];

    cf1nm_aux=cf1_baseline; % auxiliary smoking cessation rate
    cf1nm_aux(16:18)=sfcnm(1)*cf1_baseline(16:18); % 15-17 yrs old
    cf1nm_aux(19:25)=sfcnm(2)*cf1_baseline(19:25); % 18-24 yrs old
    cf1nm_aux(26:31)=sfcnm(3)*cf1_baseline(26:31); % 25-30 yrs old
    cf1nm_aux(32:end)=sfcnm(4)*cf1_baseline(32:end); % 30+ yrs old

    if k < mnthl_s_year            % before Menthol Ban
        cf1=cf1_baseline;
        cf2=cf1_baseline;

    elseif k == mnthl_s_year       % during Menthol Ban
        cf1=cf1_aux; % cessation for the first year of menthol ban implementation k=3 (2023)
        cf2=cf1_baseline;
        %cf2=cf1_aux;
    else              % After Menthol Ban
        cf1=cf1nm_aux;
        cf2=cf1nm_aux;
    end

    trans_prob(:,12,k)=cf1.*(1-nc2(:,k)); % cn:fn (f)
    trans_prob(:,14,k)=(1-cf1).*nc2(:,k); % cn:cc (j)


    % Updated April 10, 2023  % PREVIOUS ASSUMPTION, REPLACED BY VALUES FROM the average of BROUWER ET AL.(2020) and BROUWER ET AL.(2023, %Accepted)
    %Switching data order for ages: 12-14, 15-17, 18-24, 25-34, ages 35-54, ages 55+: Cigarette−only use to E−cigarette−only
    Waves_1_4_CE =[0.018 0.018 0.018 0.015 0.008 0.007]; %Switching estimates using PATH data Waves 1 to 4.
    Waves_2_4_CE =[0.089 0.04  0.019 0.013 0.006 0.006]; %Switching estimates using PATH data Waves 2 to 4.
    Waves_4_5_CE =[0.105 0.058 0.032 0.017 0.007 0.004]; %Switching estimates using PATH data Waves 4 to 5.

    AvrgSwitch_CE =(1/2)*(Waves_2_4_CE + Waves_4_5_CE); % Taking the average of the two transitions


    sw_baseline=cf1_baseline.*(nc2(:,k)); % cn:fc (g); % cn:fc (g)
    sw_baseline(13:15)=AvrgSwitch_CE(1); % cn:fc (g) ages 12-14
    sw_baseline(16:18)=AvrgSwitch_CE(2); % cn:fc (g) ages 15-17
    sw_baseline(19:25)=AvrgSwitch_CE(3); % cn:fc (g) ages 18-24
    sw_baseline(26:35)=AvrgSwitch_CE(4); % cn:fc (g) ages 25-34
    sw_baseline(36:55)=AvrgSwitch_CE(5); % cn:fc (g) ages 35-54
    sw_baseline(56:end)=AvrgSwitch_CE(6); % cn:fc (g) ages 55+

    trans_prob(:,15,k)=sw_baseline; % cn:fc (g)


    % Scaling factors for switching (cig to non-combusted)
    sfsw=[1.927, 1.781, 1.663, 1.295]; % for mean (average) impact


    % Scaling factors for switching from Non-Menthol (nm) to non-combusted after Menthol Ban for K>3

    sfSwnm=[1.147 0.975  0.867  0.867]; %  for mean (average) impact


    if k == mnthl_s_year % changes in switching that ocurr in the first year (k=2024)of menthol ban ONLY
        trans_prob(13:18,15,k)=sfsw(1)*sw_baseline(13:18); % ages 12-17
        trans_prob(19:25,15,k)=sfsw(2)*sw_baseline(19:25); % ages 18-24
        trans_prob(26:31,15,k)=sfsw(3)*sw_baseline(26:31); % ages 25-30
        trans_prob(32:end,15,k)=sfsw(4)*sw_baseline(32:end); % ages 30+

    elseif k > mnthl_s_year % changes in switching that ocurr after the first year (k > 2023)of menthol ban

        trans_prob(13:18,15,k)=sfSwnm(1)*sw_baseline(13:18); % ages 12-17
        trans_prob(19:25,15,k)=sfSwnm(2)*sw_baseline(19:25); % ages 18-24
        trans_prob(26:31,15,k)=sfSwnm(3)*sw_baseline(26:31); % ages 25-30
        trans_prob(32:end,15,k)=sfSwnm(4)*sw_baseline(32:end); % ages 30+
    end

    trans_prob(:,11,k)=1-trans_prob(:,12,k)-trans_prob(:,14,k)-trans_prob(:,15,k); % cn:cn

    trans_prob(:,24,k)=nc2(:,k);  % fn:fc (k)
    trans_prob(:,21,k)=1-trans_prob(:,24,k); % fn:fn

    trans_prob(:,32,k)=nc1(:,k).*(1-cf2); % nc:cc (i)
    trans_prob(:,34,k)=(1-nc1(:,k)).*cf2; % nc:nf (d)
    trans_prob(:,35,k)=nc1(:,k).*cf2; %nc:cf (c)
    trans_prob(:,31,k)=1-trans_prob(:,32,k)-trans_prob(:,34,k)-trans_prob(:,35,k); % nc:nc

    trans_prob(:,42,k)=cf1.*(1-cf2); % cc:fc (n) % dual to exclusive non-combust
    trans_prob(:,44,k)=(1-cf1).*cf2; % cc:cf (m) % dual to exclusive smoking

    % Updated April 10, 2023  % PREVIOUS ASSUMPTION, REPLACED BY VALUES FROM the average of BROUWER ET AL.(2020) and BROUWER ET AL.(2023, %Accepted)
    %Switching data order for ages: 12-14, 15-17, 18-24, 25-34, ages 35-54, ages 55+: Dual use to E−cigarette−only
    Waves_1_4_DE =[0.130  0.130   0.130  0.091 0.085 0.077]; %Switching estimates using PATH data Waves 1 to 4.
    Waves_2_4_DE =[0.126 0.043  0.133 0.096 0.098 0.063 ]; %Switching estimates using PATH data Waves 2 to 4.
    Waves_4_5_DE =[0.281 0.149 0.203  0.118 0.037 0.056 ]; %Switching estimates using PATH data Waves 4 to 5.

    AvrgSwitch_DE =(1/2)*(Waves_2_4_DE + Waves_4_5_DE); % Taking the average of the two transitions


    trans_prob(13:15,42,k)=AvrgSwitch_DE(1); % cc:fc (g) ages 12-14
    trans_prob(16:18,42,k)=AvrgSwitch_DE(2); % cc:fc (g) ages 15-17
    trans_prob(19:25,42,k)=AvrgSwitch_DE(3); % cc:fc (g) ages 18-24
    trans_prob(26:35,42,k)=AvrgSwitch_DE(4); % cc:fc (g) ages 25-34
    trans_prob(36:55,42,k)=AvrgSwitch_DE(5); % cc:fc (g) ages 35-54
    trans_prob(56:end,42,k)=AvrgSwitch_DE(6); % cc:fc (g) ages 55+

    % for Menthol Ban
    sfc_dual =[1  1  1  1]; % Scaling factor used for Menthol ban for transtion from CC to CF (cc:cf)

    if k == mnthl_s_year       % during Menthol Ban
        sfc_dual=sfc; % cessation for the first year of menthol ban implementation k=4 (202)

    elseif k > mnthl_s_year              % After Menthol Ban
        sfc_dual=sfcnm;
    end
    trans_prob(13:18,42,k) = sfc_dual(1)*trans_prob(13:18,42,k);
    trans_prob(19:25,42,k) = sfc_dual(2)*trans_prob(19:25,42,k);
    trans_prob(26:31,42,k) = sfc_dual(3)*trans_prob(26:31,42,k);
    trans_prob(32:end,42,k) = sfc_dual(4)*trans_prob(32:end,42,k);
    % for Menthol Ban cc:fc -- end---


    % Updated April 10, 2023  % PREVIOUS ASSUMPTION, REPLACED BY VALUES FROM the average of BROUWER ET AL.(2020) and BROUWER ET AL.(2023, %Accepted)
    %Switching data order for ages: 12-14, 15-17, 18-24, 25-34, ages 35-54, ages 55+: Dual
    Waves_1_4_DC =[0.413 0.413 0.413 0.457 0.451 0.44]; %Switching estimates using PATH data Waves 1 to 4.
    Waves_2_4_DC =[0.352 0.377 0.435 0.433 0.462 0.435]; %Switching estimates using PATH data Waves 2 to 4.
    Waves_4_5_DC =[0.008 0.184 0.152 0.23  0.265 0.371]; %Switching estimates using PATH data Waves 4 to 5.

    AvrgSwitch_DC =(1/2)*(Waves_2_4_DC + Waves_4_5_DC); % Taking the average of the two transitions

    trans_prob(13:15,44,k)=AvrgSwitch_DC(1); % cc:cf (g) ages 12-14  % dual to exclusive smoking
    trans_prob(16:18,44,k)=AvrgSwitch_DC(2); % cc:cf (g) ages 15-17
    trans_prob(19:25,44,k)=AvrgSwitch_DC(3); % cc:cf (g) ages 18-24
    trans_prob(26:35,44,k)=AvrgSwitch_DC(4); % cc:cf (g) ages 25-34
    trans_prob(36:55,44,k)=AvrgSwitch_DC(5); % cc:cf (g) ages 35-54
    trans_prob(56:end,44,k)=AvrgSwitch_DC(6); % cc:cf (g) ages 55+


    trans_prob(:,45,k)=cf1.*cf2; % cc:ff (p)
    trans_prob(:,41,k)=1-trans_prob(:,42,k)-trans_prob(:,44,k)-trans_prob(:,45,k); % cc:cc

    trans_prob(:,54,k)=cf2;  % fc:ff (o)
    trans_prob(:,51,k)=1-trans_prob(:,54,k); % fc:fc

    trans_prob(:,62,k)=nc1(:,k); % nf:cf (h)
    trans_prob(:,61,k)=1-trans_prob(:,62,k); % nf:nf

    trans_prob(:,72,k)=cf1; % cf:ff (l)
    trans_prob(:,71,k)=1-trans_prob(:,72,k); % cf:cf

    trans_prob(:,81,k)=1;  % ff:ff
end

if l<=steps
    for k=fcountp1:steps
        trans_prob(:,:,k)=trans_prob(:,:,fcount);
    end
end

end






