function [trans_prob_f, trans_prob_m] ...
    = trans_probs_initbyyear(age_cats, inityear_exp1_f, inityear_exp1_m, ...
    inityear_dual_f, inityear_dual_m, ...
    inityear_exp2_f, inityear_exp2_m, ...
    cf1_f, cf1_m)
% Function updated on 8/12/2019 by Esther Salazar, Statistics Branch 1
% This function creates the transition matrices by assuming independence between the product specific transition probabilities.
% This function call is assigned by Athena property mortality_func and the
% code defaults to @trans_probs.
% Inputs:
% age_cats: integer equal to the number of rows in raw.frmr_prod1_dist_f/m.
%        This integer is used throughout Athena to specify the number of
%        age categories used in population update calculations.
% AB#_$: Twenty inputs following this pattern where A=N,C, or F and B=N, C,
%        or F for sex $. These inputs are the outputs of trans_data_load.
%
%        nn1_f     nn1_m     nn2_f     nn2_m
%        nc1_f     nc1_m     nc2_f     nc2_m
%        cc1_f     cc1_m     cc2_f     cc2_m
%        cf1_f     cf1_m     cf2_f     cf2_m
%        ff1_f     ff1_m     ff2_f     ff2_m
% inityear_xxxx_$: Six input matrices with time-varying initiation rate
%                  for exclusive smokers (exp1), dual, and exclusive non-combustible (exp2)

trans_prob_f=make_probs(inityear_exp1_f, inityear_dual_f, inityear_exp2_f, cf1_f, age_cats, 200);
trans_prob_m=make_probs(inityear_exp1_m, inityear_dual_m, inityear_exp2_m, cf1_m, age_cats, 200);

end

function [trans_prob]=make_probs(inityear_exp1, inityear_dual, inityear_exp2, cf1, age_cats, steps)

trans_prob=zeros(age_cats,81,steps);

[~,l] = size(inityear_exp1);

%[~,w,l]=size(sfmat);

if steps<l
    fcount=steps;
elseif steps==l
    fcount=l;
    fcountp1=steps;
else
    fcount=l;
    fcountp1=l+1;
end

for k=1:fcount
    trans_prob(10:31,2,k)=inityear_exp1(:,k);   % nn:cn (b) exclusive initiation for P1
    trans_prob(10:31,4,k)=inityear_exp2(:,k);   % nn:nc (a) exclusive initiation for P2
    trans_prob(10:31,5,k)=inityear_dual(:,k);   % nn:cc (e) dual use initiation
    trans_prob(:,1,k)=1-trans_prob(:,2,k)-trans_prob(:,4,k)-trans_prob(:,5,k); %nn:nn

    nc1(:,k)=trans_prob(:,2,k)+trans_prob(:,5,k); %overall smoking init rate
    nc2(:,k)=trans_prob(:,4,k)+trans_prob(:,5,k); %overall NonC init rate

    %%%%%%%%%%%%%%%%%%%
    %     trans_prob(:,2,k)=sfmat(:,1,k).*nc1(:,1);   % nn:cn (b)
    %     trans_prob(:,4,k)=sfmat(:,2,k).*nc1(:,1);   % nn:nc (a)
    %     trans_prob(:,5,k)=sfmat(:,3,k).*nc1(:,1);   % nn:cc (e)
    %     trans_prob(:,1,k)=1-trans_prob(:,2,k)-trans_prob(:,4,k)-trans_prob(:,5,k); %nn:nn
    %
    %     nc2(:,k)=trans_prob(:,4,k)+trans_prob(:,5,k); %overall NonC init rate
    %%%%%%%%%%%%%%%%%%%

    cf2=cf1;

    trans_prob(:,12,k)=cf1.*(1-nc2(:,k)); % cn:fn (f)
    trans_prob(:,14,k)=(1-cf1).*nc2(:,k); % cn:cc (j)

    %     % PREVIOUS ASSUMPTION, REPLACED BY VALUES FROM BROUWER ET AL.(2020) trans_prob(:,15,k)=0.01; %for sensitivity analysis (switching); % cn:fc (g)
    %     % we can also incorporate assumptions related to increase in switching
    %     % for 50% or 100% increase, in sensitivity analyses
    %     trans_prob(:,15,k)=cf1.*(nc2(:,k)); % cn:fc (g)
    %     trans_prob(19:25,15,k)=0.018; % cn:fc (g) ages 18-24
    %     trans_prob(26:35,15,k)=0.015; % cn:fc (g) ages 25-34
    %     trans_prob(36:55,15,k)=0.008; % cn:fc (g) ages 35-54
    %     trans_prob(56:end,15,k)=0.007; % cn:fc (g) ages 55+

    % Updated April 10, 2023  % PREVIOUS ASSUMPTION, REPLACED BY VALUES FROM the average of BROUWER ET AL.(2020) and BROUWER ET AL.(2023, %Accepted)
    %Switching data order for ages: 12-14, 15-17, 18-24, 25-34, ages 35-54, ages 55+: Cigarette−only use to E−cigarette−only
    Waves_1_4_CE =[0.018 0.018 0.018 0.015 0.008 0.007]; %Switching estimates using PATH data Waves 1 to 4.
    Waves_2_4_CE =[0.089 0.04  0.019 0.013 0.006 0.006]; %Switching estimates using PATH data Waves 2 to 4.
    Waves_4_5_CE =[0.105 0.058 0.032 0.017 0.007 0.004]; %Switching estimates using PATH data Waves 4 to 5.

    AvrgSwitch_CE =(1/2)*(Waves_2_4_CE + Waves_4_5_CE); % Taking the average of the two transitions

    trans_prob(:,15,k)=cf1.*(nc2(:,k)); % cn:fc (g)
    trans_prob(13:15,15,k)=AvrgSwitch_CE(1); % cn:fc (g) ages 12-14
    trans_prob(16:18,15,k)=AvrgSwitch_CE(2); % cn:fc (g) ages 15-17
    trans_prob(19:25,15,k)=AvrgSwitch_CE(3); % cn:fc (g) ages 18-24
    trans_prob(26:35,15,k)=AvrgSwitch_CE(4); % cn:fc (g) ages 25-34
    trans_prob(36:55,15,k)=AvrgSwitch_CE(5); % cn:fc (g) ages 35-54
    trans_prob(56:end,15,k)=AvrgSwitch_CE(6); % cn:fc (g) ages 55+

    trans_prob(:,11,k)=1-trans_prob(:,12,k)-trans_prob(:,14,k)-trans_prob(:,15,k); % cn:cn


    trans_prob(:,24,k)=nc2(:,k);  % fn:fc (k)
    trans_prob(:,21,k)=1-trans_prob(:,24,k); % fn:fn

    trans_prob(:,32,k)=nc1(:,k).*(1-cf2); % nc:cc (i)
    trans_prob(:,34,k)=(1-nc1(:,k)).*cf2; % nc:nf (d)
    trans_prob(:,35,k)=nc1(:,k).*cf2; %nc:cf (c)
    trans_prob(:,31,k)=1-trans_prob(:,32,k)-trans_prob(:,34,k)-trans_prob(:,35,k); % nc:nc

    trans_prob(:,42,k)=cf1.*(1-cf2); % cc:fc (n) % dual to exclusive non-combust
    trans_prob(:,44,k)=(1-cf1).*cf2; % cc:cf (m) % dual to exclusive smoking

    % Updated April 10, 2023  % PREVIOUS ASSUMPTION, REPLACED BY VALUES FROM the average of BROUWER ET AL.(2020) and BROUWER ET AL.(2023, %Accepted)
    %Switching data order for ages: 12-14, 15-17, 18-24, 25-34, ages 35-54, ages 55+: Dual use to E−cigarette−only
    Waves_1_4_DE =[0.130 0.130  0.130  0.091 0.085 0.077]; %Switching estimates using PATH data Waves 1 to 4.
    Waves_2_4_DE =[0.126 0.043  0.133 0.096 0.098 0.063 ]; %Switching estimates using PATH data Waves 2 to 4.
    Waves_4_5_DE =[0.281 0.149 0.203  0.118 0.037 0.056 ]; %Switching estimates using PATH data Waves 4 to 5.

    AvrgSwitch_DE =(1/2)*(Waves_2_4_DE + Waves_4_5_DE); % Taking the average of the two transitions

    trans_prob(13:15,42,k)=AvrgSwitch_DE(1); % cc:fc (g) ages 12-14
    trans_prob(16:18,42,k)=AvrgSwitch_DE(2); % cc:fc (g) ages 15-17
    trans_prob(19:25,42,k)=AvrgSwitch_DE(3); % cc:fc (g) ages 18-24
    trans_prob(26:35,42,k)=AvrgSwitch_DE(4); % cc:fc (g) ages 25-34
    trans_prob(36:55,42,k)=AvrgSwitch_DE(5); % cc:fc (g) ages 35-54
    trans_prob(56:end,42,k)=AvrgSwitch_DE(6); % cc:fc (g) ages 55+

    % Updated April 10, 2023  % PREVIOUS ASSUMPTION, REPLACED BY VALUES FROM the average of BROUWER ET AL.(2020) and BROUWER ET AL.(2023, %Accepted)
    %Switching data order for ages: 12-14, 15-17, 18-24, 25-34, ages 35-54, ages 55+: Dual use to Cigarette−only
    Waves_1_4_DC =[0.413 0.413 0.413 0.457 0.451 0.44]; %Switching estimates using PATH data Waves 1 to 4.
    Waves_2_4_DC =[0.352 0.377 0.435 0.433 0.462 0.435]; %Switching estimates using PATH data Waves 2 to 4.
    Waves_4_5_DC =[0.008 0.184 0.152 0.23  0.265 0.371]; %Switching estimates using PATH data Waves 4 to 5.

    AvrgSwitch_DC =(1/2)*(Waves_2_4_DC + Waves_4_5_DC); % Taking the average of the two transitions


    trans_prob(13:15,44,k)=AvrgSwitch_DC(1); % cc:cf (g) ages 12-14  % dual to exclusive smoking
    trans_prob(16:18,44,k)=AvrgSwitch_DC(2); % cc:cf (g) ages 15-17
    trans_prob(19:25,44,k)=AvrgSwitch_DC(3); % cc:cf (g) ages 18-24
    trans_prob(26:35,44,k)=AvrgSwitch_DC(4); % cc:cf (g) ages 25-34
    trans_prob(36:55,44,k)=AvrgSwitch_DC(5); % cc:cf (g) ages 35-54
    trans_prob(56:end,44,k)=AvrgSwitch_DC(6); % cc:cf (g) ages 55+


    trans_prob(:,45,k)=cf1.*cf2; % cc:ff (p)
    trans_prob(:,41,k)=1-trans_prob(:,42,k)-trans_prob(:,44,k)-trans_prob(:,45,k); % cc:cc

    trans_prob(:,54,k)=cf2;  % fc:ff (o)
    trans_prob(:,51,k)=1-trans_prob(:,54,k); % fc:fc

    trans_prob(:,62,k)=nc1(:,k); % nf:cf (h)
    trans_prob(:,61,k)=1-trans_prob(:,62,k); % nf:nf

    trans_prob(:,72,k)=cf1; % cf:ff (l)
    trans_prob(:,71,k)=1-trans_prob(:,72,k); % cf:cf

    trans_prob(:,81,k)=1;  % ff:ff
end

if l<=steps
    for k=fcountp1:steps
        trans_prob(:,:,k)=trans_prob(:,:,fcount);
    end
end

end





