function [pop_female1534, pop_tot, adult_pop, adult_pop_n1, adult_pop_c1, adult_pop_f1, adult_pop_n2, adult_pop_c2, adult_pop_f2,adult_pop_cc,...
    adult_prev_n1, adult_prev_c1, adult_prev_f1, adult_prev_n2, adult_prev_c2, adult_prev_f2,adult_prev_cc,...
    pop_n1, pop_c1, pop_f1, pop_n2, pop_c2, pop_f2, pop_nn, pop_nc, pop_nf, pop_cn, pop_cc, pop_cf, pop_fn, pop_fc, pop_ff, ...
    adult_prev_nn, adult_prev_nc, adult_prev_nf, adult_prev_cn,  adult_prev_cf, adult_prev_fn, adult_prev_fc, adult_prev_ff,...
    adult_prev_nn_f, adult_prev_nc_f, adult_prev_nf_f, adult_prev_cn_f, adult_prev_cc_f, adult_prev_cf_f, adult_prev_fn_f, adult_prev_fc_f, adult_prev_ff_f,...
    adult_prev_nn_m, adult_prev_nc_m, adult_prev_nf_m, adult_prev_cn_m, adult_prev_cc_m, adult_prev_cf_m, adult_prev_fn_m, adult_prev_fc_m, adult_prev_ff_m,...
    adult_prev_c1_f, adult_prev_f1_f, adult_prev_c2_f, adult_prev_f2_f,...
    adult_prev_c1_m, adult_prev_f1_m, adult_prev_c2_m, adult_prev_f2_m]...
    = subpop_func_updated(  pop_f, pop_m, smax, mmax, num_years, age_cats, state_combs)
% This function post-processes population outputs to calculate the number of people in and prevalence of various subpopulations.
% Inputs:
% pop_f/m: size age_cats by (smax+2)*(mmax+2) by num_years matrices
%         representing the full population output by gender for a given
%         completed scenario as output by athena_2prod_func.
% smax: integer equal to the number of columns in raw.frmr_prod1_dist_f/m.
%        This integer is used to specify how many former product 1 states
%        are being tracked.
% mmax: integer equal to the number of columns in raw.frmr_prod2_dist_f/m.
%        This integer is used to specify how many former product 2 states
%        are being tracked.
% num_years: number of years to run from the starting year. Set by Athena
%        property num_years. Defaults to 50.
% age_cats: integer equal to the number of rows in raw.frmr_prod1_dist_f/m.
%        This integer is used throughout Athena to specify the number of
%        age categories used in population update calculations.
% state_combs: integer equal to (smax+2)*(mmax+2)
% Outputs:
% pop_tot: vector of length equal to num_years +1. The ith entry contains
%        the total population for the ith year of the simulation.
% adult_pop: same as pop_tot but includes total population for people ages
%        18 and above.
% adult_pop_*#: vector of length equal to num_years+1 . The ith entry
%        contains the total number of people that are at least 18 years old
%        and have use state  * (*= N, C, F for never, current, or former)
%        for product # during the ith year of the simulation.
% adult_pop_cc: vector of length equal to num_years+1 . The ith entry
%        contains the total number of people that are at least 18 years old
%        and are dual users (current users of both products 1 and 2) for
%        the ith year of the simulation.
% adult_prev_*#: identical to adult_pop_*# but this vector contains
%        prevalence among adult values instead of numbers of people.
% adult_prev_cc: identical to adult_pop_cc but this vector contains
%        prevalence among adult values instead of numbers of people.
% pop_*#: identical to adult_pop_*# but this vector contains total numbers
%        of people and not just numbers of adults.
% pop_*%� vector of length equal to num_years +1. The ith entry contains
%        the total number of people that have use state *  (*= N, C, F for
%        never, current, or former) for product 1 and usage state % (*= N,
%        C, F for never, current, or former) for product 2 ith year of the
%        simulation.
% adult_prev_*#_$: same as adult_prev_*# but contains prevalence estimates
%        for individuals with sex $.
% adult_prev_*%_$: same as adult_prev_*#_$ but contains prevalence
%        estimates for adult (ages 18 or older) with sex $.

pop_f1=zeros(1,num_years+1);
% pop_fs_m=zeros(1,num_years+1);
% pop_fs_f=zeros(1,num_years+1);
pop_ff=pop_f1;
% adult_fs_f=pop_fs;
adult_pop_ff_f=pop_f1;
adult_pop_ff_m=pop_f1;
adult_pop_f=pop_f1;
adult_pop_m=pop_f1;

pop_female1534=pop_f1;

% teen_pop_f=pop_fs;
% young_pop_f=pop_fs;
% mid_pop_f=pop_fs;
% sr_pop_f=pop_fs;
%
% teen_pop_m=pop_fs;
% young_pop_m=pop_fs;
% mid_pop_m=pop_fs;
% sr_pop_m=pop_fs;

for t=num_years+1:-1:1
    pop_tot(t)=sum(sum(pop_f(:,:,t)+pop_m(:,:,t)));
    pop_n1(t)=sum(sum(pop_f(:,1:smax+2:1+(smax+2)*(mmax+1),t)+pop_m(:,1:smax+2:1+(smax+2)*(mmax+1),t)));
    pop_c1(t)=sum(sum(pop_f(:,2:smax+2:(smax+2)*(mmax+1)+2,t)+pop_m(:,2:smax+2:(smax+2)*(mmax+1)+2,t)));
    for j=1:mmax+2
        pop_f1(t)=pop_f1(t)+sum(sum(pop_f(:,3+(smax+2)*(j-1):(smax+2)*(j),t)+pop_m(:,3+(smax+2)*(j-1):(smax+2)*(j),t)));
    end
    pop_n2(t)=sum(sum(pop_f(:,1:smax+2,t)+pop_m(:,1:smax+2,t)));
    pop_c2(t)=sum(sum(pop_f(:,1+smax+2:2*(smax+2),t)+pop_m(:,1+smax+2:2*(smax+2),t)));
    pop_f2(t)=sum(sum(pop_f(:,1+2*(smax+2):state_combs,t)+pop_m(:,1+2*(smax+2):state_combs,t)));

    pop_nn(t)=sum(pop_f(:,1,t)+pop_m(:,1,t));
    pop_cn(t)=sum(pop_f(:,2,t)+pop_m(:,2,t));
    pop_fn(t)=sum(sum(sum(pop_f(:,3:smax+2,t)+pop_m(:,3:smax+2,t))));
    pop_nc(t)=sum(pop_f(:,1+(smax+2),t)+pop_m(:,1+(smax+2),t));
    pop_cc(t)=sum(pop_f(:,2+(smax+2),t)+pop_m(:,2+(smax+2),t));
    pop_fc(t)=sum(sum(sum(pop_f(:,3+(smax+2):2*(smax+2),t)+pop_m(:,3+(smax+2):2*(smax+2),t))));

    pop_nf(t)=sum(sum(pop_f(:,1+2*(smax+2):smax+2:1+(smax+2)*(mmax+1),t)+pop_m(:,1+2*(smax+2):smax+2:1+(smax+2)*(mmax+1),t)));
    pop_cf(t)=sum(sum(pop_f(:,2+2*(smax+2):smax+2:2+(smax+2)*(mmax+1),t)+pop_m(:,2+2*(smax+2):smax+2:2+(smax+2)*(mmax+1),t)));
    for j=3:mmax+2
        pop_ff(t)=pop_ff(t)+sum(sum(pop_f(:,3+(smax+2)*(j-1):(smax+2)*(j),t)+pop_m(:,3+(smax+2)*(j-1):(smax+2)*(j),t)));
    end


    for i=1:1%smax+2
        adult_pop_f(t)=adult_pop_f(t)+sum(sum(pop_f((i-1)*age_cats+19:i*age_cats,:,t)));
        adult_pop_m(t)=adult_pop_m(t)+sum(sum(pop_m((i-1)*age_cats+19:i*age_cats,:,t)));

        pop_female1534(t)=pop_female1534(t)+sum(sum(pop_f((i-1)*age_cats+16:i*35,:,t)));

        adult_pop_nn_f(t)=sum(pop_f((i-1)*age_cats+19:i*age_cats,1,t));
        adult_pop_cn_f(t)=sum(pop_f((i-1)*age_cats+19:i*age_cats,2,t));
        adult_pop_fn_f(t)=sum(sum(pop_f((i-1)*age_cats+19:i*age_cats,3:smax+2,t)));
        adult_pop_nc_f(t)=sum(pop_f((i-1)*age_cats+19:i*age_cats,1+(smax+2),t));
        adult_pop_cc_f(t)=sum(pop_f((i-1)*age_cats+19:i*age_cats,2+(smax+2),t));
        adult_pop_fc_f(t)=sum(sum(pop_f((i-1)*age_cats+19:i*age_cats,3+(smax+2):2*(smax+2),t)));
        adult_pop_nf_f(t)=sum(sum(pop_f((i-1)*age_cats+19:i*age_cats,1+2*(smax+2):smax+2:1+(smax+2)*(mmax+1),t)));
        adult_pop_cf_f(t)=sum(sum(pop_f((i-1)*age_cats+19:i*age_cats,2+2*(smax+2):smax+2:2+(smax+2)*(mmax+1),t)));

        adult_pop_nn_m(t)=sum(pop_m((i-1)*age_cats+19:i*age_cats,1,t));
        adult_pop_cn_m(t)=sum(pop_m((i-1)*age_cats+19:i*age_cats,2,t));
        adult_pop_fn_m(t)=sum(sum(pop_m((i-1)*age_cats+19:i*age_cats,3:smax+2,t)));
        adult_pop_nc_m(t)=sum(pop_m((i-1)*age_cats+19:i*age_cats,1+(smax+2),t));
        adult_pop_cc_m(t)=sum(pop_m((i-1)*age_cats+19:i*age_cats,2+(smax+2),t));
        adult_pop_fc_m(t)=sum(sum((pop_m((i-1)*age_cats+19:i*age_cats,3+(smax+2):2*(smax+2),t))));
        adult_pop_nf_m(t)=sum(sum(pop_m((i-1)*age_cats+19:i*age_cats,1+2*(smax+2):smax+2:1+(smax+2)*(mmax+1),t)));
        adult_pop_cf_m(t)=sum(sum(pop_m((i-1)*age_cats+19:i*age_cats,2+2*(smax+2):smax+2:2+(smax+2)*(mmax+1),t)));

        for j=3:mmax+2
            adult_pop_ff_f(t)=adult_pop_ff_f(t)+sum(sum(pop_f((i-1)*age_cats+19:i*age_cats,3+(smax+2)*(j-1):(smax+2)*(j),t)));
            adult_pop_ff_m(t)=adult_pop_ff_m(t)+sum(sum(pop_m((i-1)*age_cats+19:i*age_cats,3+(smax+2)*(j-1):(smax+2)*(j),t)));
        end


    end
    adult_pop=adult_pop_f+adult_pop_m;

end




adult_prev_nn=(adult_pop_nn_f+adult_pop_nn_m)./adult_pop;
adult_prev_cn=(adult_pop_cn_f+adult_pop_cn_m)./adult_pop;
adult_prev_fn=(adult_pop_fn_f+adult_pop_fn_m)./adult_pop;
adult_prev_nc=(adult_pop_nc_f+adult_pop_nc_m)./adult_pop;
adult_prev_cc=(adult_pop_cc_f+adult_pop_cc_m)./adult_pop;
adult_prev_fc=(adult_pop_fc_f+adult_pop_fc_m)./adult_pop;
adult_prev_nf=(adult_pop_nf_f+adult_pop_nf_m)./adult_pop;
adult_prev_cf=(adult_pop_cf_f+adult_pop_cf_m)./adult_pop;
adult_prev_ff=(adult_pop_ff_f+adult_pop_ff_m)./adult_pop;

adult_prev_nn_f=adult_pop_nn_f./adult_pop_f;
adult_prev_cn_f=adult_pop_cn_f./adult_pop_f;
adult_prev_fn_f=adult_pop_fn_f./adult_pop_f;
adult_prev_nc_f=adult_pop_nc_f./adult_pop_f;
adult_prev_cc_f=adult_pop_cc_f./adult_pop_f;
adult_prev_fc_f=adult_pop_fc_f./adult_pop_f;
adult_prev_nf_f=adult_pop_nf_f./adult_pop_f;
adult_prev_cf_f=adult_pop_cf_f./adult_pop_f;
adult_prev_ff_f=adult_pop_ff_f./adult_pop_f;

adult_prev_nn_m=adult_pop_nn_m./adult_pop_m;
adult_prev_cn_m=adult_pop_cn_m./adult_pop_m;
adult_prev_fn_m=adult_pop_fn_m./adult_pop_m;
adult_prev_nc_m=adult_pop_nc_m./adult_pop_m;
adult_prev_cc_m=adult_pop_cc_m./adult_pop_m;
adult_prev_fc_m=adult_pop_fc_m./adult_pop_m;
adult_prev_nf_m=adult_pop_nf_m./adult_pop_m;
adult_prev_cf_m=adult_pop_cf_m./adult_pop_m;
adult_prev_ff_m=adult_pop_ff_m./adult_pop_m;

adult_prev_c1_f= adult_prev_cn_f + adult_prev_cc_f + adult_prev_cf_f;
adult_prev_f1_f= adult_prev_fn_f + adult_prev_fc_f + adult_prev_ff_f;
adult_prev_c2_f= adult_prev_nc_f + adult_prev_cc_f + adult_prev_fc_f;
adult_prev_f2_f= adult_prev_nf_f + adult_prev_cf_f + adult_prev_ff_f;
adult_prev_c1_m= adult_prev_cn_m + adult_prev_cc_m + adult_prev_cf_m;
adult_prev_f1_m= adult_prev_fn_m + adult_prev_fc_m + adult_prev_ff_m;
adult_prev_c2_m= adult_prev_nc_m + adult_prev_cc_m + adult_prev_fc_m;
adult_prev_f2_m= adult_prev_nf_m + adult_prev_cf_m + adult_prev_ff_m;



adult_pop_n1=adult_pop_nn_f+adult_pop_nn_m+adult_pop_nc_f+adult_pop_nc_m+adult_pop_nf_f+adult_pop_nf_m;
adult_pop_c1=adult_pop_cn_f+adult_pop_cn_m+adult_pop_cc_f+adult_pop_cc_m+adult_pop_cf_f+adult_pop_cf_m;
adult_pop_f1=adult_pop_fn_f+adult_pop_fn_m+adult_pop_fc_f+adult_pop_fc_m+adult_pop_ff_f+adult_pop_ff_m;

adult_pop_n2=adult_pop_nn_f+adult_pop_nn_m+adult_pop_cn_f+adult_pop_cn_m+adult_pop_fn_f+adult_pop_fn_m;
adult_pop_c2=adult_pop_nc_f+adult_pop_nc_m+adult_pop_cc_f+adult_pop_cc_m+adult_pop_fc_f+adult_pop_fc_m;
adult_pop_f2=adult_pop_nf_f+adult_pop_nf_m+adult_pop_cf_f+adult_pop_cf_m+adult_pop_ff_f+adult_pop_ff_m;

adult_pop_cc=adult_pop_cc_f+adult_pop_cc_m;


adult_prev_n1=adult_pop_n1./adult_pop;
adult_prev_c1=adult_pop_c1./adult_pop;
adult_prev_f1=adult_pop_f1./adult_pop;

adult_prev_n2=adult_pop_n2./adult_pop;
adult_prev_c2=adult_pop_c2./adult_pop;
adult_prev_f2=adult_pop_f2./adult_pop;

adult_prev_cc=adult_pop_cc./adult_pop;
end

