function [ smokers ] = smokers_by_age_func( pop_f, pop_m, smax, mmax )
% This function calculates the number of current smokers by age in the population for each year of the simulation.
% Inputs:
% pop_$: population matrix for sex $. 
% smax: integer equal to the number of columns in raw.frmr_prod1_dist_f/m.
%        This integer is used to specify how many former product 1 states
%        are being tracked.
% mmax: integer equal to the number of columns in raw.frmr_prod2_dist_f/m.
%        This integer is used to specify how many former product 2 states
%        are being tracked.
% Outputs:
% smokers: matrix with dimensions num_years+1 by age_cats. The entry in the
%        ith row and jth column contains the number of smokers in t5he ith
%        year of the simulation for people with age j-1.

[~,~,years]=size(pop_f);
for k=1:years
    s=sum(pop_f(:,2:smax+2:(smax+2)*(mmax+2),k)+pop_m(:,2:smax+2:(smax+2)*(mmax+2),k),2);
    smokers(k,:)=s';
end

