function [sub_prev_nn, sub_prev_nc, sub_prev_nf, sub_prev_cn, sub_prev_cc, sub_prev_cf, sub_prev_fn, sub_prev_fc, sub_prev_ff,...
    sub_prev_nn_f, sub_prev_nc_f, sub_prev_nf_f, sub_prev_cn_f, sub_prev_cc_f, sub_prev_cf_f, sub_prev_fn_f, sub_prev_fc_f, sub_prev_ff_f,...
    sub_prev_nn_m, sub_prev_nc_m, sub_prev_nf_m, sub_prev_cn_m, sub_prev_cc_m, sub_prev_cf_m, sub_prev_fn_m, sub_prev_fc_m, sub_prev_ff_m, ...
    sub_pop_f, sub_pop_m, sub_pop]...
    = prev_func_updated(  pop_f, pop_m, smax, mmax, num_years, age_cats, min_age, max_age)
% This function calculates prevalence of each tobacco-use state combination on the interval [min_age, max_age].
% Inputs:
% pop_$: full population matrices from athena_2prod_func.
% smax: integer equal to the number of columns in raw.frmr_prod1_dist_f/m.
%        This integer is used to specify how many former product 1 states
%        are being tracked.
% mmax: integer equal to the number of columns in raw.frmr_prod2_dist_f/m.
%        This integer is used to specify how many former product 2 states
%        are being tracked.
% num_years: number of years to run from the starting year. Set by Athena
%        property num_years. Defaults to 50.
% age_cats: integer equal to the number of rows in raw.frmr_prod1_dist_f/m.
%        This integer is used throughout Athena to specify the number of
%        age categories used in population update calculations.
% min_age: lower bound of the calculation interval.
% max_age: upper bound of the calculation interval.
% Outputs:
% sub_prev_*%: vector of length num_years+1 that contains the prevalence of
%        people in use-state * (*= N, C, F for never, current, or former)
%        for product 1 and in use-state % (*= N, C, F for never, current,
%        or former) for product 2 among ages min_age to max_age.
% sub_prev_*%_$: same as sub_prev_*% but prevalence values for people with
%        sex $.

pop_fs=zeros(1,num_years+1);
sub_pop_ff_f=pop_fs;
sub_pop_ff_m=pop_fs;
sub_pop_f=pop_fs;
sub_pop_m=pop_fs;


for t=1:num_years+1

    for i=1:1%smax+2
        sub_pop_f(t)=sub_pop_f(t)+sum(sum((pop_f((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,:,t))));
        sub_pop_m(t)=sub_pop_m(t)+sum(sum((pop_m((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,:,t))));

        sub_pop_nn_f(t)=sum(pop_f((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,1,t));
        sub_pop_cn_f(t)=sum(pop_f((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,2,t));
        sub_pop_fn_f(t)=sum(sum(pop_f((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,3:smax+2,t)));
        sub_pop_nc_f(t)=sum(pop_f((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,1+(smax+2),t));
        sub_pop_cc_f(t)=sum(pop_f((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,2+(smax+2),t));
        sub_pop_fc_f(t)=sum(sum(pop_f((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,3+(smax+2):2*(smax+2),t)));
        sub_pop_nf_f(t)=sum(sum(pop_f((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,1+2*(smax+2):smax+2:1+(smax+2)*(mmax+1),t)));
        sub_pop_cf_f(t)=sum(sum(pop_f((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,2+2*(smax+2):smax+2:2+(smax+2)*(mmax+1),t)));

        sub_pop_nn_m(t)=sum(pop_m((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,1,t));
        sub_pop_cn_m(t)=sum(pop_m((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,2,t));
        sub_pop_fn_m(t)=sum(sum(pop_m((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,3:smax+2,t)));
        sub_pop_nc_m(t)=sum(pop_m((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,1+(smax+2),t));
        sub_pop_cc_m(t)=sum(pop_m((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,2+(smax+2),t));
        sub_pop_fc_m(t)=sum(sum(pop_m((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,3+(smax+2):2*(smax+2),t)));
        sub_pop_nf_m(t)=sum(sum(pop_m((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,1+2*(smax+2):smax+2:1+(smax+2)*(mmax+1),t)));
        sub_pop_cf_m(t)=sum(sum(pop_m((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,2+2*(smax+2):smax+2:2+(smax+2)*(mmax+1),t)));

        for j=3:mmax+2
            sub_pop_ff_f(t)=sub_pop_ff_f(t)+sum(sum(pop_f((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,3+(smax+2)*(j-1):(smax+2)*(j),t)));
            sub_pop_ff_m(t)=sub_pop_ff_m(t)+sum(sum(pop_m((i-1)*age_cats+1+min_age:(i-1)*age_cats+1+max_age,3+(smax+2)*(j-1):(smax+2)*(j),t)));
        end


    end
    sub_pop=sub_pop_f+sub_pop_m;

end




sub_prev_nn=(sub_pop_nn_f+sub_pop_nn_m)./sub_pop;
sub_prev_cn=(sub_pop_cn_f+sub_pop_cn_m)./sub_pop;
sub_prev_fn=(sub_pop_fn_f+sub_pop_fn_m)./sub_pop;
sub_prev_nc=(sub_pop_nc_f+sub_pop_nc_m)./sub_pop;
sub_prev_cc=(sub_pop_cc_f+sub_pop_cc_m)./sub_pop;
sub_prev_fc=(sub_pop_fc_f+sub_pop_fc_m)./sub_pop;
sub_prev_nf=(sub_pop_nf_f+sub_pop_nf_m)./sub_pop;
sub_prev_cf=(sub_pop_cf_f+sub_pop_cf_m)./sub_pop;
sub_prev_ff=(sub_pop_ff_f+sub_pop_ff_m)./sub_pop;

sub_prev_nn_f=(sub_pop_nn_f)./sub_pop_f;
sub_prev_cn_f=(sub_pop_cn_f)./sub_pop_f;
sub_prev_fn_f=(sub_pop_fn_f)./sub_pop_f;
sub_prev_nc_f=(sub_pop_nc_f)./sub_pop_f;
sub_prev_cc_f=(sub_pop_cc_f)./sub_pop_f;
sub_prev_fc_f=(sub_pop_fc_f)./sub_pop_f;
sub_prev_nf_f=(sub_pop_nf_f)./sub_pop_f;
sub_prev_cf_f=(sub_pop_cf_f)./sub_pop_f;
sub_prev_ff_f=(sub_pop_ff_f)./sub_pop_f;

sub_prev_nn_m=(sub_pop_nn_m)./sub_pop_m;
sub_prev_cn_m=(sub_pop_cn_m)./sub_pop_m;
sub_prev_fn_m=(sub_pop_fn_m)./sub_pop_m;
sub_prev_nc_m=(sub_pop_nc_m)./sub_pop_m;
sub_prev_cc_m=(sub_pop_cc_m)./sub_pop_m;
sub_prev_fc_m=(sub_pop_fc_m)./sub_pop_m;
sub_prev_nf_m=(sub_pop_nf_m)./sub_pop_m;
sub_prev_cf_m=(sub_pop_cf_m)./sub_pop_m;
sub_prev_ff_m=(sub_pop_ff_m)./sub_pop_m;


tt=2000:2000+num_years;



end


