function [ qaly ] = morb_qaly_lost_func( pop_f, pop_m, eq5d0, eq5d1, smax, mmax )

% This function calculates the number of QALYs lost in a population every year due to smoking morbidity.
% The calculation follows the approach from Jia and Lubetkin (2010) shown
% here:
%
% where
%      � is the number QALYs lost each year due to smoking morbidity in
%        year t.
%      � is the number of people in the population that are age years old
%        and are current smokers.
%      � are the EQ-5D index scores for non-smokers and smokers,
%        respectively, and that are age years old.
% Inputs:
% pop_$: population matrix for sex $.
% eq5d0: EQ-5D index scores for non-smokers (never or former) by age. The
%        function expects a vector of length age_cats whose entries are the
%        EQ-5D non-smoker index for each age category. The code only uses
%        the entries starting in the 19th position that correspond to
%        adults (ages 18 and above).
% eq5d1: same as eq5d0 buy contains EQ-5D index scores for current smokers.
% smax: integer equal to the number of columns in raw.frmr_prod1_dist_f/m.
%        This integer is used to specify how many former product 1 states
%        are being tracked.
% mmax: integer equal to the number of columns in raw.frmr_prod2_dist_f/m.
%        This integer is used to specify how many former product 2 states
%        are being tracked.
% Outputs:
% qaly: a vector of length num_years+1. The ith entry contains the number
%        of QALYs lost for adults due to smoking morbidity in the ith year
%        of the simulation.


[~,~,years]=size(pop_f);


qaly_f=q_func(pop_f, eq5d0, eq5d1, smax, mmax, years);
qaly_m=q_func(pop_m, eq5d0, eq5d1, smax, mmax, years);
qaly=qaly_f+qaly_m;



    function [qaly1]=q_func(pop, eq5d0, eq5d1, smax, mmax, years);


        for k=1:years
            s=sum(pop(:,2:smax+2:(smax+2)*(mmax+2),k),2);
            qaly1(k,1)=sum(s.*(eq5d0-eq5d1));
        end
    end


end

