function [ lifeyears ] = lifeyears_age_func( pop_f, pop_m, min_age, max_age )
% This function calculates the life years lived by a population within a specified age range in a year.
% This quantity is equal to the number of individuals in the population
% that year for the specified age group.
% Inputs:
% pop_$:population matrix for sex $. 
% min_age: lower bound of age interval.
% max_age: upper bound of age interval.
% Outputs:
% lifeyears: vector of length num_years+1. The ith entry is the total
%        population in year i for the specified age range.

[~,~,years]=size(pop_f);

for k=1:years
    lifeyears(k,1)=sum(sum(pop_f(min_age+1:max_age+1,:,k)+pop_m(min_age+1:max_age+1,:,k)));
end

end

