function [ deaths ] = death_age_func( death_vec_f, death_vec_m, min_age, max_age )
% This function calculates the number of deaths in a population each year for a specified age range.
% Inputs:
% death_vec_$: age_cats by num_years+1 matrix. The entry in the ith row and
%        jth column is the number of deaths for people with sex $ and age
%        i-1 in the jth year of the simulation.
% min_age: lower bound of age interval.
% max_age: upper bound of age interval.
% Outputs:
% deaths: vector of length num_years+1. The ith entry is the number of
%        people between min_age and max_age (inclusive) that die in the ith
%        year of the simulation.

deaths=[sum(death_vec_f(min_age+1:max_age+1,:)+death_vec_m(min_age+1:max_age+1,:),1)]';


end

