function [ CumLifeYears, CumLifeYears_f, CumLifeYears_m  ] = cum_dif_life_func( pop_f1, pop_m1, pop_f2, pop_m2, age_min, age_max )

% This function compares two scenarios and calculates the cumulative difference in life years between the two for ages in the interval [age_min, age_max].
% Inputs:
% pop_${S}: population matrix for sex $ and scenario S (1, 2). (Note: the
%        actual scenarios can be any two but in practice 1 is the baseline
%        and 2 is the scenario being compared to the baseline.)
% age_min: lower bound of ages included in comparison.
% age_max: upper bound of ages included in comparison.
% Outputs:
% CumLifeYears: a num_years+1 long vector containing the cumulative
%        difference in life years by year.
% CumLifeYears_$: same as CumLifeYears but applicable to populations with
%        sex $.

[inum,jnum,knum]=size(pop_f1);

pop_diff_f=pop_f1-pop_f2;
pop_diff_m=pop_m1-pop_m2;

for k=1:knum
    placeh_f(k)=sum(sum(pop_diff_f(age_min+1:age_max+1,:,k)));
    placeh_m(k)=sum(sum(pop_diff_m(age_min+1:age_max+1,:,k)));
    if k==1
        CumLifeYears_f(k)=placeh_f(1);
        CumLifeYears_m(k)=placeh_m(1);
    else
        CumLifeYears_f(k)=CumLifeYears_f(k-1)+placeh_f(k);
        CumLifeYears_m(k)=CumLifeYears_m(k-1)+placeh_m(k);
    end
end

 CumLifeYears= CumLifeYears_f+ CumLifeYears_m;  

end

