function [ CumDifDeath, CumDifDeath_f, CumDifDeath_m  ] = cum_dif_death_func( death_vec_f1, death_vec_m1, death_vec_f2, death_vec_m2, age_min, age_max )

% This function compares two scenarios and calculates the cumulative difference in deaths between them over the range [age_min, age_max].
% Inputs:
% death_vec_${S}: Deaths matrix for sex $ and scenario S. (Same note
%        applies as for cum_dif_life_func inputs pop_$.)
% age_min: Minimum age on which to base the comparison.
% age_max: Maximum age on which to base the comparison.
% Outputs:
% CumDifDeath: a num_years+1 long vector containing the cumulative
%        difference in deaths by time step.
% CumDifDeath_$: as CumDifDeath but for only populations with sex $.

[inum,knum]=size(death_vec_f1);

d_diff_f=death_vec_f2-death_vec_f1;
d_diff_m=death_vec_m2-death_vec_m1;

for k=1:knum
    placeh_f(k)=sum(d_diff_f(age_min+1:age_max+1,k));
    placeh_m(k)=sum(d_diff_m(age_min+1:age_max+1,k));
    if k==1
        CumDifDeath_f(k)=placeh_f(1);
        CumDifDeath_m(k)=placeh_m(1);
    else
        CumDifDeath_f(k)=CumDifDeath_f(k-1)+placeh_f(k);
        CumDifDeath_m(k)=CumDifDeath_m(k-1)+placeh_m(k);
    end
end



 CumDifDeath= CumDifDeath_f+ CumDifDeath_m;  

end

