function [ pop_f, pop_m, death_vec_f, death_vec_m, births,  age_cats, state_combs,...
    mig_f, mig_m, birth_f, birth_m, new_init_p1_f, new_init_p1_m, ...
    new_init_p2_f, new_init_p2_m, new_cess_p1_f, new_cess_p1_m, ...
    new_cess_p2_f, new_cess_p2_m, new_cess_p1E_f, new_cess_p1E_m,...
    new_cess_p1Swtch_f, new_cess_p1Swtch_m,...
    deaths_f, deaths_m, ad_mat_f, ad_mat_m, ad_vec_f, ad_vec_m, ...
    adP1_vec_f, adP1_vec_m, adP2_vec_f, adP2_vec_m, ...
    adP1E_vec_f, adP1E_vec_m, adP2E_vec_f, adP2E_vec_m, adDUAL_vec_f, adDUAL_vec_m] = ...
    athena_2prod_func( num_years, smax, mmax, s_relmax, m_relmax, ip_f, ip_m,...
    die_prob_f, die_prob_m, trans_prob_f, trans_prob_m, migration, migfrac_f, migfrac_m,...
    migdist_f, migdist_m, births_aux, birth_rate, birth_frac_f, birth_frac_m)
% This function is the main Athena workhorse.
% It performs the population calculations described in the conceptual model
% document.
% Inputs:
% num_years: number of years to run from the starting year. Set by Athena
%        property num_years. Defaults to 50.
% smax: integer equal to the number of columns in raw.frmr_prod1_dist_f/m.
%        This integer is used to specify how many former product 1 states
%        are being tracked.
% mmax: integer equalf to the number of columns in raw.frmr_prod2_dist_f/m.
%        This integer is used to specify how many former product 2 states
%        are being tracked.
% s_relmax: a constant assigned to raw.s_relmax in load_raw_data that
%        specifies the maximum number of years after quitting product one a
%        person can start using product 1 again.
% m_relmax: a constant assigned to raw.m_relmax in load_raw_data that
%        specifies the maximum number of years after quitting product one a
%        person can start using product 2 again.
% ip_$: initial population matrices for female and male output by init_pop.
% die_prob_$: Death probability matrices for sex $ output by mortality_func.
% trans_prob_$: Transition probability matrices for sex $ output by
%        transit_func and possibly modified by policy_func.
% migration: migration rates from birth_mig_compare.
% migfrac_$: This input defines the fractions of migration for sex $ from
%        birth_mig_compare.
% migdist_$: This input defines distributions of migration tobacco-product
%        use states for sex $ from birth_mig_compare.
% birth_rate: birth rates from birth_mig_compare.
% birth_frac_$: birth fractions for sex $ from birth_mig_compare.
% Outputs:
% pop_f/m: full population matrices by gender. Matrices are size age_cats
%        by (smax+2)*(mmax+2) by num_years+1. Rows correspond to age;
%        columns correspond to product-use status; the third dimension
%        corresponds to the year of the simulation. The matrix structure
%        and information are the same as that for ip_f and ip_m with the
%        data updated for each year of the simulation.
% death_vec_$: the number of individuals of sex $ that die each year of the
%        simulation. The matrix has dimensions age_cats by (num_years+1).
%        Rows correspond to age and columns correspond to the year of the
%        simulation.
% births: a vector of length num_years+1. The ith entry contains the number
%        of births for that ith year of the simulation.
% age_cats: integer equal to the number of rows in raw.frmr_prod1_dist_f/m.
%        This integer is used throughout Athena to specify the number of
%        age categories used in population update calculations.
% state_combs: integer equal to (smax+2)*(mmax+2)
% mig_f/m: the number of net international immigrants of sex $ by age,
%        tobacco-product use status, and year. The three-dimensional matrix
%        has dimensions age_cats by (smax+2)*(mmax+2) by num_years+1. Rows
%        correspond to age; columns correspond to product-use status; the
%        third dimension corresponds to the year of the simulation. The
%        matrix structure and information are the same as that for ip_f and
%        ip_m with the data updated for each year of the simulation.
% birth_$: a vector of length num_years+1. The ith entry contains the
%        number of births of sex $ for that ith year of the simulation.
% new_init_p#_$: number of people of sex $ that initiate product # by age
%        and year. The matrix has dimensions age_cats by num_years. Rows
%        correspond to ages, and columns correspond to the year of the
%        simulation.
% new_cess_p#_$: number of people of sex $ that quit product # by age and
%        year. The matrix has dimensions age_cats by num_years. Rows
%        correspond to ages, and columns correspond to the year of the
%        simulation.
% deaths_$: Full death matrices by gender, age, 2-product use state, and
%        year. With the same dimensions and organization as pop_$, this
%        matrix provides the number of deaths for individuals of sex $ by
%        age, tobacco product usage, and year of the simulation. It can be
%        quite large and so is not saved by default.
% ad_mat_$: tobacco attributable death matrices by gender, age, 2-product
%        use state, and year. With the same dimensions and organization as
%        pop_$, this matrix  provides the number of tobacco attributable
%        deaths for individuals of sex $ by age, tobacco-product use, and
%        year of the simulation. It can be quite large and so is not saved
%        by default.
% ad_vec_f/m: the number of tobacco attributable deaths for individuals of
%        sex $ for each year of the simulation. The matrix has dimensions
%        age_cats by (num_years+1). Rows correspond to age and columns
%        correspond to the year of the simulation.



state_combs=(smax+2)*(mmax+2);


[age_cats,dum]=size(ip_f);

if dum>state_combs
    disp('Number of state combinations in Initial Population file is not correct');
    return
end

pop_f=zeros(age_cats,state_combs,num_years+1);
pop_f(:,:,1)=ip_f;
pop_m=zeros(age_cats,state_combs,num_years+1);
pop_m(:,:,1)=ip_m;

% births_aux = [3998730, 4026991, 4054590, 4080454, 4104391, 4125307, 4142003, 4154928, ...
%                     4165241, 4173885, 4181208, 4187178, 4191413, 4194135, 4196175, 4198020, ...
%                     4199971, 4202687, 4206587, 4211929, 4218713, 4226595, 4235324, 4244776, ...
% 4255017, 4266000, 4277676, 4290171, 4303391, 4317274, 4331771, 4346651, 4361702, 4376701, ...
% 4391465, 4405894, 4419882, 4433292, 4446041, 4458114, 4469519, 4480293, 4490508, 4500267, ...
% 4509700, 4518941, ...
% 4528182, 4537423, 4546664, 4555905, 4565146, 4574387, 4583628, 4592869, 4602110, ...
% 4611351, 4620592, 4629833, 4639074, 4648315, 4657556, 4666797, 4676038, 4685279, ...
% 4694520, 4703761, 4713002, 4722243, 4731484, 4740725, 4749966, 4759207, 4768448, ...
% 4777689, 4786930, 4796171, 4805412, 4814653, 4823894, 4833135, 4842376, 4851617, ...
% 4860858, 4870099, 4879340, 4888580, 4897821];


%#ok<*AGROW>
for k=1:num_years  %k is index for time
    [ p_f ]=main_pop_func( smax, mmax, pop_f(:,:,k), trans_prob_f(:,:,k), s_relmax, m_relmax);
    [ p_m ]=main_pop_func( smax, mmax, pop_m(:,:,k), trans_prob_m(:,:,k), s_relmax, m_relmax);

    init_prob1_f=zeros(size(trans_prob_f(:,:,k)));
    init_prob1_m=zeros(size(trans_prob_m(:,:,k)));
    init_prob2_f=zeros(size(trans_prob_f(:,:,k)));
    init_prob2_m=zeros(size(trans_prob_m(:,:,k)));
    cess_prob1_f=zeros(size(trans_prob_f(:,:,k)));
    cess_prob1_m=zeros(size(trans_prob_m(:,:,k)));
    cess_prob2_f=zeros(size(trans_prob_f(:,:,k)));
    cess_prob2_m=zeros(size(trans_prob_m(:,:,k)));

    cess_prob1E_f=zeros(size(trans_prob_f(:,:,k))); % NEW: added to compute cessation from cigarette smoking to non use of any tobacco 
    cess_prob1E_m=zeros(size(trans_prob_m(:,:,k))); % NEW
    
    
    cess_prob1Swtch_f=zeros(size(trans_prob_f(:,:,k))); % NEW: added to compute cessation from cigarette smoking to non use of any tobacco 
    cess_prob1Swtch_m=zeros(size(trans_prob_m(:,:,k))); % NEW


    init_p1_vecs=[ 2  5  32 35 59 62];
    init_p2_vecs=[ 4  5  14 15 23 24];
    cess_p1_vecs=[ 12 15 42 45 69 72];
    cess_p2_vecs=[ 34 35 44 45 53 54];
    
    cess_p1E_vecs=[ 12 45 72]; % NEW 
    cess_p1Swtch_vecs=[ 15 42 69]; % NEW 

    init_prob1_f(:,init_p1_vecs)=trans_prob_f(:,init_p1_vecs,k);
    init_prob1_m(:,init_p1_vecs)=trans_prob_m(:,init_p1_vecs,k);
    init_prob2_f(:,init_p2_vecs)=trans_prob_f(:,init_p2_vecs,k);
    init_prob2_m(:,init_p2_vecs)=trans_prob_m(:,init_p2_vecs,k);
    cess_prob1_f(:,cess_p1_vecs)=trans_prob_f(:,cess_p1_vecs,k);
    cess_prob1_m(:,cess_p1_vecs)=trans_prob_m(:,cess_p1_vecs,k);
    cess_prob2_f(:,cess_p2_vecs)=trans_prob_f(:,cess_p2_vecs,k);
    cess_prob2_m(:,cess_p2_vecs)=trans_prob_m(:,cess_p2_vecs,k);

    cess_prob1E_f(:,cess_p1E_vecs)=trans_prob_f(:,cess_p1E_vecs,k); % NEW
    cess_prob1E_m(:,cess_p1E_vecs)=trans_prob_m(:,cess_p1E_vecs,k); % NEW
    
    cess_prob1Swtch_f(:,cess_p1Swtch_vecs)=trans_prob_f(:,cess_p1Swtch_vecs,k); % NEW
    cess_prob1Swtch_m(:,cess_p1Swtch_vecs)=trans_prob_m(:,cess_p1Swtch_vecs,k); % NEW

    [ ni1_f ]=main_pop_func( smax, mmax, pop_f(:,:,k), init_prob1_f, s_relmax, m_relmax);
    [ ni1_m ]=main_pop_func( smax, mmax, pop_m(:,:,k), init_prob1_m, s_relmax, m_relmax);
    [ ni2_f ]=main_pop_func( smax, mmax, pop_f(:,:,k), init_prob2_f, s_relmax, m_relmax);
    [ ni2_m ]=main_pop_func( smax, mmax, pop_m(:,:,k), init_prob2_m, s_relmax, m_relmax);
    [ ci1_f ]=main_pop_func( smax, mmax, pop_f(:,:,k), cess_prob1_f, s_relmax, m_relmax);
    [ ci1_m ]=main_pop_func( smax, mmax, pop_m(:,:,k), cess_prob1_m, s_relmax, m_relmax);
    [ ci2_f ]=main_pop_func( smax, mmax, pop_f(:,:,k), cess_prob2_f, s_relmax, m_relmax);
    [ ci2_m ]=main_pop_func( smax, mmax, pop_m(:,:,k), cess_prob2_m, s_relmax, m_relmax);

    [ ci1E_f ]=main_pop_func( smax, mmax, pop_f(:,:,k), cess_prob1E_f, s_relmax, m_relmax); % NEW
    [ ci1E_m ]=main_pop_func( smax, mmax, pop_m(:,:,k), cess_prob1E_m, s_relmax, m_relmax); % NEW
    
     [ ci1Swtch_f ]=main_pop_func( smax, mmax, pop_f(:,:,k), cess_prob1Swtch_f, s_relmax, m_relmax); % NEW
    [ ci1Swtch_m ]=main_pop_func( smax, mmax, pop_m(:,:,k), cess_prob1Swtch_m, s_relmax, m_relmax); % NEW



    new_init_p1_f(:,k)=sum(ni1_f,2);
    new_init_p1_m(:,k)=sum(ni1_m,2);
    new_init_p2_f(:,k)=sum(ni2_f,2);
    new_init_p2_m(:,k)=sum(ni2_m,2);
    new_cess_p1_f(:,k)=sum(ci1_f,2);
    new_cess_p1_m(:,k)=sum(ci1_m,2);
    new_cess_p2_f(:,k)=sum(ci2_f,2);
    new_cess_p2_m(:,k)=sum(ci2_m,2);

    new_cess_p1E_f(:,k)=sum(ci1E_f,2); % NEW
    new_cess_p1E_m(:,k)=sum(ci1E_m,2); % NEW
    
    
    new_cess_p1Swtch_f(:,k)=sum(ci1Swtch_f,2); % NEW
    new_cess_p1Swtch_m(:,k)=sum(ci1Swtch_m,2); % NEW


    deaths_f(:,:,k)=p_f.*die_prob_f(:,:,k);
    deaths_m(:,:,k)=p_m.*die_prob_m(:,:,k);
    death_vec_f(:,k)=sum(deaths_f(:,:,k),2);
    death_vec_m(:,k)=sum(deaths_m(:,:,k),2);
    ad_mat_f(:,:,k)=p_f.*bsxfun(@minus,die_prob_f(:,:,k),die_prob_f(:,1,k));
    ad_mat_m(:,:,k)=p_m.*bsxfun(@minus,die_prob_m(:,:,k),die_prob_m(:,1,k));
    ad_vec_f(:,k)=sum(ad_mat_f(:,:,k),2);
    ad_vec_m(:,k)=sum(ad_mat_m(:,:,k),2);

    delP1=1:(smax+2):(smax+2)*(mmax+2);
    adP1_vec_f(:,k)=sum(ad_mat_f(:,:,k),2) - sum(ad_mat_f(:,delP1,k),2);
    adP1_vec_m(:,k)=sum(ad_mat_m(:,:,k),2) - sum(ad_mat_m(:,delP1,k),2);

    delP2=1:(smax+2);
    adP2_vec_f(:,k)=sum(ad_mat_f(:,:,k),2) - sum(ad_mat_f(:,delP2,k),2);
    adP2_vec_m(:,k)=sum(ad_mat_m(:,:,k),2) - sum(ad_mat_m(:,delP2,k),2);

    % T=P1E+DUAL+P2E; P1=P1E+DUAL=T-P2E; P2=P2E+DUAL=T-P1E; DUAL=T-P1E-P2E;
    % Exclusive P1
    adP1E_vec_f(:,k)=sum(ad_mat_f(:,delP2,k),2);
    adP1E_vec_m(:,k)=sum(ad_mat_m(:,delP2,k),2);
    % Exclusive P2
    adP2E_vec_f(:,k)=sum(ad_mat_f(:,delP1,k),2);
    adP2E_vec_m(:,k)=sum(ad_mat_m(:,delP1,k),2);
    % Dual
    adDUAL_vec_f(:,k)=sum(ad_mat_f(:,:,k),2) - sum(ad_mat_f(:,delP1,k),2) - sum(ad_mat_f(:,delP2,k),2);
    adDUAL_vec_m(:,k)=sum(ad_mat_m(:,:,k),2) - sum(ad_mat_m(:,delP1,k),2) - sum(ad_mat_m(:,delP2,k),2);

    p_f=p_f.*(1-die_prob_f(:,:,k));
    p_m=p_m.*(1-die_prob_m(:,:,k));

    pop_f(:,:,k+1)=[zeros(1,(smax+2)*(mmax+2));p_f(1:age_cats-2,:);p_f(age_cats-1,:)+p_f(age_cats,:)];
    pop_m(:,:,k+1)=[zeros(1,(smax+2)*(mmax+2));p_m(1:age_cats-2,:);p_m(age_cats-1,:)+p_m(age_cats,:)];


    %pop_f(:,:,k+1)=p_f;
    %pop_m(:,:,k+1)=p_m;

    %Start migration calculations
    %# of immigrants(k+1)=migration rate*total pop(k)

    %     migration(k+1,1)=mig_rate(k+1,1)*sum(sum([pop_f(:,:,k)+pop_m(:,:,k)])); %total number of immigrants


    mig_f(:,1:(smax+2)*(mmax+2),k+1)=migration(k+1)*migfrac_f(k+1)*migdist_f;
    mig_m(:,1:(smax+2)*(mmax+2),k+1)=migration(k+1)*migfrac_m(k+1)*migdist_m;


    %mig_f(:,(smax+2)*(mmax+2)+1:end,k+1)=0;
    %mig_m(:,(smax+2)*(mmax+2)+1:end,k+1)=0;

    %     for nc=7:64
    %         mig_f(:,385+(nc-7)*64:384+(nc-6)*64,k+1)=zeros(101,64);
    %         mig_m(:,385+(nc-7)*64:384+(nc-6)*64,k+1)=zeros(101,64);
    %     end

    %'aha'
    %size(mig_f)
    %births (k+1)=birth_rate(k)*[# of women in population (15-34) (k)+ #
    %of women immigrants (15-34) (k+1])

    if age_cats>36
        %births(k+1)=birth_rate(k+1,1)*(sum(sum(pop_f(16:35,:,k)))+sum(sum(mig_f(16:35,:,k+1))));
        births(k+1) = births_aux(k+1); % This is to add the projected number of births from Census
    else
        births(k+1)=birth_rate(k+1,1)*(sum(sum(pop_f(2:3,:,k)))+sum(sum(mig_f(2:3,:,k+1))));
    end

    birth_f(k+1)=births(k+1)*birth_frac_f(k+1);
    birth_m(k+1)=births(k+1)*birth_frac_m(k+1);

    pop_f(:,:,k+1)=pop_f(:,:,k+1)+mig_f(:,:,k+1);
    pop_f(1,1,k+1)=pop_f(1,1,k+1)+birth_f(k+1);
    pop_m(:,:,k+1)=pop_m(:,:,k+1)+mig_m(:,:,k+1);
    pop_m(1,1,k+1)=pop_m(1,1,k+1)+birth_m(k+1);
end

pop_tot(num_years+1)=0;
for t=1:num_years+1
    pop_tot(t)=sum(sum(pop_f(:,:,t)+pop_m(:,:,t)));
end

[ p_f ]=main_pop_func( smax, mmax, pop_f(:,:,k+1), trans_prob_f(:,:,k+1), s_relmax, m_relmax);
[ p_m ]=main_pop_func( smax, mmax, pop_m(:,:,k+1), trans_prob_m(:,:,k+1), s_relmax, m_relmax);

deaths_f(:,:,k+1)=p_f.*die_prob_f(:,:,k+1);
deaths_m(:,:,k+1)=p_m.*die_prob_m(:,:,k+1);
death_vec_f(:,k+1)=sum(deaths_f(:,:,k+1),2);
death_vec_m(:,k+1)=sum(deaths_m(:,:,k+1),2);
ad_mat_f(:,:,k+1)=p_f.*(bsxfun(@minus,die_prob_f(:,:,k+1),die_prob_f(:,1,k+1)));
ad_mat_m(:,:,k+1)=p_m.*(bsxfun(@minus,die_prob_m(:,:,k+1),die_prob_m(:,1,k+1)));
ad_vec_f(:,k+1)=sum(ad_mat_f(:,:,k+1),2);
ad_vec_m(:,k+1)=sum(ad_mat_m(:,:,k+1),2);

delP1=1:(smax+2):(smax+2)*(mmax+2);
adP1_vec_f(:,k+1)=sum(ad_mat_f(:,:,k+1),2) - sum(ad_mat_f(:,delP1,k+1),2);
adP1_vec_m(:,k+1)=sum(ad_mat_m(:,:,k+1),2) - sum(ad_mat_m(:,delP1,k+1),2);

delP2=1:(smax+2);
adP2_vec_f(:,k+1)=sum(ad_mat_f(:,:,k+1),2) - sum(ad_mat_f(:,delP2,k+1),2);
adP2_vec_m(:,k+1)=sum(ad_mat_m(:,:,k+1),2) - sum(ad_mat_m(:,delP2,k+1),2);

% Exclusive P1
adP1E_vec_f(:,k+1)=sum(ad_mat_f(:,delP2,k+1),2);
adP1E_vec_m(:,k+1)=sum(ad_mat_m(:,delP2,k+1),2);
% Exclusive P2
adP2E_vec_f(:,k+1)=sum(ad_mat_f(:,delP1,k+1),2);
adP2E_vec_m(:,k+1)=sum(ad_mat_m(:,delP1,k+1),2);
% Dual
adDUAL_vec_f(:,k+1)=sum(ad_mat_f(:,:,k+1),2) - sum(ad_mat_f(:,delP1,k+1),2) - sum(ad_mat_f(:,delP2,k+1),2);
adDUAL_vec_m(:,k+1)=sum(ad_mat_m(:,:,k+1),2) - sum(ad_mat_m(:,delP1,k+1),2) - sum(ad_mat_m(:,delP2,k+1),2);
end

