function [ qaly_f, qaly_m, qaly ] = adult_qaly_func( pop_f, pop_m, eq5d0, eq5d1, smax, mmax )

% This function calculates the number of quality-adjusted life-years (QALYs) lived by a population in each year.
% The function uses the approach and EQ-5D index scores from Jia and
% Lubetkin (2010) shown here:
%
% where:
%      � is the number QALYs lived by the adult population in year t
%      � is the number of people in the population that are age-years-old
%        and have smoking status X (X=ns for non-smoker, i.e., never or
%        former smoker; X=s for current smoker)
%      � the EQ-5D index scores for non-smokers and smokers, respectively,
%        that are age-years-old.
% Inputs:
% pop_$: population matrix for sex $.
% eq5d0: EQ-5D index scores for non-smokers (never or former) by age. The
%        function expects a vector of length age_cats whose entries are the
%        EQ-5D non-smoker index for each age category. The code only uses
%        the entries starting in the 19th position that correspond to
%        adults (ages 18 and above).
% eq5d1: same as eq5d0 buy contains EQ-5D index scores for current smokers.
% smax: integer equal to the number of columns in raw.frmr_prod1_dist_f/m.
%        This integer is used to specify how many former product 1 states
%        are being tracked.
% mmax: integer equal to the number of columns in raw.frmr_prod2_dist_f/m.
%        This integer is used to specify how many former product 2 states
%        are being tracked.
% Outputs:
% qaly: vector of length num_years+1. The ith entry is the number of QALYs
%        lived by the adults in the population for the ith year.
% qaly_$: same as qaly but only for individuals with sex $.

[~,~,years]=size(pop_f);


qaly_f=q_func(pop_f, eq5d0, eq5d1, smax, mmax, years);
qaly_m=q_func(pop_m, eq5d0, eq5d1, smax, mmax, years);
qaly=qaly_f+qaly_m;






    function [qaly]=q_func(pop, eq5d0, eq5d1, smax, mmax, years);


        for k=1:years
            s=sum(pop(19:101,2:smax+2:(smax+2)*(mmax+2),k),2);
            qaly1=s.*eq5d1(19:101);
            qaly0=[sum(pop(19:101,:,k),2)-s].*eq5d0(19:101);
            qaly(k,1)=sum(qaly1+qaly0);
        end
    end


end
