function [sa_tables] = add_tables( b, b_aux, sa_output, sa_output_aux)
% This fuction produces additional tables from model outputs

% ------ Sheet: Initiation and Cessation Rates -------
% Table for adltcessP1
adltcessP1.base = b_aux.ave_adult18to100_cess_p1;
adltcessP1.poli = prctile(sa_output_aux.ave_adult18to100_cess_p1{1},[5,50,95],2);
sa_tables.adltcessP1 = table(adltcessP1.base, adltcessP1.poli);

% Table for YouthinitP1
YouthinitP1.base = b_aux.ave_youth12to17_init_p1;
YouthinitP1.poli = prctile(sa_output_aux.ave_youth12to17_init_p1{1},[5,50,95],2);
sa_tables.YouthinitP1 = table(YouthinitP1.base, YouthinitP1.poli);

% Table for adltcessP2
adltcessP2.base = b_aux.ave_adult18to100_cess_p2;
adltcessP2.poli = prctile(sa_output_aux.ave_adult18to100_cess_p2{1},[5,50,95],2);
sa_tables.adltcessP2 = table(adltcessP2.base, adltcessP2.poli);

% Table for YouthinitP2
YouthinitP2.base = b_aux.ave_youth12to17_init_p2;
YouthinitP2.poli = prctile(sa_output_aux.ave_youth12to17_init_p2{1},[5,50,95],2);
sa_tables.YouthinitP2 = table(YouthinitP2.base, YouthinitP2.poli);

% -----Sheet: Prevalence_CurrentFormerNever --------
% Table for adultPrev_c1
adultPrev_c1.base = b.adult_prev_c1;
adultPrev_c1.poli = prctile(sa_output.adult_prev_c1{1},[5,50,95],2);
sa_tables.adultPrev_c1 = table(adultPrev_c1.base, adultPrev_c1.poli);

% Table for adultPrev_f1
adultPrev_f1.base = b_aux.adult_prev_f1;
adultPrev_f1.poli = prctile(sa_output_aux.adult_prev_f1{1},[5,50,95],2);
sa_tables.adultPrev_f1 = table(adultPrev_f1.base, adultPrev_f1.poli);

% Table for adultPrev_n1
adultPrev_n1.base = b_aux.adult_prev_n1;
adultPrev_n1.poli = prctile(sa_output_aux.adult_prev_n1{1},[5,50,95],2);
sa_tables.adultPrev_n1 = table(adultPrev_n1.base, adultPrev_n1.poli);

% Table for adultPrev_c2
adultPrev_c2.base = b.adult_prev_c2;
adultPrev_c2.poli = prctile(sa_output.adult_prev_c2{1},[5,50,95],2);
sa_tables.adultPrev_c2 = table(adultPrev_c2.base, adultPrev_c2.poli);

% Table for adultPrev_f2
adultPrev_f2.base = b_aux.adult_prev_f2;
adultPrev_f2.poli = prctile(sa_output_aux.adult_prev_f2{1},[5,50,95],2);
sa_tables.adultPrev_f2 = table(adultPrev_f2.base, adultPrev_f2.poli);

% Table for adultPrev_n2
adultPrev_n2.base = b_aux.adult_prev_n2;
adultPrev_n2.poli = prctile(sa_output_aux.adult_prev_n2{1},[5,50,95],2);
sa_tables.adultPrev_n2 = table(adultPrev_n2.base, adultPrev_n2.poli);

% Table for adultPrev_cc
adultPrev_cc.base = b.adult_prev_cc;
adultPrev_cc.poli = prctile(sa_output.adult_prev_cc{1},[5,50,95],2);
sa_tables.adultPrev_cc = table(adultPrev_cc.base, adultPrev_cc.poli);

% Table for adultPrev_ctot
adultPrev_ctot.base = b.adult_prev_ctot;
adultPrev_ctot.poli = prctile(sa_output.adult_prev_ctot{1},[5,50,95],2);
sa_tables.adultPrev_ctot = table(adultPrev_ctot.base, adultPrev_ctot.poli);

% -----Sheet: PopSize_CurrentFormerNever --------
% Table for adultPop_c1
adultPop_c1.base = b_aux.adult_pop_c1;
adultPop_c1.poli = prctile(sa_output_aux.adult_pop_c1{1},[5,50,95],2);
sa_tables.adultPop_c1 = table(adultPop_c1.base, adultPop_c1.poli);

% Table for adultPop_f1
adultPop_f1.base = b_aux.adult_pop_f1;
adultPop_f1.poli = prctile(sa_output_aux.adult_pop_f1{1},[5,50,95],2);
sa_tables.adultPop_f1 = table(adultPop_f1.base, adultPop_f1.poli);

% Table for adultPop_n1
adultPop_n1.base = b_aux.adult_pop_n1;
adultPop_n1.poli = prctile(sa_output_aux.adult_pop_n1{1},[5,50,95],2);
sa_tables.adultPop_n1= table(adultPop_n1.base, adultPop_n1.poli);

% Table for adultPop_c2
adultPop_c2.base = b_aux.adult_pop_c2;
adultPop_c2.poli = prctile(sa_output_aux.adult_pop_c2{1},[5,50,95],2);
sa_tables.adultPop_c2 = table(adultPop_c2.base, adultPop_c2.poli);

% Table for adultPop_f2
adultPop_f2.base = b_aux.adult_pop_f2;
adultPop_f2.poli = prctile(sa_output_aux.adult_pop_f2{1},[5,50,95],2);
sa_tables.adultPop_f2 = table(adultPop_f2.base, adultPop_f2.poli);

% Table for adultPop_n2
adultPop_n2.base = b_aux.adult_pop_n2;
adultPop_n2.poli = prctile(sa_output_aux.adult_pop_n2{1},[5,50,95],2);
sa_tables.adultPop_n2 = table(adultPop_n2.base, adultPop_n2.poli);

% Table for adultPop_cc
adultPop_cc.base = b_aux.adult_pop_cc;
adultPop_cc.poli = prctile(sa_output_aux.adult_pop_cc{1},[5,50,95],2);
sa_tables.adultPop_cc = table(adultPop_cc.base, adultPop_cc.poli);

% -----Sheet: Mortality --------
% Tobacco Attributable Deaths (TADs)
ad.base = b.pad; %%sum(c.pad_vec_f{1} + c.pad_vec_m{1},1)';
ad.poli = prctile(sa_output.pad{1},[5,50,95],2);
sa_tables.ad = table(ad.base, ad.poli);

% Annual Difference in TADs (scenario - baseline)
Difad=bsxfun(@minus,sa_output.pad{1}, b.pad);
Difad_prctile= prctile(Difad,[5,50,95],2);
sa_tables.Difad = table(Difad_prctile);

% Cumulative sum of TADs annual difference
cumsumDifad_prctile=prctile(cumsum(Difad),[5,50,95],2);
sa_tables.cumsumDifad = table(cumsumDifad_prctile);

% Life years gained
lifeyears.base = b.lifeyears;
lifeyears.poli = prctile(sa_output.lifeyears{1},[5,50,95],2);
sa_tables.lifeyears = table(lifeyears.base, lifeyears.poli);

% Annual Difference life years gained  (scenario - baseline)
DifLifeyears=bsxfun(@minus,sa_output.lifeyears{1}, b.lifeyears);
DifLifeyears_prctile= prctile(DifLifeyears,[5,50,95],2);
sa_tables.DifLifeyears = table(DifLifeyears_prctile);

% Cumulative sum of life years gained difference
cumsumDifLifeyears_prctile=prctile(cumsum(DifLifeyears),[5,50,95],2);
sa_tables.cumsumDifLifeyears = table(cumsumDifLifeyears_prctile);

% QALYs lost
QALYLost.base = b.ad_morb_qaly_lost;
QALYLost.poli = prctile(sa_output.ad_morb_qaly_lost{1},[5,50,95],2);
sa_tables.QALYLost = table(QALYLost.base, QALYLost.poli);

% Annual Difference QALYs lost (scenario - baseline)
DifQALYLost= bsxfun(@minus,sa_output.ad_morb_qaly_lost{1}, b.ad_morb_qaly_lost);
DifQALYLost_prctile= prctile(DifQALYLost,[5,50,95],2);
sa_tables.DifQALYLost = table(DifQALYLost_prctile);

% Cumulative  difference QALYs lost
cumsumDifQALYLost_prctile=prctile(cumsum(DifQALYLost),[5,50,95],2);
sa_tables.cumsumDifQALYLost = table(cumsumDifQALYLost_prctile);

% -------------- Sheet: Baseline-Smokers by Age --------------
sa_tables.smokers_0to100years = table(b_aux.smokers);

smokers_0to100years.poli = prctile(sa_output_aux.smokers{1},[5,50,95],3);
% -------------- Sheet: Low-Smokers by Age ---------------
sa_tables.smokers_0to100years_5thPer  = table(smokers_0to100years.poli(:,:,1));
% -------------- Sheet: Med-Smokers by Age ---------------
sa_tables.smokers_0to100years_median  = table(smokers_0to100years.poli(:,:,2));
% -------------- Sheet: High-Smokers by Age ---------------
sa_tables.smokers_0to100years_95thPer = table(smokers_0to100years.poli(:,:,3));

% ---------------Sheet: Ext NonC Initiates and Quitters----------------
% New NonCombustible Initiates (includes switchers)
Count_initP2.base = b.new_initp2;
Count_initP2.poli = prctile(sa_output.new_initp2{1},[5,50,95],2);
sa_tables.Count_initP2 = table(Count_initP2.base, Count_initP2.poli);

% Annual Difference in New Initiates (scenario - baseline)
DifCount_initP2=bsxfun(@minus,sa_output.new_initp2{1}, b.new_initp2);
DifCount_initP2_prctile= prctile(DifCount_initP2,[5,50,95],2);
sa_tables.DifCount_initP2 = table(DifCount_initP2_prctile);

% Cumulative Difference in New Initiates (scenario - baseline)
cumsumDifCount_initP2_prctile= prctile(cumsum(DifCount_initP2),[5,50,95],2);
sa_tables.cumsumDifCount_initP2 = table(cumsumDifCount_initP2_prctile);

% NonCombustible Quitters
Count_cessp2.base = b.new_cessp2;
Count_cessp2.poli = prctile(sa_output.new_cessp2{1},[5,50,95],2);
sa_tables.Count_cessp2 = table(Count_cessp2.base, Count_cessp2.poli);

% Annual Difference in Quitters (scenario - baseline)
DifCount_cessp2=bsxfun(@minus,sa_output.new_cessp2{1}, b.new_cessp2);
DifCount_cessp2_prctile= prctile(DifCount_cessp2,[5,50,95],2);
sa_tables.DifCount_cessp2 = table(DifCount_cessp2_prctile);

% Cumulative Difference in Quitters (scenario - baseline)
cumsumDifCount_cessp2_prctile= prctile(cumsum(DifCount_cessp2),[5,50,95],2);
sa_tables.cumsumDifCount_cessp2 = table(cumsumDifCount_cessp2_prctile);

% ---------------Sheet: Ext Mortality----------------
% Annual  Deaths (Ages 35-84)
age_deaths35to84.base = b_aux.age_deaths35to84;
age_deaths35to84.poli = prctile(sa_output_aux.age_deaths35to84{1},[5,50,95],2);
sa_tables.age_deaths35to84 = table(age_deaths35to84.base, age_deaths35to84.poli);

% Annual Difference in Deaths (Ages 35-84) (scenario - baseline)
DifAge_deaths35to84 = bsxfun(@minus,sa_output_aux.age_deaths35to84{1}, b_aux.age_deaths35to84);
DifAge_deaths35to84_prctile = prctile(DifAge_deaths35to84,[5,50,95],2);
sa_tables.DifAge_deaths35to84 = table(DifAge_deaths35to84_prctile);

% Cumulative Difference in Deaths (35-84) (scenario - baseline)
cumsumDifAge_deaths35to84_prctile= prctile(cumsum(DifAge_deaths35to84),[5,50,95],2);
sa_tables.cumsumDifAge_deaths35to84 = table(cumsumDifAge_deaths35to84_prctile);

% QALYs lived by the adults in the population for the ith year
adult_qaly.base = b_aux.adult_qaly;
adult_qaly.poli = prctile(sa_output_aux.adult_qaly{1},[5,50,95],2);
sa_tables.adult_qaly = table(adult_qaly.base, adult_qaly.poli);

% Annual Difference  QALYS lived (scenario - baseline)
DifAdult_qaly=bsxfun(@minus,sa_output_aux.adult_qaly{1}, b_aux.adult_qaly);
DifAdult_qaly_prctile= prctile(DifAdult_qaly,[5,50,95],2);
sa_tables.DifAdult_qaly = table(DifAdult_qaly_prctile);

% Cumulative Difference  QALYS lived (scenario - baseline)
cumsumDifAdult_qaly_prctile= prctile(cumsum(DifAdult_qaly),[5,50,95],2);
sa_tables.cumsumDifAdult_qaly = table(cumsumDifAdult_qaly_prctile);

end

