function [rr_prod1_f, rr_prod1_m, rr_prod2_f, rr_prod2_m, die_nprod1_f, ...
    die_nprod1_m] ...
    = mort_data_load(raw)
% This function assigns the raw mortality values from file to the variables used in later calculations.
% Also serves as a place holder if more complicated logic needs to be
% implemented before the raw numbers can be used. Local to the package
% being run.
% Inputs:
% raw: only die_nprod1_$ and rr_prod1/2_$ are required in the raw struct.
% Outputs:
% rr_prod#_$: this matrix contains the relative all-cause mortality risk
%        (relative to never use of either product) for product # use for
%        individuals with sex $. The matrix has dimensions age_cats by
%        smax+1 (for product 1) or age_cats by mmax+1 (for product 2). Rows
%        correspond to age, and columns correspond to current (column 1)
%        and former use. Column 2 contains relative risks for individuals
%        who are former users of product $ and quit less than 1 year ago;
%        column 2 contains relative risks for former users of product $ who
%        quit 1 to 2 years ago; and so forth.
% die_nprod1_$: vector containing the age-specific mortality rate for an
%        individual who has never used either tobacco product considered in
%        the analysis. The vector has length age_cats, and value in the ith
%        row denotes the rate of dying during a one year period for an
%        individual with sex $ and age i-1 and that has never used either
%        product


    die_nprod1_f=raw.die_nprod1_f;
    die_nprod1_m=raw.die_nprod1_m;

    rr_prod1_f=raw.rr_prod1_f;
    rr_prod1_m=raw.rr_prod1_m;

    rr_prod2_f=raw.rr_prod2_f;
    rr_prod2_m=raw.rr_prod2_m;
end