function [ip_f, ip_m] = init_pop(age_cats, smax, mmax,...
    prod1_prev_f, prod1_prev_m, prod2_prev_f, prod2_prev_m,...
    frmr_prod1_dist_f, frmr_prod1_dist_m, frmr_prod2_dist_f, frmr_prod2_dist_m, ...
    raw)
% This function creates the initial population matrix from a combination of raw inputs and previously calculated values.
% This function is uniquely defined in each package.
% Inputs:
% age_cats: integer equal to the number of rows in raw.frmr_prod1_dist_f/m.
%        This integer is used throughout Athena to specify the number of
%        age categories used in population update calculations.
% smax: integer equal to the number of columns in raw.frmr_prod1_dist_f/m.
%        This integer is used to specify how many former product 1 states
%        are being tracked.
% mmax: integer equal to the number of columns in raw.frmr_prod2_dist_f/m.
%        This integer is used to specify how many former product 2 states
%        are being tracked.
% prod1_prev_$: sex $ specific matrices of size age_cats by (smax+2) output
%        by pop_data_load above.
% prod2_prev_$: sex $ specific matrices of size age_cats by (mmax+2) output
%        by pop_data_load above.
% frmr_prod1_dist_$: sex $ specific matrices of size age_cats by smax
%        output by pop_data_load above.
% frmr_prod2_dist_$: sex $ specific matrices of size age_cats by mmax
%        output by pop_data_load above.
% raw: This input is the same MATLAB struct returned by load_rsrc_func. The
%        function requires the following fields be present within the
%        struct for a 2-product run using a 2-product prevalence matrix.
%      � twoprod_prev_mat_f
%      � twoprod_prev_mat_m
%      � pop_2k_f
%      � pop_2k_m
% Outputs:
% ip_f and ip_m: these two matrices contain the number of people in the
%        initial population by age, sex, and 2-product use state. The
%        matrices have dimensions age_cats by (smax+2)*(mmax+2). Rows
%        correspond to age, and columns correspond to two-product use
%        states.
%      � Product 2 use is set to never for the first smax+2 columns, and
%        product 1 use varies by column (never in 1st column, current in
%        2nd column, former having quit less than 1 year ago in 3rd column,
%        former having quit between 1 and 2 years ago in 4th column, and so
%        forth.
%      � In the 2nd smax+2 group, product 2 usage is set to current, and
%      product 1 usage follows the same pattern as the 1st smax+2 columns.
%      The next smax+2 group has product 2 use set to former having quit
%      less than 1 year ago, and product 1 usage follows the same pattern
%      as the 1st smax+2 group. This pattern is repeated until all product
%      1 and 2 usage combinations are completed.

prev_f=zeros(age_cats,(smax+2)*(mmax+2));
prev_m=prev_f;

%0-17 from independent use stats
for i=1:mmax+2
    prev_f(1:18,1+(i-1)*(smax+2):i*(smax+2))=bsxfun(@times,prod1_prev_f(1:18,:),prod2_prev_f(1:18,i));
    prev_m(1:18,1+(i-1)*(smax+2):i*(smax+2))=bsxfun(@times,prod1_prev_m(1:18,:),prod2_prev_m(1:18,i));
end

% For 2015 baseline:
prev_f(10:18,smax+2+2) = [0.001; 0.001; 0.001; 0.001; 0.001; 0.002; 0.004; 0.012; 0.007];
prev_m(10:18,smax+2+2) = [0.004; 0.004; 0.004; 0.004; 0.002; 0.005; 0.015; 0.024; 0.034];

%18+ from sheets 'Scenario Cig-Other Com - Female' and
% 'Scenario Cig-Other Com - Male' in file NHIS2000Prevalence.xlsx
% 1)	Initial Population (for year 2000)
%     a.	For ages 0-17, assume cigarette numbers that we have in current simulation. For combustibles, assume
%         i.	Current prevalence age i= [prevalence current cig age i]/[ prevalence current cig age 18]*current combustible prevalence age 18
%         ii.	Former prevalence is analogously defined for combustibles
%         iii.	Assume all former combustible users quit 0 years ago. We should track other combustible users for 0 and 1+ years quit (like we do with smokeless).
%     b.	For ages 18+, use the prevalence data in �NHISPrevalence2000.xlsx� file, �Scenario Combust � Smokeless� sheets, i.e.,
%         i.	Population (X/Y)=prev(X/Y) * population in 2000 when X,Y ?F
%         ii.	Population (F=j/Y)= prev(F/Y)*population in 2000*Prob(F=j|X=F) when Y ?F
%             1.	Where Prob(F=j|X=F) = smoking distribution value for j years quit [on �Smoking-Males�] divided by the number of years in that age range. For example, Prob(	=3|X=F) =.886/5=.1772 for males age 18-24.
%         iii.	Population (X/F=j)= prev(X/F)*population in 2000*alpha when X ?F where
%             1.	Alpha=0.1 if j=0 and alpha=.9 if j=1+
%         iv.	Population (F=k/F=j)= prev(F/Y)*population in 2000* Prob(F=k|X=F)* alpha
%             1.	Where Prob(F=k|X=F)  and alpha defined as in ii and iii

% This section is now handled in load_base_data.m
%     ocfname='NHIS2000Prevalence.xlsx';
%     prev_mat_f=xlsread(ocfname,'','com_smkless_prev_f');
%     prev_mat_m=xlsread(ocfname,'','com_smkless_prev_m');
prev_mat_f=raw.twoprod_prev_mat_f;
prev_mat_m=raw.twoprod_prev_mat_m;

%nn
prev_f(19:25,1)=prev_mat_f(1,9)*ones(7,1);
prev_m(19:25,1)=prev_mat_m(1,9)*ones(7,1);
prev_f(26:35,1)=prev_mat_f(2,9)*ones(10,1);
prev_m(26:35,1)=prev_mat_m(2,9)*ones(10,1);
prev_f(36:45,1)=prev_mat_f(3,9)*ones(10,1);
prev_m(36:45,1)=prev_mat_m(3,9)*ones(10,1);
prev_f(46:55,1)=prev_mat_f(4,9)*ones(10,1);
prev_m(46:55,1)=prev_mat_m(4,9)*ones(10,1);
prev_f(56:65,1)=prev_mat_f(5,9)*ones(10,1);
prev_m(56:65,1)=prev_mat_m(5,9)*ones(10,1);
prev_f(66:75,1)=prev_mat_f(6,9)*ones(10,1);
prev_m(66:75,1)=prev_mat_m(6,9)*ones(10,1);
prev_f(76:85,1)=prev_mat_f(7,9)*ones(10,1);
prev_m(76:85,1)=prev_mat_m(7,9)*ones(10,1);
prev_f(86:end,1)=prev_mat_f(8,9)*ones(16,1);
prev_m(86:end,1)=prev_mat_m(8,9)*ones(16,1);

%cn
prev_f(19:25,2)=prev_mat_f(1,3)*ones(7,1);
prev_m(19:25,2)=prev_mat_m(1,3)*ones(7,1);
prev_f(26:35,2)=prev_mat_f(2,3)*ones(10,1);
prev_m(26:35,2)=prev_mat_m(2,3)*ones(10,1);
prev_f(36:45,2)=prev_mat_f(3,3)*ones(10,1);
prev_m(36:45,2)=prev_mat_m(3,3)*ones(10,1);
prev_f(46:55,2)=prev_mat_f(4,3)*ones(10,1);
prev_m(46:55,2)=prev_mat_m(4,3)*ones(10,1);
prev_f(56:65,2)=prev_mat_f(5,3)*ones(10,1);
prev_m(56:65,2)=prev_mat_m(5,3)*ones(10,1);
prev_f(66:75,2)=prev_mat_f(6,3)*ones(10,1);
prev_m(66:75,2)=prev_mat_m(6,3)*ones(10,1);
prev_f(76:85,2)=prev_mat_f(7,3)*ones(10,1);
prev_m(76:85,2)=prev_mat_m(7,3)*ones(10,1);
prev_f(86:end,2)=prev_mat_f(8,3)*ones(16,1);
prev_m(86:end,2)=prev_mat_m(8,3)*ones(16,1);

%fn
fn_prev_18_f=prev_mat_f(1,6);
fn_prev_18_m=prev_mat_m(1,6);
fn_prev_25_f=prev_mat_f(2,6);
fn_prev_25_m=prev_mat_m(2,6);
fn_prev_35_f=prev_mat_f(3,6);
fn_prev_35_m=prev_mat_m(3,6);
fn_prev_45_f=prev_mat_f(4,6);
fn_prev_45_m=prev_mat_m(4,6);
fn_prev_55_f=prev_mat_f(5,6);
fn_prev_55_m=prev_mat_m(5,6);
fn_prev_65_f=prev_mat_f(6,6);
fn_prev_65_m=prev_mat_m(6,6);
fn_prev_75_f=prev_mat_f(7,6);
fn_prev_75_m=prev_mat_m(7,6);
fn_prev_85_f=prev_mat_f(8,6);
fn_prev_85_m=prev_mat_m(8,6);
for i=1:smax
    prev_f(19:25,2+i)=fn_prev_18_f*frmr_prod1_dist_f(19:25,i);
    prev_m(19:25,2+i)=fn_prev_18_m*frmr_prod1_dist_m(19:25,i);
    prev_f(26:35,2+i)=fn_prev_25_f*frmr_prod1_dist_f(26:35,i);
    prev_m(26:35,2+i)=fn_prev_25_m*frmr_prod1_dist_m(26:35,i);
    prev_f(36:45,2+i)=fn_prev_35_f*frmr_prod1_dist_f(36:45,i);
    prev_m(36:45,2+i)=fn_prev_35_m*frmr_prod1_dist_m(36:45,i);
    prev_f(46:55,2+i)=fn_prev_45_f*frmr_prod1_dist_f(46:55,i);
    prev_m(46:55,2+i)=fn_prev_45_m*frmr_prod1_dist_m(46:55,i);
    prev_f(56:65,2+i)=fn_prev_55_f*frmr_prod1_dist_f(56:65,i);
    prev_m(56:65,2+i)=fn_prev_55_m*frmr_prod1_dist_m(56:65,i);
    prev_f(66:75,2+i)=fn_prev_65_f*frmr_prod1_dist_f(66:75,i);
    prev_m(66:75,2+i)=fn_prev_65_m*frmr_prod1_dist_m(66:75,i);
    prev_f(76:85,2+i)=fn_prev_75_f*frmr_prod1_dist_f(76:85,i);
    prev_m(76:85,2+i)=fn_prev_75_m*frmr_prod1_dist_m(76:85,i);
    prev_f(86:end,2+i)=fn_prev_85_f*frmr_prod1_dist_f(86:end,i);
    prev_m(86:end,2+i)=fn_prev_85_m*frmr_prod1_dist_m(86:end,i);
end

%nc
prev_f(19:25,1+(smax+2))=prev_mat_f(1,7)*ones(7,1);
prev_m(19:25,1+(smax+2))=prev_mat_m(1,7)*ones(7,1);
prev_f(26:35,1+(smax+2))=prev_mat_f(2,7)*ones(10,1);
prev_m(26:35,1+(smax+2))=prev_mat_m(2,7)*ones(10,1);
prev_f(36:45,1+(smax+2))=prev_mat_f(3,7)*ones(10,1);
prev_m(36:45,1+(smax+2))=prev_mat_m(3,7)*ones(10,1);
prev_f(46:55,1+(smax+2))=prev_mat_f(4,7)*ones(10,1);
prev_m(46:55,1+(smax+2))=prev_mat_m(4,7)*ones(10,1);
prev_f(56:65,1+(smax+2))=prev_mat_f(5,7)*ones(10,1);
prev_m(56:65,1+(smax+2))=prev_mat_m(5,7)*ones(10,1);
prev_f(66:75,1+(smax+2))=prev_mat_f(6,7)*ones(10,1);
prev_m(66:75,1+(smax+2))=prev_mat_m(6,7)*ones(10,1);
prev_f(76:85,1+(smax+2))=prev_mat_f(7,7)*ones(10,1);
prev_m(76:85,1+(smax+2))=prev_mat_m(7,7)*ones(10,1);
prev_f(86:end,1+(smax+2))=prev_mat_f(8,7)*ones(16,1);
prev_m(86:end,1+(smax+2))=prev_mat_m(8,7)*ones(16,1);

%cc
prev_f(19:25,2+(smax+2))=prev_mat_f(1,1)*ones(7,1);
prev_m(19:25,2+(smax+2))=prev_mat_m(1,1)*ones(7,1);
prev_f(26:35,2+(smax+2))=prev_mat_f(2,1)*ones(10,1);
prev_m(26:35,2+(smax+2))=prev_mat_m(2,1)*ones(10,1);
prev_f(36:45,2+(smax+2))=prev_mat_f(3,1)*ones(10,1);
prev_m(36:45,2+(smax+2))=prev_mat_m(3,1)*ones(10,1);
prev_f(46:55,2+(smax+2))=prev_mat_f(4,1)*ones(10,1);
prev_m(46:55,2+(smax+2))=prev_mat_m(4,1)*ones(10,1);
prev_f(56:65,2+(smax+2))=prev_mat_f(5,1)*ones(10,1);
prev_m(56:65,2+(smax+2))=prev_mat_m(5,1)*ones(10,1);
prev_f(66:75,2+(smax+2))=prev_mat_f(6,1)*ones(10,1);
prev_m(66:75,2+(smax+2))=prev_mat_m(6,1)*ones(10,1);
prev_f(76:85,2+(smax+2))=prev_mat_f(7,1)*ones(10,1);
prev_m(76:85,2+(smax+2))=prev_mat_m(7,1)*ones(10,1);
prev_f(86:end,2+(smax+2))=prev_mat_f(8,1)*ones(16,1);
prev_m(86:end,2+(smax+2))=prev_mat_m(8,1)*ones(16,1);

%fc
fc_prev_18_f=prev_mat_f(1,4);
fc_prev_18_m=prev_mat_m(1,4);
fc_prev_25_f=prev_mat_f(2,4);
fc_prev_25_m=prev_mat_m(2,4);
fc_prev_35_f=prev_mat_f(3,4);
fc_prev_35_m=prev_mat_m(3,4);
fc_prev_45_f=prev_mat_f(4,4);
fc_prev_45_m=prev_mat_m(4,4);
fc_prev_55_f=prev_mat_f(5,4);
fc_prev_55_m=prev_mat_m(5,4);
fc_prev_65_f=prev_mat_f(6,4);
fc_prev_65_m=prev_mat_m(6,4);
fc_prev_75_f=prev_mat_f(7,4);
fc_prev_75_m=prev_mat_m(7,4);
fc_prev_85_f=prev_mat_f(8,4);
fc_prev_85_m=prev_mat_m(8,4);
for i=1:smax
    prev_f(19:25,2+i+(smax+2))=fc_prev_18_f*frmr_prod1_dist_f(19:25,i);
    prev_m(19:25,2+i+(smax+2))=fc_prev_18_m*frmr_prod1_dist_m(19:25,i);
    prev_f(26:35,2+i+(smax+2))=fc_prev_25_f*frmr_prod1_dist_f(26:35,i);
    prev_m(26:35,2+i+(smax+2))=fc_prev_25_m*frmr_prod1_dist_m(26:35,i);
    prev_f(36:45,2+i+(smax+2))=fc_prev_35_f*frmr_prod1_dist_f(36:45,i);
    prev_m(36:45,2+i+(smax+2))=fc_prev_35_m*frmr_prod1_dist_m(36:45,i);
    prev_f(46:55,2+i+(smax+2))=fc_prev_45_f*frmr_prod1_dist_f(46:55,i);
    prev_m(46:55,2+i+(smax+2))=fc_prev_45_m*frmr_prod1_dist_m(46:55,i);
    prev_f(56:65,2+i+(smax+2))=fc_prev_55_f*frmr_prod1_dist_f(56:65,i);
    prev_m(56:65,2+i+(smax+2))=fc_prev_55_m*frmr_prod1_dist_m(56:65,i);
    prev_f(66:75,2+i+(smax+2))=fc_prev_65_f*frmr_prod1_dist_f(66:75,i);
    prev_m(66:75,2+i+(smax+2))=fc_prev_65_m*frmr_prod1_dist_m(66:75,i);
    prev_f(76:85,2+i+(smax+2))=fc_prev_75_f*frmr_prod1_dist_f(76:85,i);
    prev_m(76:85,2+i+(smax+2))=fc_prev_75_m*frmr_prod1_dist_m(76:85,i);
    prev_f(86:end,2+i+(smax+2))=fc_prev_85_f*frmr_prod1_dist_f(86:end,i);
    prev_m(86:end,2+i+(smax+2))=fc_prev_85_m*frmr_prod1_dist_m(86:end,i);
end

%nf
nf_prev_18_f=prev_mat_f(1,8);
nf_prev_18_m=prev_mat_m(1,8);
nf_prev_25_f=prev_mat_f(2,8);
nf_prev_25_m=prev_mat_m(2,8);
nf_prev_35_f=prev_mat_f(3,8);
nf_prev_35_m=prev_mat_m(3,8);
nf_prev_45_f=prev_mat_f(4,8);
nf_prev_45_m=prev_mat_m(4,8);
nf_prev_55_f=prev_mat_f(5,8);
nf_prev_55_m=prev_mat_m(5,8);
nf_prev_65_f=prev_mat_f(6,8);
nf_prev_65_m=prev_mat_m(6,8);
nf_prev_75_f=prev_mat_f(7,8);
nf_prev_75_m=prev_mat_m(7,8);
nf_prev_85_f=prev_mat_f(8,8);
nf_prev_85_m=prev_mat_m(8,8);
for i=1:mmax
    prev_f(19:25,1+(i+1)*(smax+2))=nf_prev_18_f*frmr_prod2_dist_f(19:25,i);
    prev_m(19:25,1+(i+1)*(smax+2))=nf_prev_18_m*frmr_prod2_dist_m(19:25,i);
    prev_f(26:35,1+(i+1)*(smax+2))=nf_prev_25_f*frmr_prod2_dist_f(26:35,i);
    prev_m(26:35,1+(i+1)*(smax+2))=nf_prev_25_m*frmr_prod2_dist_m(26:35,i);
    prev_f(36:45,1+(i+1)*(smax+2))=nf_prev_35_f*frmr_prod2_dist_f(36:45,i);
    prev_m(36:45,1+(i+1)*(smax+2))=nf_prev_35_m*frmr_prod2_dist_m(36:45,i);
    prev_f(46:55,1+(i+1)*(smax+2))=nf_prev_45_f*frmr_prod2_dist_f(46:55,i);
    prev_m(46:55,1+(i+1)*(smax+2))=nf_prev_45_m*frmr_prod2_dist_m(46:55,i);
    prev_f(56:65,1+(i+1)*(smax+2))=nf_prev_55_f*frmr_prod2_dist_f(56:65,i);
    prev_m(56:65,1+(i+1)*(smax+2))=nf_prev_55_m*frmr_prod2_dist_m(56:65,i);
    prev_f(66:75,1+(i+1)*(smax+2))=nf_prev_65_f*frmr_prod2_dist_f(66:75,i);
    prev_m(66:75,1+(i+1)*(smax+2))=nf_prev_65_m*frmr_prod2_dist_m(66:75,i);
    prev_f(76:85,1+(i+1)*(smax+2))=nf_prev_75_f*frmr_prod2_dist_f(76:85,i);
    prev_m(76:85,1+(i+1)*(smax+2))=nf_prev_75_m*frmr_prod2_dist_m(76:85,i);
    prev_f(86:end,1+(i+1)*(smax+2))=nf_prev_85_f*frmr_prod2_dist_f(86:end,i);
    prev_m(86:end,1+(i+1)*(smax+2))=nf_prev_85_m*frmr_prod2_dist_m(86:end,i);
end

%cf
cf_prev_18_f=prev_mat_f(1,2);
cf_prev_18_m=prev_mat_m(1,2);
cf_prev_25_f=prev_mat_f(2,2);
cf_prev_25_m=prev_mat_m(2,2);
cf_prev_35_f=prev_mat_f(3,2);
cf_prev_35_m=prev_mat_m(3,2);
cf_prev_45_f=prev_mat_f(4,2);
cf_prev_45_m=prev_mat_m(4,2);
cf_prev_55_f=prev_mat_f(5,2);
cf_prev_55_m=prev_mat_m(5,2);
cf_prev_65_f=prev_mat_f(6,2);
cf_prev_65_m=prev_mat_m(6,2);
cf_prev_75_f=prev_mat_f(7,2);
cf_prev_75_m=prev_mat_m(7,2);
cf_prev_85_f=prev_mat_f(8,2);
cf_prev_85_m=prev_mat_m(8,2);
for i=1:mmax
    prev_f(19:25,2+(i+1)*(smax+2))=cf_prev_18_f*frmr_prod2_dist_f(19:25,i);
    prev_m(19:25,2+(i+1)*(smax+2))=cf_prev_18_m*frmr_prod2_dist_m(19:25,i);
    prev_f(26:35,2+(i+1)*(smax+2))=cf_prev_25_f*frmr_prod2_dist_f(26:35,i);
    prev_m(26:35,2+(i+1)*(smax+2))=cf_prev_25_m*frmr_prod2_dist_m(26:35,i);
    prev_f(36:45,2+(i+1)*(smax+2))=cf_prev_35_f*frmr_prod2_dist_f(36:45,i);
    prev_m(36:45,2+(i+1)*(smax+2))=cf_prev_35_m*frmr_prod2_dist_m(36:45,i);
    prev_f(46:55,2+(i+1)*(smax+2))=cf_prev_45_f*frmr_prod2_dist_f(46:55,i);
    prev_m(46:55,2+(i+1)*(smax+2))=cf_prev_45_m*frmr_prod2_dist_m(46:55,i);
    prev_f(56:65,2+(i+1)*(smax+2))=cf_prev_55_f*frmr_prod2_dist_f(56:65,i);
    prev_m(56:65,2+(i+1)*(smax+2))=cf_prev_55_m*frmr_prod2_dist_m(56:65,i);
    prev_f(66:75,2+(i+1)*(smax+2))=cf_prev_65_f*frmr_prod2_dist_f(66:75,i);
    prev_m(66:75,2+(i+1)*(smax+2))=cf_prev_65_m*frmr_prod2_dist_m(66:75,i);
    prev_f(76:85,2+(i+1)*(smax+2))=cf_prev_75_f*frmr_prod2_dist_f(76:85,i);
    prev_m(76:85,2+(i+1)*(smax+2))=cf_prev_75_m*frmr_prod2_dist_m(76:85,i);
    prev_f(86:end,2+(i+1)*(smax+2))=cf_prev_85_f*frmr_prod2_dist_f(86:end,i);
    prev_m(86:end,2+(i+1)*(smax+2))=cf_prev_85_m*frmr_prod2_dist_m(86:end,i);
end

%ff
ff_prev_18_f=prev_mat_f(1,5);
ff_prev_18_m=prev_mat_m(1,5);
ff_prev_25_f=prev_mat_f(2,5);
ff_prev_25_m=prev_mat_m(2,5);
ff_prev_35_f=prev_mat_f(3,5);
ff_prev_35_m=prev_mat_m(3,5);
ff_prev_45_f=prev_mat_f(4,5);
ff_prev_45_m=prev_mat_m(4,5);
ff_prev_55_f=prev_mat_f(5,5);
ff_prev_55_m=prev_mat_m(5,5);
ff_prev_65_f=prev_mat_f(6,5);
ff_prev_65_m=prev_mat_m(6,5);
ff_prev_75_f=prev_mat_f(7,5);
ff_prev_75_m=prev_mat_m(7,5);
ff_prev_85_f=prev_mat_f(8,5);
ff_prev_85_m=prev_mat_m(8,5);
for i=1:mmax
    for j=1:smax
        prev_f(19:25,2+j+(i+1)*(smax+2))=frmr_prod2_dist_f(19:25,i)*ff_prev_18_f.*frmr_prod1_dist_f(19:25,j);
        prev_m(19:25,2+j+(i+1)*(smax+2))=frmr_prod2_dist_m(19:25,i)*ff_prev_18_m.*frmr_prod1_dist_m(19:25,j);
        prev_f(26:35,2+j+(i+1)*(smax+2))=frmr_prod2_dist_f(26:35,i)*ff_prev_25_f.*frmr_prod1_dist_f(26:35,j);
        prev_m(26:35,2+j+(i+1)*(smax+2))=frmr_prod2_dist_m(26:35,i)*ff_prev_25_m.*frmr_prod1_dist_m(26:35,j);
        prev_f(36:45,2+j+(i+1)*(smax+2))=frmr_prod2_dist_f(36:45,i)*ff_prev_35_f.*frmr_prod1_dist_f(36:45,j);
        prev_m(36:45,2+j+(i+1)*(smax+2))=frmr_prod2_dist_m(36:45,i)*ff_prev_35_m.*frmr_prod1_dist_m(36:45,j);
        prev_f(46:55,2+j+(i+1)*(smax+2))=frmr_prod2_dist_f(46:55,i)*ff_prev_45_f.*frmr_prod1_dist_f(46:55,j);
        prev_m(46:55,2+j+(i+1)*(smax+2))=frmr_prod2_dist_m(46:55,i)*ff_prev_45_m.*frmr_prod1_dist_m(46:55,j);
        prev_f(56:65,2+j+(i+1)*(smax+2))=frmr_prod2_dist_f(56:65,i)*ff_prev_55_f.*frmr_prod1_dist_f(56:65,j);
        prev_m(56:65,2+j+(i+1)*(smax+2))=frmr_prod2_dist_m(56:65,i)*ff_prev_55_m.*frmr_prod1_dist_m(56:65,j);
        prev_f(66:75,2+j+(i+1)*(smax+2))=frmr_prod2_dist_f(66:75,i)*ff_prev_65_f.*frmr_prod1_dist_f(66:75,j);
        prev_m(66:75,2+j+(i+1)*(smax+2))=frmr_prod2_dist_m(66:75,i)*ff_prev_65_m.*frmr_prod1_dist_m(66:75,j);
        prev_f(76:85,2+j+(i+1)*(smax+2))=frmr_prod2_dist_f(76:85,i)*ff_prev_75_f.*frmr_prod1_dist_f(76:85,j);
        prev_m(76:85,2+j+(i+1)*(smax+2))=frmr_prod2_dist_m(76:85,i)*ff_prev_75_m.*frmr_prod1_dist_m(76:85,j);
        prev_f(86:end,2+j+(i+1)*(smax+2))=frmr_prod2_dist_f(86:end,i)*ff_prev_85_f.*frmr_prod1_dist_f(86:end,j);
        prev_m(86:end,2+j+(i+1)*(smax+2))=frmr_prod2_dist_m(86:end,i)*ff_prev_85_m.*frmr_prod1_dist_m(86:end,j);
    end
end

prev_f(19:end,:)=prev_f(19:end,:)/100;
prev_m(19:end,:)=prev_m(19:end,:)/100;

prev_f(:,1)=ones(age_cats,1)-sum(prev_f(:,2:(smax+2)*(mmax+2)),2);
prev_m(:,1)=ones(age_cats,1)-sum(prev_m(:,2:(smax+2)*(mmax+2)),2);

ip_f=bsxfun(@times,prev_f,raw.pop2k_f);
ip_m=bsxfun(@times,prev_m,raw.pop2k_m);

end