function [ c ] = policy_sa( c, policy_ind )


%s_year=6; % Baseline Simulation starts in 2021, so 6th year is 2026 for
%Policy start; This year was used from  when the model run for the 2nd time.

s_year=7;  % Baseline Simulation starts in 2021, so 7th year is 2027 for Policy start;
% This new start year for policy is implemented in October 2023.


k2=s_year;
k3=[s_year+1:100];

%Using medians of distributions
alpha_f=c.samps(1:2); %Fraction of smokers that quit in first year of policy (s_year)/after first year of policy (s_year+1. s_year+2, ...)
beta_f=c.samps(5:6); %fraction of quitters who switch noncombust in first year of policy (s_year)/after first year of policy (s_year+1. s_year+2, ...)
gamma_f=c.samps(9:10); %fraction of continuing smokers who become dual users in first year of policy (s_year)/after first year of policy (s_year+1. s_year+2, ...)
delta_f=c.samps(13:14); %smoking initiation reduction factor in first year of policy (s_year)/after first year of policy (s_year+1. s_year+2, ...)
epsilon_f=c.samps(17:18); %fraction of dissuaded initiates who become non combustible users in first year of policy (s_year)/after first year of policy (s_year+1. s_year+2, ...)

alpha_m=c.samps(3:4); %Fraction of smokers that quit in first year of policy (s_year)/after first year of policy (s_year+1. s_year+2, ...)
beta_m=c.samps(7:8); %fraction of quitters who switch noncombust in first year of policy (s_year)/after first year of policy (s_year+1. s_year+2, ...)
gamma_m=c.samps(11:12); %fraction of continuing smokers who become dual users in first year of policy (s_year)/after first year of policy (s_year+1. s_year+2, ...)
delta_m=c.samps(15:16); %smoking initiation reduction factor in first year of policy (s_year)/after first year of policy (s_year+1. s_year+2, ...)
epsilon_m=c.samps(19:20);


c.trans_prob_f=pol_calc(c.trans_prob_f,k2, policy_ind,alpha_f(1),beta_f(1),gamma_f(1),delta_f(1),epsilon_f(1));
c.trans_prob_f=pol_calc(c.trans_prob_f,k3, policy_ind,alpha_f(2),beta_f(2),gamma_f(2),delta_f(2),epsilon_f(2));

c.trans_prob_m=pol_calc(c.trans_prob_m,k2, policy_ind,alpha_m(1),beta_m(1),gamma_m(1),delta_m(1),epsilon_m(1));
c.trans_prob_m=pol_calc(c.trans_prob_m,k3, policy_ind,alpha_m(2),beta_m(2),gamma_m(2),delta_m(2),epsilon_m(2));



    function [probs]=pol_calc(probs,time_ind,policy_ind, alpha, beta, gamma, delta, epsilon)

        [age_cats,~,~]=size(probs);

        a1=9:31;
        la=length(a1);


        probs=probs;


        if policy_ind==0
        end
        if policy_ind~=0

            probs(:,4,time_ind)=(1-delta)*epsilon*probs(:,2,time_ind)...
                +probs(:,4,time_ind)+(1-delta)*probs(:,5,time_ind); % nn:nc (a)
            probs(:,2,time_ind)=(delta)*probs(:,2,time_ind);        % nn:cn (b)
            probs(:,5,time_ind)=(delta)*probs(:,5,time_ind);        % nn:cc (e)
            probs(:,1,time_ind)=1-probs(:,2,time_ind)-probs(:,4,time_ind)-probs(:,5,time_ind);%nn:nn


            probs(:,32,time_ind)=(delta)*probs(:,32,time_ind);      % nc:cc (i)
            probs(:,35,time_ind)=(delta)*probs(:,35,time_ind);      %nc:cf (c)
            probs(:,31,time_ind)=1-probs(:,32,time_ind)-probs(:,34,time_ind)-probs(:,35,time_ind);% nc:nc

            probs(:,62,time_ind)=(delta)*probs(:,62,time_ind);      % nf:cf (h)
            probs(:,61,time_ind)=1-probs(:,62,time_ind);            % nf:nf

            cf1=probs(:,12,time_ind)+probs(:,15,time_ind);
            hold1=min(alpha*cf1,1);

            %     probs(:,12,time_ind)=alpha*(1-beta);
            %     probs(:,15,time_ind)=alpha*beta;
            %     probs(:,14,time_ind)=(1-alpha)*gamma;


            % changed in 2/26/2019 to reflect the new formulas proposed by Stats
            % last updated in 4/9/2019 to reflect the new formulas proposed by Stats

            %probs(:,12,time_ind)=hold1*(1-beta);
            %probs(:,15,time_ind)=hold1*beta;
            %probs(:,14,time_ind)=(1-hold1)*gamma;
            %probs(:,11,time_ind)=1-probs(:,12,time_ind)-probs(:,14,time_ind)-probs(:,15,time_ind);
            nc2 = probs(:,14,time_ind)+probs(:,15,time_ind);
            betastar = beta; %min(beta*nc2,1);
            gammastar = gamma; %min(gamma*nc2,1);

            f_baseline =probs(:,12,time_ind);   % added on 11/22/2023
            probs(:,12,time_ind)=hold1.*(1-betastar);   % cn:fn (f) %=hold1*(1-beta);
            probs(:,15,time_ind)=hold1.*betastar;       % cn:fc (g)

            % Added on 11/22/2023: Some experts provided lower cessation rates but higher
            % swithcing rates; and comapring rates shows that for some
            % cases hold1.*(1-betastar) < f_baseline although hold1 >= cf1. The following
            % constraint is added to get f_policy >= f_baseline and g is
            % redefined. Note: hold1 = f+ g.
            probs(:,12,time_ind)=max(probs(:,12,time_ind),f_baseline);  % cn:fn (f)
            probs(:,15,time_ind) = hold1- probs(:,12,time_ind);      % cn:fc (g)

            probs(:,14,time_ind)=(1-hold1).*gammastar;  % cn:cc (j)
            probs(:,11,time_ind)=1-probs(:,12,time_ind)-probs(:,14,time_ind)-probs(:,15,time_ind); % cn:cn

            dd=find(probs(:,11,time_ind)<0);
            if length(dd)~=0
                if abs(min(min(probs(:,11,:))))<1e-10
                    probs(:,11,time_ind)=max(probs(:,11,time_ind),0);
                end
            end

            cf2=probs(:,44,time_ind)+probs(:,45,time_ind);

            %     probs(:,45,time_ind)=alpha*cf2;
            %     probs(:,44,time_ind)=(1-alpha)*cf2;
            %     probs(:,42,time_ind)=alpha*(1-cf2);

            probs(:,45,time_ind)=hold1.*cf2;        % cc:ff (p)
            probs(:,42,time_ind)=hold1.*(1-cf2);    % cc:fc (n)
            probs(:,44,time_ind)=(1-hold1).*cf2;    % cc:cf (m)
            probs(:,41,time_ind)=1-probs(:,42,time_ind)-probs(:,44,time_ind)-probs(:,45,time_ind); % cc:cc
            dd=find(probs(:,41,time_ind)<0);
            if length(dd)~=0
                if abs(min(min(probs(:,41,:))))<1e-10
                    probs(:,41,time_ind)=max(probs(:,41,time_ind),0);
                end
            end
            cf_ff_baseline=probs(:,72,time_ind); % added on 11/22/2023
            if time_ind==s_year %6  %7
                probs(:,69,time_ind)=hold1.*betastar;   % cf:fc
                probs(:,72,time_ind)=hold1.*(1-betastar);   % cf:ff (l)
                % Added on 11/22/2023: Some experts provided lower cessation rates but higher
                % swithcing rates; and comapring rates shows that for some
                % cases hold1.*(1-betastar) < cf_ff_baseline although hold1 >= cf1. The following
                % constraint is added to get cf_ff_policy >= cf_ff_baseline and g is
                % redefined. Note: hold1 = probs_69 + probs_72.
                probs(:,72,time_ind) =max(probs(:,72,time_ind),cf_ff_baseline);
                probs(:,69,time_ind)=hold1- probs(:,72,time_ind);


                probs(:,68,time_ind)=(1-hold1).*gammastar;  % cf:cc
                probs(:,71,time_ind)=1-probs(:,68,time_ind)-probs(:,69,time_ind)-probs(:,72,time_ind); %cf:cf

                dd=find(probs(:,71,time_ind)<0);
                if length(dd)~=0
                    if abs(min(min(probs(:,71,:))))<1e-10
                        probs(:,71,time_ind)=max(probs(:,71,time_ind),0);
                    end
                end
            else
                probs(:,72,time_ind)=hold1;
                probs(:,71,time_ind)=1-probs(:,68,time_ind)-probs(:,69,time_ind)-probs(:,72,time_ind);
            end

            %     if time_ind==7
            %         probs(:,69,time_ind)=alpha*beta;
            %         probs(:,72,time_ind)=alpha*(1-beta);
            %         probs(:,68,time_ind)=(1-alpha)*gamma;
            %         probs(:,71,time_ind)=1-probs(:,68,time_ind)-probs(:,69,time_ind)-probs(:,72,time_ind);
            %     else
            %         probs(:,72,time_ind)=alpha;
            %         probs(:,71,time_ind)=1-probs(:,68,time_ind)-probs(:,69,time_ind)-probs(:,72,time_ind);
            %     end


        end

        %     zz=sum(probs,2);
        %
        %     for i=1:200
        %         zz=sum(probs(:,:,i),2);
        %         ff(i)=max(abs(zz-9));
        %     end
        % gg=max(ff)
        %     pause



        ff=find( (probs>1) | (probs<0));
        if length(ff)~=0
            error('transition probability error');
        end
    end

end


