function [ c ] = policy( c, policy_ind )
% This function changes the base transition probabilities to reflect scenario specific conditions.
% This function call is assigned by Athena property policy_func and the
% code defaults to @policy.
% Inputs:
% c: This input is a MATLAB struct containing two fields c.trans_prob_$
%        which contain the unmodified transition probabilities for sex $.
% policy_index: number indicating which of the scenarios indicated by
%        Athena property policy_count is currently being run. Functionality
%        reflects conditions defined in the desired scenario.
% Outputs:
% c: the same c.trans_prob_$ struct with values modified relative to the
%        specific scenario.

if policy_index==1 || policy_index==6 || policy_index==7
    k=[16:51];
    c.trans_prob_f(:,2,k)=0.5*c.trans_prob_f(:,2,k);
    c.trans_prob_f(:,1,k)=1-c.trans_prob_f(:,2,k)-c.trans_prob_f(:,4,k)-c.trans_prob_f(:,5,k);
end

s_year=7; %Simulation starts in 2012, so 4th year is 2021;
k2=s_year;
k3=[s_year+1:100];

%Using medians of distributions
alpha=[0.3 .1]; %Fraction of smokers that quit in first year of policy (s_year)/after first year of policy (s_year+1. s_year+2, ...)
beta=[0.45 0.25]; %fraction of quitters who switch noncombust in first year of policy (s_year)/after first year of policy (s_year+1. s_year+2, ...)
gamma=[0.36 0.15]; %fraction of continuing smokers who become dual users in first year of policy (s_year)/after first year of policy (s_year+1. s_year+2, ...)
delta=[0.48 0.54]; %smoking initiation reduction factor in first year of policy (s_year)/after first year of policy (s_year+1. s_year+2, ...)
epsilon=[0.35 0.35]; %fraction of dissuaded initiates who become non combustible users in first year of policy (s_year)/after first year of policy (s_year+1. s_year+2, ...)



pctiles=[0 5 25 50 75 95 100]/100;

vals=[  0.06	0.07	0.17	0.30	0.45	0.53	0.58
    0.05	0.06	0.07	0.10	0.15	0.20	0.23
    0.08	0.13	0.23	0.45	0.63	0.70	0.78
    0.10	0.15	0.20	0.25	0.30	0.35	0.40
    0.01	0.11	0.20	0.36	0.50	0.64	0.73
    0.00	0.04	0.12	0.15	0.21	0.27	0.31
    0.17    0.22    0.34    0.48    0.62    0.74    0.82
    0.25    0.31    0.41    0.54    0.71    0.87    0.98
    0.03	0.08	0.15	0.35	0.48	0.58	0.73
    0.03	0.08	0.15	0.35	0.48	0.58	0.73];

c.trans_prob_f=pol_calc(c.trans_prob_f,k2, policy_ind,alpha(1),beta(1),gamma(1),delta(1),epsilon(1));
c.trans_prob_f=pol_calc(c.trans_prob_f,k3, policy_ind,alpha(2),beta(2),gamma(2),delta(2),epsilon(2));

c.trans_prob_m=pol_calc(c.trans_prob_m,k2, policy_ind,alpha(1),beta(1),gamma(1),delta(1),epsilon(1));
c.trans_prob_m=pol_calc(c.trans_prob_m,k3, policy_ind,alpha(2),beta(2),gamma(2),delta(2),epsilon(2));




    function [probs]=pol_calc(probs,time_ind,policy_ind, alpha, beta, gamma, delta, epsilon);


        a1=9:31;
        la=length(a1);


        probs=probs;


        if policy_ind==0
        end
        if policy_ind~=0

            probs(:,4,time_ind)=(1-delta)*epsilon*probs(:,2,time_ind)...
                +probs(:,4,time_ind)+(1-delta)*probs(:,5,time_ind);
            probs(:,2,time_ind)=(delta)*probs(:,2,time_ind);
            probs(:,5,time_ind)=(delta)*probs(:,5,time_ind);
            probs(:,1,time_ind)=1-probs(:,2,time_ind)-probs(:,4,time_ind)-probs(:,5,time_ind);


            probs(:,32,time_ind)=(delta)*probs(:,32,time_ind);
            probs(:,35,time_ind)=(delta)*probs(:,35,time_ind);
            probs(:,31,time_ind)=1-probs(:,32,time_ind)-probs(:,34,time_ind)-probs(:,35,time_ind);

            probs(:,62,time_ind)=(delta)*probs(:,62,time_ind);
            probs(:,61,time_ind)=1-probs(:,62,time_ind);

            probs(:,12,time_ind)=alpha*(1-beta);
            probs(:,15,time_ind)=alpha*beta;
            probs(:,14,time_ind)=(1-alpha)*gamma;
            probs(:,11,time_ind)=1-probs(:,12,time_ind)-probs(:,14,time_ind)-probs(:,15,time_ind);

            cf2=probs(:,44,time_ind)+probs(:,45,time_ind);
            probs(:,45,time_ind)=alpha*cf2;
            probs(:,44,time_ind)=(1-alpha)*cf2;
            probs(:,42,time_ind)=alpha*(1-cf2);
            %probs(:,42,time_ind)=alpha-probs(:,45,time_ind);
            probs(:,41,time_ind)=1-probs(:,42,time_ind)-probs(:,44,time_ind)-probs(:,45,time_ind);

            if time_ind==7
                probs(:,69,time_ind)=alpha*beta;
                probs(:,72,time_ind)=alpha*(1-beta);
                probs(:,68,time_ind)=(1-alpha)*gamma;
                probs(:,71,time_ind)=1-probs(:,68,time_ind)-probs(:,69,time_ind)-probs(:,72,time_ind);
            else
                probs(:,72,time_ind)=alpha;
                probs(:,71,time_ind)=1-probs(:,68,time_ind)-probs(:,69,time_ind)-probs(:,72,time_ind);
            end
        end




        ff=find( (probs>1) | (probs<0));
        if length(ff)~=0
            error('transition probability error');
        end
    end

end


