function [die_prob_f, die_prob_m] ...
    = new_mort_probs_prod_stand_func(age_cats, smax, mmax, raw)
%Creates mortality probabilities by assuming independence
%i.e., Prob(death|nn= Prob(death| for n, prod 1)* Prob(death| for n, prod2)
%      Prob(death|cf= Prob(death| for c, prod 1)* Prob(death| for f, prod2)
[~,s_check]=size(raw.rr_prod1_f);
[~,m_check]=size(raw.rr_prod2_f);
if s_check~=smax+1
    error('The dimensions of prod1 relative risk matrix don''t match smax. Check your inputs.')
end
if m_check~=mmax+1
    error('The dimensions of prod2 relative risk matrix don''t match mmax. Check your inputs.')
end


adj_fac_f=raw.adj_factor_f;
adj_fac_m=raw.adj_factor_m;

die_nprod1_f=raw.die_nprod1_f;
die_nprod1_m=raw.die_nprod1_m;

rr_prod2_f=raw.rr_prod2_f;
rr_prod2_m=raw.rr_prod2_m;

rr_prod1_f=raw.rr_prod1_f;
rr_prod1_m=raw.rr_prod1_m;

max_years=201;

rr_prod1_f_x=[ones(age_cats,1) rr_prod1_f ];
rr_prod1_m_x=[ones(age_cats,1) rr_prod1_m ];

rr_prod2_f_x=[ones(age_cats,1) rr_prod2_f ];
rr_prod2_m_x=[ones(age_cats,1) rr_prod2_m ];


[~, myears]=size(raw.msf_f);

base_rate_f=zeros(age_cats,max_years);
base_rate_m=zeros(age_cats,max_years);
base_prob_f=zeros(age_cats,max_years);
base_prob_m=zeros(age_cats,max_years);


for k=1:max_years
    if k<=myears
        base_rate_f(:,k)=die_nprod1_f.*adj_fac_f.*raw.msf_f(:,k);
        base_rate_m(:,k)=die_nprod1_m.*adj_fac_m.*raw.msf_m(:,k);

        for j=1:age_cats
            if j==1
                year_int_f=0.053 + 2.800 * base_rate_f(j,k);
                year_int_m=0.045 + 2.684 * base_rate_m(j,k);
            elseif j>=2 & j<=5
                year_int_f=(1.522 - 1.518 * base_rate_f(j,k))/4;
                year_int_m=(1.651 - 2.816 * base_rate_m(j,k))/4;
            else
                year_int_f=0.5;
                year_int_m=0.5;
            end
            age_int_leng=1;
            base_prob_f(j,k)= [age_int_leng*base_rate_f(j,k)]/[1+(age_int_leng-year_int_f)*base_rate_f(j,k)];
            base_prob_m(j,k)= [age_int_leng*base_rate_m(j,k)]/[1+(age_int_leng-year_int_m)*base_rate_m(j,k)];
        end
    else
        base_prob_f(:,k)=base_prob_f(:,myears);
        base_prob_m(:,k)=base_prob_m(:,myears);
    end
end


die_prob_f(age_cats,(mmax+2)*(smax+2),max_years)=0;
die_prob_m(age_cats,(mmax+2)*(smax+2),max_years)=0;


for k=1:max_years

    if k>=6 %Important: this implements use of different RRs when policy is implemented in 2026-6th year (starting in 2021)

        rr_prod1_f_x(:,2:end)=raw.rr_prod1_f_pol;
        rr_prod1_m_x(:,2:end)=raw.rr_prod1_m_pol;
    end


    if k<=myears
        for j=1:mmax+2
            if j==2
                hold_mat_f2(:,1)=bsxfun(@max, rr_prod1_f_x(:,1), rr_prod2_f_x(:,j));
                hold_mat_m2(:,1)=bsxfun(@max, rr_prod1_m_x(:,1), rr_prod2_m_x(:,j));
                dual_adj_fac=1;
                hold_mat_f2(:,2)=bsxfun(@max, dual_adj_fac*[rr_prod1_f_x(:,2)-1]+1, rr_prod2_f_x(:,j));
                hold_mat_m2(:,2)=bsxfun(@max, dual_adj_fac*[rr_prod1_m_x(:,2)-1]+1, rr_prod2_m_x(:,j));


                rr_fac=1.08;%1.3; %1.08; %parameter represents RR for F/C, RELATIVE TO F/N
                %Comes from Hunley et al. 2007
                hold_mat_f2(:,3:smax+2)=bsxfun(@max,bsxfun(@min,rr_fac*rr_prod1_f_x(:,3:smax+2),rr_prod1_f_x(:,2)),rr_prod2_f_x(:,2));
                hold_mat_m2(:,3:smax+2)=bsxfun(@max,bsxfun(@min,rr_fac*rr_prod1_m_x(:,3:smax+2),rr_prod1_m_x(:,2)),rr_prod2_m_x(:,2));

            else
                hold_mat_f2=bsxfun(@max, rr_prod1_f_x, rr_prod2_f_x(:,j));
                hold_mat_m2=bsxfun(@max, rr_prod1_m_x, rr_prod2_m_x(:,j));
            end


            if(nnz(hold_mat_f2<1)>0|nnz(hold_mat_m2<1)>0)
                error('There was a Relative Risk less than 1');
            end
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %             for zz=1:smax+2
            %                 hold_mat_f2(:,zz)=min(hold_mat_f2(:,zz),rr_prod1_f_x(:,2));
            %                 hold_mat_m2(:,zz)=min(hold_mat_m2(:,zz),rr_prod1_m_x(:,2));
            %             end
            %             if j==1 | j==2
            %                 hold_mat_f2(:,2)
            %                 pause
            %             end
            die_prob_f(:,1+(j-1)*(smax+2):j*(smax+2),k)=bsxfun(@times, hold_mat_f2, base_prob_f(:,k));
            die_prob_m(:,1+(j-1)*(smax+2):j*(smax+2),k)=bsxfun(@times, hold_mat_m2, base_prob_m(:,k));


        end
    else
        die_prob_f(:,:,k)=die_prob_f(:,:,myears);
        die_prob_m(:,:,k)=die_prob_m(:,:,myears);
    end
end

return


