function [ hold_f ]=main_pop_func( smax, mmax, ip_f, ...
    trans_prob_f, s_relmax, m_relmax)
% This function performs population transition calculations, for one year at a time for each sex, according to transition probabilities.
% It is only intended to be used by athena_2prod_func.
% Inputs:
% smax: integer equal to the number of columns in raw.frmr_prod1_dist_f/m.
%        This integer is used to specify how many former product 1 states
%        are being tracked.
% mmax: integer equal to the number of columns in raw.frmr_prod2_dist_f/m.
%        This integer is used to specify how many former product 2 states
%        are being tracked.
% ip_f: initial population from prior year.
% trans_prob_f: transition probabilities for the appropriate gender and year.
% s_relmax: a constant assigned to raw.s_relmax in load_raw_data that
%        specifies the maximum number of years after quitting product one a
%        person can start using product 1 again..
% s_relmax: a constant assigned to raw.s_relmax in load_raw_data that
%        specifies the maximum number of years after quitting product one a
%        person can start using product 2 again..
% Outputs:
% hold_f: new population matrix with transitions for the year completed.
%        Does not take death into account.


[age_cats,ww]=size(ip_f);


if m_relmax>mmax | m_relmax<0 | floor(m_relmax)~=m_relmax
    'invalid m_relmax value'
    return
end

if s_relmax>smax | s_relmax<0 | floor(s_relmax)~=s_relmax
    'invalid s_relmax value'
    return
end

hold_f=zeros(age_cats,(smax+2)*(mmax+2));

if s_relmax<smax
    alt21=trans_prob_f(:,20);
    alt24=trans_prob_f(:,23);
    alt51=trans_prob_f(:,50);
    alt54=trans_prob_f(:,53);
    alt81_s=trans_prob_f(:,80);
    %    alt81_s_over=trans_prob_f(:,77);
else
    alt21=zeros(age_cats,1);
    alt24=zeros(age_cats,1);
    alt51=zeros(age_cats,1);
    alt54=zeros(age_cats,1);
    alt81_s=zeros(age_cats,1);
    %    alt81_s_over=zeros(age_cats,1);
end

if m_relmax<mmax
    alt61=trans_prob_f(:,58);
    alt62=trans_prob_f(:,59);
    alt71=trans_prob_f(:,68);
    alt72=trans_prob_f(:,69);
    alt81_m=trans_prob_f(:,78);
    %    alt81_m_over=trans_prob_f(:,77);
else
    alt61=zeros(age_cats,1);
    alt62=zeros(age_cats,1);
    alt71=zeros(age_cats,1);
    alt72=zeros(age_cats,1);
    alt81_m=zeros(age_cats,1);
    %    alt81_m_over=zeros(age_cats,1);
end

if (s_relmax<smax) | (m_relmax<mmax)
    alt81_both = trans_prob_f(:,77);
else
    alt81_both =zeros(age_cats,1);
end






for i=1:m_relmax
    idx(1+(i-1)*s_relmax:i*s_relmax)=2*(smax+2)+(i-1)*(smax+2)+[3:2+s_relmax];
end





%%%Transitions to states where product 2 status =n
%nn
hold_f(:,1)=trans_prob_f(:,1).*ip_f(:,1);


%cn
hold_f(:,2)=trans_prob_f(:,2).*ip_f(:,1)+trans_prob_f(:,11).*ip_f(:,2);
if s_relmax>0
    hold_f(:,2)=hold_f(:,2)+sum(ip_f(:,3:2+s_relmax),2).*trans_prob_f(:,20);
end
%fn, f=1
hold_f(:,3)=trans_prob_f(:,12).*ip_f(:,2);

%fn, f=2:smax+2
hold_f(:,4:smax+2)=bsxfun(@times,ip_f(:,3:smax+1),trans_prob_f(:,21));
if s_relmax<smax
    hold_f(:,4:smax+2)=hold_f(:,4:smax+2)+bsxfun(@times,[zeros(age_cats,s_relmax) ip_f(:,3+s_relmax:smax+1)],alt21);
end
hold_f(:,smax+2)=hold_f(:,smax+2)+ip_f(:,smax+2).*[trans_prob_f(:,21)+alt21];





%%%Transitions to states where product 2 status =c
%nc
hold_f(:,1+smax+2)=trans_prob_f(:,4).*ip_f(:,1)+trans_prob_f(:,31).*ip_f(:,1+smax+2);
if m_relmax>0
    hold_f(:,1+smax+2)=hold_f(:,1+smax+2)...
        +sum(ip_f(:,1+2*(smax+2):smax+2:(smax+2)*(m_relmax+2)),2).*trans_prob_f(:,58);
end

%cc
hold_f(:,2+smax+2)=trans_prob_f(:,5).*ip_f(:,1)+trans_prob_f(:,14).*ip_f(:,2)...
    +trans_prob_f(:,32).*ip_f(:,1+smax+2)+trans_prob_f(:,41).*ip_f(:,2+smax+2);
if s_relmax>0
    hold_f(:,2+smax+2)=hold_f(:,2+smax+2)...
        +sum(ip_f(:,3:s_relmax+2),2).*trans_prob_f(:,23)...
        +sum(ip_f(:,3+smax+2:smax+2+2+s_relmax),2).*trans_prob_f(:,50);
end
if m_relmax>0
    hold_f(:,2+smax+2)=hold_f(:,2+smax+2)...
        +sum(ip_f(:,1+2*(smax+2):smax+2:(smax+2)*(m_relmax+2)),2).*trans_prob_f(:,59)...
        +sum(ip_f(:,2+2*(smax+2):smax+2:(smax+2)*(m_relmax+2)),2).*trans_prob_f(:,68);
end
if (s_relmax>0)& (m_relmax>0)
    hold_f(:,2+smax+2)=hold_f(:,2+smax+2)+sum(ip_f(:,idx),2).*trans_prob_f(:,77);
end





%fc, f=1
hold_f(:,3+smax+2)=trans_prob_f(:,15).*ip_f(:,2)+trans_prob_f(:,42).*ip_f(:,2+smax+2);


if m_relmax>0
    hold_f(:,3+smax+2)=hold_f(:,3+smax+2)...
        +sum(ip_f(:,2+2*(smax+2):smax+2:(smax+2)*(m_relmax+2)),2).*trans_prob_f(:,69);
end

%fc, f=2:smax+2

hold_f(:,4+smax+2:2*(smax+2))=bsxfun(@times,ip_f(:,3:smax+1),trans_prob_f(:,24))...
    +bsxfun(@times,ip_f(:,3+smax+2:smax+1+smax+2),trans_prob_f(:,51));
if s_relmax<smax
    hold_f(:,4+smax+2:2*(smax+2))=hold_f(:,4+smax+2:2*(smax+2))...
        +bsxfun(@times,[zeros(age_cats,s_relmax) ip_f(:,3+s_relmax:smax+1)],alt24)...
        +bsxfun(@times,[zeros(age_cats,s_relmax) ip_f(:,3+s_relmax+smax+2:smax+1+smax+2)],alt51);
end


hold_f(:,2*(smax+2))=hold_f(:,2*(smax+2))+ip_f(:,smax+2).*[trans_prob_f(:,24)+alt24]...
    +ip_f(:,2*(smax+2)).*[trans_prob_f(:,51)+alt51];

if m_relmax>0
    for i=1:m_relmax
        if smax==1
            idx2=(i+1)*(smax+2)+[3];
            hold_f(:,2*(smax+2))=hold_f(:,2*(smax+2))+ip_f(:,idx2).*trans_prob_f(:,78);
        else
            idx2=(i+1)*(smax+2)+[3:smax+1];
            hold_f(:,4+smax+2:2*(smax+2))=hold_f(:,4+smax+2:2*(smax+2))+...
                bsxfun(@times,ip_f(:,idx2),trans_prob_f(:,78));
            hold_f(:,2*(smax+2))=hold_f(:,2*(smax+2))+ip_f(:,idx2(end)+1).*trans_prob_f(:,78);
        end
    end
end




%nf, f=1
hold_f(:,1+2*(smax+2))=trans_prob_f(:,34).*ip_f(:,1+smax+2);
%nf, f=2:mmax+2
hold_f(:,1+[3:(mmax+1)]*(smax+2))=bsxfun(@times,ip_f(:,1+[2:(mmax)]*(smax+2)),trans_prob_f(:,61));
if m_relmax<mmax-1
    hold_f(:,1+[3:(mmax+1)]*(smax+2))=hold_f(:,1+[3:(mmax+1)]*(smax+2))...
        +bsxfun(@times,[zeros(age_cats,m_relmax) ip_f(:,1+[2+m_relmax:mmax]*(smax+2))],alt61);
end
hold_f(:,1+(mmax+1)*(smax+2))=hold_f(:,1+(mmax+1)*(smax+2))+ip_f(:,1+(mmax+1)*(smax+2)).*[trans_prob_f(:,61)+alt61];




%cf, f=1
hold_f(:,2+2*(smax+2))=trans_prob_f(:,35).*ip_f(:,1+smax+2)...
    +trans_prob_f(:,44).*ip_f(:,2+smax+2);
if s_relmax>0
    hold_f(:,2+2*(smax+2))=hold_f(:,2+2*(smax+2))...
        +sum(ip_f(:,3+smax+2:2+s_relmax+smax+2),2).*trans_prob_f(:,53);
end


%cf, f=2:mmax+2
hold_f(:,2+3*(smax+2):smax+2:(smax+2)*(mmax+2))=bsxfun(@times,ip_f(:,1+2*(smax+2):smax+2:(smax+2)*(mmax+1)),trans_prob_f(:,62))...
    +bsxfun(@times,ip_f(:,2+2*(smax+2):smax+2:(smax+2)*(mmax+1)),trans_prob_f(:,71));
if m_relmax<mmax-1
    hold_f(:,2+3*(smax+2):smax+2:(smax+2)*(mmax+2))=hold_f(:,2+3*(smax+2):smax+2:(smax+2)*(mmax+2))...
        +bsxfun(@times,[zeros(age_cats,m_relmax) ip_f(:,1+[2+m_relmax:mmax]*(smax+2))],alt62)...
        +bsxfun(@times,[zeros(age_cats,m_relmax) ip_f(:,2+[2+m_relmax:mmax]*(smax+2))],alt71);
end
hold_f(:,2+(smax+2)*(mmax+1))=hold_f(:,2+(smax+2)*(mmax+1))+ip_f(:,1+(smax+2)*(mmax+1)).*[trans_prob_f(:,62)+alt62]...
    +ip_f(:,2+(smax+2)*(mmax+1)).*[trans_prob_f(:,71)+alt71];


if s_relmax>0
    matty=zeros(age_cats,mmax-1);
    for i=1:mmax-1
        matty(:,i)=sum(ip_f(:,3+(smax+2)*(i+1):2+s_relmax+(smax+2)*(i+1)),2);
    end
    hold_f(:,2+3*(smax+2):smax+2:(smax+2)*(mmax+2))=hold_f(:,2+3*(smax+2):smax+2:(smax+2)*(mmax+2))+bsxfun(@times,matty,trans_prob_f(:,80));
    hold_f(:,2+(smax+2)*(mmax+1))=hold_f(:,2+(smax+2)*(mmax+1))+sum(ip_f(:,3+(smax+2)*(mmax+1):2+s_relmax+(smax+2)*(mmax+1)),2).*trans_prob_f(:,80);
end

%ff, f=1,f=1
hold_f(:,3+2*(smax+2))=trans_prob_f(:,45).*ip_f(:,2+smax+2);

%ff, f=2:smax/f=1
hold_f(:,4+2*(smax+2):3*(smax+2))=bsxfun(@times,ip_f(:,3+(smax+2):smax+1+(smax+2)),trans_prob_f(:,54));
if s_relmax<smax
    hold_f(:,4+2*(smax+2):3*(smax+2))=hold_f(:,4+2*(smax+2):3*(smax+2))...
        +bsxfun(@times,[zeros(age_cats,s_relmax) ip_f(:,3+s_relmax+smax+2:smax+1+smax+2)],alt54);
end
hold_f(:,3*(smax+2))=hold_f(:,3*(smax+2))+[trans_prob_f(:,54)+alt54].*ip_f(:,2*(smax+2));

%ff, f=1/f=2:mmax
hold_f(:,3+3*(smax+2):smax+2:(smax+2)*(mmax+2))=bsxfun(@times,ip_f(:,2+2*(smax+2):smax+2:(smax+2)*(mmax+1)),trans_prob_f(:,72));
if m_relmax<mmax-1
    hold_f(:,3+3*(smax+2):smax+2:(smax+2)*(mmax+2))=hold_f(:,3+3*(smax+2):smax+2:(smax+2)*(mmax+2))...
        +bsxfun(@times,[zeros(age_cats,m_relmax) ip_f(:,2+[2+m_relmax:mmax]*(smax+2))],alt72);
end
hold_f(:,3+(mmax+1)*(smax+2))=hold_f(:,3+(mmax+1)*(smax+2))+[trans_prob_f(:,72)+alt72].*ip_f(:,2+(smax+2)*(mmax+1));



%ff, f=2:smax,f=2:mmax
for j=2:mmax
    hold_f(:,4+(j+1)*(smax+2):(smax+2)*(j+2))=bsxfun(@times,ip_f(:,3+(j)*(smax+2):(smax+2)*(j+1)-1),trans_prob_f(:,81));
    hold_f(:,(smax+2)*(j+2))=hold_f(:,(smax+2)*(j+2))...
        +trans_prob_f(:,81).*ip_f(:,(smax+2)*(j+1));

    if j-1>m_relmax
        hold_f(:,4+(j+1)*(smax+2):(smax+2)*(j+2))=hold_f(:,4+(j+1)*(smax+2):(smax+2)*(j+2))...
            +bsxfun(@times,ip_f(:,3+(j)*(smax+2):(smax+2)*(j+1)-1),alt81_m);
        hold_f(:,(smax+2)*(j+2))=hold_f(:,(smax+2)*(j+2))...
            +alt81_m.*ip_f(:,(smax+2)*(j+1));
    end

    for i=2:smax
        if i-1>s_relmax
            hold_f(:,2+i+(j+1)*(smax+2))=hold_f(:,2+i+(j+1)*(smax+2))...
                +alt81_s.*ip_f(:,2+(i-1)+(j)*(smax+2));
        end
        if (i-1>s_relmax) | (j-1>m_relmax)
            hold_f(:,2+i+(j+1)*(smax+2))=hold_f(:,2+i+(j+1)*(smax+2))...
                +alt81_both.*ip_f(:,2+(i-1)+(j)*(smax+2));
        end
    end
    hold_f(:,(smax+2)*(j+2))=hold_f(:,(smax+2)*(j+2))...
        +alt81_s.*ip_f(:,(j+1)*(smax+2));

    if (smax>s_relmax) | (j-1>m_relmax)
        hold_f(:,(smax+2)*(j+2))=hold_f(:,(smax+2)*(j+2))...
            +alt81_both.*ip_f(:,(j+1)*(smax+2));
    end
end

hold_f(:,4+(mmax+1)*(smax+2):(smax+2)*(mmax+2))=hold_f(:,4+(mmax+1)*(smax+2):(smax+2)*(mmax+2))...
    +bsxfun(@times,ip_f(:,3+(mmax+1)*(smax+2):(smax+2)*(mmax+2)-1),trans_prob_f(:,81));
hold_f(:,(smax+2)*(mmax+2))=hold_f(:,(smax+2)*(mmax+2))...
    +trans_prob_f(:,81).*ip_f(:,(smax+2)*(mmax+2));

hold_f(:,4+(mmax+1)*(smax+2):(smax+2)*(mmax+2))=hold_f(:,4+(mmax+1)*(smax+2):(smax+2)*(mmax+2))...
    +bsxfun(@times,ip_f(:,3+(mmax+1)*(smax+2):(smax+2)*(mmax+2)-1),alt81_m);

hold_f(:,(smax+2)*(mmax+2))=hold_f(:,(smax+2)*(mmax+2))...
    +alt81_m.*ip_f(:,(smax+2)*(mmax+2));


for i=2:smax
    if (i-1>s_relmax)
        hold_f(:,2+i+(mmax+1)*(smax+2))=hold_f(:,2+i+(mmax+1)*(smax+2))...
            +alt81_s.*ip_f(:,2+(i-1)+(mmax+1)*(smax+2));
    end
end

hold_f(:,(smax+2)*(mmax+2))=hold_f(:,(smax+2)*(mmax+2))...
    +alt81_s.*ip_f(:,(smax+2)*(mmax+2));

for i=2:smax
    if (i-1>s_relmax) | (mmax>m_relmax)
        hold_f(:,2+i+(mmax+1)*(smax+2))=hold_f(:,2+i+(mmax+1)*(smax+2))...
            +alt81_both.*ip_f(:,2+(i-1)+(mmax+1)*(smax+2));
    end
end

hold_f(:,(smax+2)*(mmax+2))=hold_f(:,(smax+2)*(mmax+2))...
    +alt81_both.*ip_f(:,(smax+2)*(mmax+2));



end

