function [ raw ] ...
    = load_raw_data_initbyyear(rpath, rfile, fname, isClear)
%%% This script loads all of the fixed data from file into the workspace.

fname=[rpath,filesep,fname];
%     ocfname=[rpath,filesep,ocfname];

if exist([rpath, filesep, rfile],'file') == 0 || isClear
    % from old cig_smkless_mort_data_load.m,
    % cig_oc_mort_data_load.m, and com_smkless_mort_data_load.m

    raw.die_nprod1_f=xlsread(fname,'','die_nprod1_f');
    raw.die_nprod1_m=xlsread(fname,'','die_nprod1_m');

    raw.adj_factor_f=xlsread(fname,'','adj_factor_f');
    raw.adj_factor_m=xlsread(fname,'','adj_factor_m');

    raw.s_relmax=0;
    raw.m_relmax=2;

    raw.msf_f=xlsread(fname,'','msf_f');
    raw.msf_m=xlsread(fname,'','msf_m');

    raw.rr_prod1_f=xlsread(fname,'','rr_prod1_f');
    raw.rr_prod1_m=xlsread(fname,'','rr_prod1_m');

    raw.rr_prod1_f_pol=xlsread(fname,'','rr_prod1_f_pol');
    raw.rr_prod1_m_pol=xlsread(fname,'','rr_prod1_m_pol');


    raw.rr_prod2_f=xlsread(fname,'','rr_prod2_f');
    raw.rr_prod2_m=xlsread(fname,'','rr_prod2_m');

    % from old cig_smkless_pop_data_load.m,
    % cig_oc_pop_data_load.m, and com_smkless_pop_data_load.m

    raw.pop2k_f=xlsread(fname,'','pop2k_f');
    raw.pop2k_m=xlsread(fname,'','pop2k_m');

    raw.births_aux=xlsread(fname,'','births_aux'); % New input variable with projections for births (female+male)
    raw.birth_rate_f=xlsread(fname,'','birth_rate_f');
    raw.birth_rate_m=xlsread(fname,'','birth_rate_m');

    raw.migration=xlsread(fname,'','migration');
    raw.mig_frac_f=xlsread(fname,'','mig_frac_f');
    raw.mig_frac_m=xlsread(fname,'','mig_frac_m');

    raw.prod1_prev2k_f=xlsread(fname,'','prod1_prev2k_f');
    raw.prod1_prev2k_f=[1-raw.prod1_prev2k_f(:,2),...
        raw.prod1_prev2k_f(:,1),...
        raw.prod1_prev2k_f(:,2)-raw.prod1_prev2k_f(:,1)];
    raw.prod1_prev2k_m=xlsread(fname,'','prod1_prev2k_m');
    raw.prod1_prev2k_m=[1-raw.prod1_prev2k_m(:,2),...
        raw.prod1_prev2k_m(:,1),...
        raw.prod1_prev2k_m(:,2)-raw.prod1_prev2k_m(:,1)];

    raw.prod2_prev2k_f=xlsread(fname,'','prod2_prev2k_f');
    raw.prod2_prev2k_f=[1-raw.prod2_prev2k_f(:,2),...
        raw.prod2_prev2k_f(:,1),...
        raw.prod2_prev2k_f(:,2)-raw.prod2_prev2k_f(:,1)];
    raw.prod2_prev2k_m=xlsread(fname,'','prod2_prev2k_m');
    raw.prod2_prev2k_m=[1-raw.prod2_prev2k_m(:,2),...
        raw.prod2_prev2k_m(:,1),...
        raw.prod2_prev2k_m(:,2)-raw.prod2_prev2k_m(:,1)];

    raw.frmr_prod1_dist_f=xlsread(fname,'','frmr_prod1_dist_f');
    raw.frmr_prod1_dist_m=xlsread(fname,'','frmr_prod1_dist_m');

    raw.frmr_prod2_dist_f=xlsread(fname,'','frmr_prod2_dist_f');
    raw.frmr_prod2_dist_m=xlsread(fname,'','frmr_prod2_dist_m');

    % from old cig_smkless_trans_data_load.m,
    % cig_oc_trans_data_load.m, and com_smkless_trans_data_load.m

    raw.init_quit_prod1_f=[xlsread(fname,'','init_prod1_f'),xlsread(fname,'','quit_prod1_f'),ones(101,1)];
    raw.init_quit_prod1_m=[xlsread(fname,'','init_prod1_m'),xlsread(fname,'','quit_prod1_m'),ones(101,1)];

    raw.init_quit_prod2_f=[xlsread(fname,'','init_prod2_f'),xlsread(fname,'','quit_prod2_f'),ones(101,1)];
    raw.init_quit_prod2_m=[xlsread(fname,'','init_prod2_m'),xlsread(fname,'','quit_prod2_m'),ones(101,1)];

    % To read the time-varying initiation rates for "exclusive prod1",
    % "dual" and "exclusive prod2" (included 08/12/2019)
    raw.inityear_exp1_f=xlsread(fname,'','inityear_excig_female');
    raw.inityear_exp1_m=xlsread(fname,'','inityear_excig_male');

    raw.inityear_dual_f=xlsread(fname,'','inityear_dual_female');
    raw.inityear_dual_m=xlsread(fname,'','inityear_dual_male');

    raw.inityear_exp2_f=xlsread(fname,'','inityear_exnc_female');
    raw.inityear_exp2_m=xlsread(fname,'','inityear_exnc_male');

    % from old 2prod_1a/init_pop_from_file.m

    raw.twoprod_prev_mat_f=xlsread(fname,'','twoprod_prev_f');
    raw.twoprod_prev_mat_m=xlsread(fname,'','twoprod_prev_m');

    save([rpath, filesep, rfile],'raw');
elseif ~isClear
    load([rpath, filesep, rfile]);
    return;
end
end

