function [age_cats, smax, mmax, ip_f, ip_m, ...
    nn1_f, nc1_f, cc1_f, cf1_f, ff1_f, nn1_m, nc1_m, cc1_m, cf1_m, ff1_m, ...
    nn2_f, nc2_f, cc2_f, cf2_f, ff2_f, nn2_m, nc2_m, cc2_m, cf2_m, ff2_m, ...
    inityear_exp1_f, inityear_exp1_m, inityear_dual_f, inityear_dual_m, inityear_exp2_f, inityear_exp2_m, ...
    births_aux, birth_rate, birth_frac_f, birth_frac_m, migration, ...
    migfrac_f, migfrac_m, migdist_f, migdist_m, rr_prod1_f, ...
    rr_prod1_m, rr_prod2_f, rr_prod2_m, die_nprod1_f, die_nprod1_m]...
    = load_param_files_initbyyear(package, file, isClear, raw)
%This function calls package-specific functions that convert raw inputs to the required format.
% It calls pop_data_load, init_pop, trans_data_load, and mort_data_load
% from the specified package and birth_mig_compare from the base directory.
% Inputs:
% package: Name of the package being used to run Athena (corresponds to
%        Athena required first input thus no default).
% file: Name of file in package directory containing saved outputs from
%        previous run (corresponds to the Athena property input_cache,
%        defaults to inputs.mat)
% isClear: T/F. Flag that controls whether or not the data should be loaded
%        from the functions in the package. True means that the data should
%        come from the functions. False means that the functions will only
%        be called if the input cache file does not exist yet (corresponds
%        to the Athena property clear, defaults to False).
% raw: Same MATLAB struct returned by load_rsrc_func. See the following
%        functions to identify which fields must be present to avoid error
%        (where # represents the package):
%         #.pop_data_load
%         #.init_pop
%         #.trans_data_load_initbyear
%         #.mort_data_load
%         birth_mig_compare
% Outputs:
% All outputs of the load_param_files function are outputs of the 5
% functions it calls. Please see those functions for details. Athena
% expects the following outputs:
%
%    age_cats      nn1_m         nn2_m         migfrac_m
%    smax          nc1_m         nc2_m         migdist_f
%    mmax          cc1_m         cc2_m         migdist_m
%    ip_f          cf1_m         cf2_m         rr_prod1_f
%    ip_m          ff1_m         ff2_m         rr_prod1_m
%    nn1_f         nn2_f         birth_rate    rr_prod2_f
%    nc1_f         nc2_f         birth_frac_f  rr_prod2_m
%    cc1_f         cc2_f         birth_frac_m  die_nprod1_f
%    cf1_f         cf2_f         migration     die_nprod1_m
%    ff1_f         ff2_f         migfrac_f
%    inityear_exp1_f, inityear_exp1_m, inityear_dual_f, inityear_dual_m,
%    inityear_exp2_f, inityear_exp2_m, (time-varying initiation rates)

if exist(['+',package, filesep, file],'file') == 0 || isClear

    pop_data_load = str2func([package,'.pop_data_load']);
    [age_cats, smax, mmax, prod1_prev_f, prod1_prev_m, prod2_prev_f, prod2_prev_m,...
        frmr_prod1_dist_f, frmr_prod1_dist_m, frmr_prod2_dist_f, frmr_prod2_dist_m]...
        = pop_data_load(raw);

    init_pop = str2func([package,'.init_pop_2prodsPrev']);
    [ip_f, ip_m] = init_pop(age_cats, smax, mmax,...
        prod1_prev_f, prod1_prev_m, prod2_prev_f, prod2_prev_m,...
        frmr_prod1_dist_f, frmr_prod1_dist_m, frmr_prod2_dist_f, frmr_prod2_dist_m, ...
        raw);

    trans_data_load = str2func([package,'.trans_data_load_initbyyear']);
    [nn1_f, nc1_f, cc1_f, cf1_f, ff1_f, ...
        nn1_m, nc1_m, cc1_m, cf1_m, ff1_m, ...
        nn2_f, nc2_f, cc2_f, cf2_f, ff2_f, ...
        nn2_m, nc2_m, cc2_m, cf2_m, ff2_m, ...
        inityear_exp1_f, inityear_exp1_m, inityear_dual_f, inityear_dual_m, inityear_exp2_f, inityear_exp2_m] ...
        = trans_data_load(age_cats, raw);

    mort_data_load = str2func([package,'.mort_data_load']);
    [rr_prod1_f, rr_prod1_m, rr_prod2_f, rr_prod2_m, die_nprod1_f, ...
        die_nprod1_m] ...
        = mort_data_load(raw);

    [births_aux, birth_rate, birth_frac_f, birth_frac_m, migration, ...
        migfrac_f, migfrac_m, migdist_f, migdist_m] ...
        = birth_mig_compare(age_cats, smax, mmax, raw, ...
        frmr_prod1_dist_f, frmr_prod1_dist_m, frmr_prod2_dist_f, frmr_prod2_dist_m);

    save(['+',package, filesep, file]);
else
    load(['+',package, filesep, file]);
end