function [ samps, prob_vals, val_set ] = lhs_lin_interp_func( num_samps, vals, pctiles )
%function calculates

[d_num,~,val_set_num] = size(vals);



prob_vals=lhsdesign(num_samps,d_num/4+1);

prob_vals(:,end)=ceil(val_set_num*prob_vals(:,end));

xs=pctiles;
for i=1:val_set_num
    p_vals=prob_vals(prob_vals(:,end)==i,1:end-1);
    for j=1:d_num/4
        ys=vals((j-1)*4+(1:4),:,i)';
        samps(prob_vals(:,end)==i,(j-1)*4+(1:4))=inv_interp(xs, ys, p_vals(:,j));
    end
end

val_set = prob_vals(:,end);
prob_vals = reshape([prob_vals(:,1:end-1);prob_vals(:,1:end-1);...
    prob_vals(:,1:end-1);prob_vals(:,1:end-1)],size(prob_vals).*[1 4]-[0 4]);

end

function [x] = inv_interp(xs, ys, probs)

if ~isempty(probs) && (min(probs(:))<0 || max(probs(:))>1)
    error('prob is outside [0,1]');
end

x=interp1(xs, ys ,probs,'pchip'); %x=interp1(xs, ys ,probs); Modification to allow "shape-preserving piecewise cubic interpolation"
end
