function [births_aux, birth_rate, birth_frac_f, birth_frac_m, migration, ...
    migfrac_f, migfrac_m, migdist_f, migdist_m]...
    = birth_mig_compare(age_cats, smax, mmax, raw, ...
    frmr_prod1_dist_f, frmr_prod1_dist_m,frmr_prod2_dist_f, frmr_prod2_dist_m)
% This function handles raw values for birth and migration.
% This function is not part of the package and is only defined once for all
% packages.
% Inputs:
% age_cats: integer equal to the number of rows in raw.frmr_prod1_dist_f/m.
%        This integer is used throughout Athena to specify the number of
%        age categories used in population update calculations.
% smax: integer equal to the number of columns in raw.frmr_prod1_dist_f/m.
%        This integer is used to specify how many former product 1 states
%        are being tracked.
% mmax: integer equal to the number of columns in raw.frmr_prod2_dist_f/m.
%        This integer is used to specify how many former product 2 states
%        are being tracked.
% raw: this function expects this struct to contain the following fields:
%        birth_rate_$    migration       mig_frac_$
% frmr_prod1_dist_$: This is passed in without modification from the output
%       of pop_data_load.
% Outputs:
% birth_rate: a vector containing annual birth rates. The ith entry
%        specifies the number of babies born in the ith year per fertile
%        female. (A fertile female is defined in the code to be a female
%        between ages 15 and 34, inclusive.)
% birth_frac_$: a vector containing the fraction of births that are female
%        each year.  The ith entry specifies the fraction of babies with
%        sex $ in year i.
% migration: a vector containing the annual amount of net international
%        immigration. The ith entry indicates the net number of
%        international immigrants entering/leaving the population in the
%        ith year.
% migfrac_$� the vector contains the annual fractions of net international
%        immigrants that have sex $. The ith entry indicates the fraction
%        of immigrants with sex $ in year i.
% migdist_$: a matrix containing the prevalence of net international
%        immigrants by tobacco-use state and age. The matrix has dimensions
%        age_cats by (smax+2)*(mmax+2). Rows correspond to age, and columns
%        correspond to tobacco product use and follow the same ordering
%        convention as in ip_$. The sum of all of the entries in migdist_$
%        equals 1.

births_aux=raw.births_aux;

birth_rate=raw.birth_rate_f+raw.birth_rate_m;

birth_frac_f=raw.birth_rate_f./birth_rate;

birth_frac_m=raw.birth_rate_m./birth_rate;

migration=raw.migration;

migfrac_f=raw.mig_frac_f;
migfrac_m=raw.mig_frac_m;

%updated November 17, 2022;
mig_s_frac_f=0.039475; %(2014-2018); %0.044; %frac of adults immigrants who are fem, smoker
mig_s_frac_m=0.152081; %(2014-2018); %0.191; %frac of adults immigrants who are male, smoker
mig_xs_frac_f=0.063028; %(2012/2015); %0.056; %frac of adults immigrants who are fem, x-smoker
mig_xs_frac_m=0.129385; %(2012/2015); %0.131; %frac of adults immigrants who are male, x-smoker


% non-combusted tobacco products (prod2) (i.e., e-cigarettes and smokeless tobacco)
mig_nc_frac_f=0.011592; %add November 17, 2022; %frac of adults immigrants who are female  non-combusted user,
mig_nc_frac_m=0.024453; %add November 17, 2022; %frac of adults immigrants who are male non-combusted user,
mig_xnc_frac_f=0.037217; %add November 17, 2022; %frac of adults immigrants who are female  non-combusted  Former user,
mig_xnc_frac_m=0.080483; %add November 17, 2022; %frac of adults immigrants who are male  non-combusted Former user,


mig_nn_frac_f=1-mig_s_frac_f-mig_xs_frac_f-mig_nc_frac_f-mig_xnc_frac_f; %frac of immigrants who are fem, never tobacco users
mig_nn_frac_m=1-mig_s_frac_m-mig_xs_frac_m-mig_nc_frac_m-mig_xnc_frac_m; %frac of immigrants who are male, never tobacaco users

age_bins=[0 18 25 35 45 55 65 101]; %intervals are [0,18), [18,25), [25,35), etc.
% or alternatively 0-17, 18-24, etc.

% ALL races (total population 2019) UPDATED!!!
pop_for_bins=44932901*[0.057, 0.063, 0.1825, 0.1825, 0.196, 0.152, 0.167]; % percentage of immigrants assigned to each age bin can be calculated by pop_for_bins(i)/sum(pop_for_bins)
% WHITE alone, not Hispanic or Latino 2019
%     pop_for_bins=0.174*44932901*[0.057, 0.063, 0.1825, 0.1825, 0.196, 0.152, 0.167];
% BLACK 2019
%     pop_for_bins=0.097*44932901*[0.057, 0.063, 0.1825, 0.1825, 0.196, 0.152, 0.167];

% ALL races (total population 2015)
%     pop_for_bins=41717420*[0.061, 0.076, 0.2015, 0.2015, 0.187, 0.134, 0.139]; % percentage of immigrants assigned to each age bin can be calculated by pop_for_bins(i)/sum(pop_for_bins)
% WHITE 2015
%     pop_for_bins=0.183*41717420*[0.061, 0.076, 0.2015, 0.2015, 0.187, 0.134, 0.139]; % percentage of immigrants assigned to each age bin can be calculated by pop_for_bins(i)/sum(pop_for_bins)
% BLACK 2015
%     pop_for_bins=0.086*41717420*[0.061, 0.076, 0.2015, 0.2015, 0.187, 0.134, 0.139]; % percentage of immigrants assigned to each age bin can be calculated by pop_for_bins(i)/sum(pop_for_bins)

mig_frac=zeros(age_bins(length(age_bins)),1);

% fraction of immigrants assigned to each year bin can be calculated by
% [pop_for_bins(i)/sum(pop_for_bins)]/# fo years in each bin
for i=1:length(age_bins)-1
    mig_frac(age_bins(i)+1:age_bins(i+1))=pop_for_bins(i)/sum(pop_for_bins)/(age_bins(i+1)-age_bins(i));
end

% Females
migdist_f=zeros(age_cats,(smax+2)*(mmax+2));
migdist_f(1:18,1)=mig_frac(1:18,1);
migdist_f(19:age_cats,1)=mig_nn_frac_f*mig_frac(19:age_cats); % never never
migdist_f(19:age_cats,2)=mig_s_frac_f*mig_frac(19:age_cats); % current smokers
migdist_f(19:age_cats,smax+3)=mig_nc_frac_f*mig_frac(19:age_cats); % current noncombusted

% Males
migdist_m=zeros(age_cats,(smax+2)*(mmax+2));
migdist_m(1:18,1)=mig_frac(1:18,1);
migdist_m(19:age_cats,1)=mig_nn_frac_m*mig_frac(19:age_cats); % never never
migdist_m(19:age_cats,2)=mig_s_frac_m*mig_frac(19:age_cats); % current smokers never noncombusted
migdist_m(19:age_cats,smax+3)=mig_nc_frac_m*mig_frac(19:age_cats); % never smokers current noncombusted

% former smokers
[~,lll]=size(frmr_prod1_dist_f);
for j=1:(smax+2)*(mmax+2)-2
    if j<=lll   % Former smokers never noncombusted
        migdist_f(19:age_cats,j+2)=mig_xs_frac_f*mig_frac(19:age_cats).*frmr_prod1_dist_f(19:age_cats,j);
        migdist_m(19:age_cats,j+2)=mig_xs_frac_m*mig_frac(19:age_cats).*frmr_prod1_dist_m(19:age_cats,j);
    end
end

% former noncombusted
[~,ttt]=size(frmr_prod2_dist_f);
for j=1:(smax+2)*(mmax+2)-2
    if j<=ttt    % never smokers Former noncombusted
        migdist_f(19:age_cats,(j+1)*(smax+2)+1)=mig_xnc_frac_f*mig_frac(19:age_cats).*frmr_prod2_dist_f(19:age_cats,j);
        migdist_m(19:age_cats,(j+1)*(smax+2)+1)=mig_xnc_frac_m*mig_frac(19:age_cats).*frmr_prod2_dist_m(19:age_cats,j);
    end
end




end