function [ ave_init_p1, ave_cess_p1, ave_init_p2, ave_cess_p2 ] = ...
    ave_prob_func( pop_f, pop_m, new_init_p1_f, new_init_p1_m, new_init_p2_f, new_init_p2_m,...
    new_cess_p1_f, new_cess_p1_m, new_cess_p2_f, new_cess_p2_m, ...
    min_age, max_age, smax, mmax );
% This function calculates the average initiation and cessation rates for both tobacco products.
% The average initiation rate for people within the specified age range for
% a product is calculated by dividing the number of people within that age
% range that initiate the product in a year by the number of people in that
% age range in that year that feasibly could have initiated product use.
% The average cessation rate is calculated similarly based on the number of
% people that quit a product in a year and the number of people that
% feasibly could have quit using the product.
% Inputs:
% pop_$: population matrix for sex $.
% new_init_p#_$: matrix of people with sex $ that initiated product # in a
%        year. Rows correspond to age and columns correspond to year of the
%        simulation.
% new_cess_p#_$: matrix of people with sex $ that quit product # in a year.
%        Rows correspond to age and columns correspond to year of the
%        simulation.
% min_age: lower bound of age interval.
% max_age: upper bound of age interval.
% smax: integer equal to the number of columns in raw.frmr_prod1_dist_f/m.
%        This integer is used to specify how many former product 1 states
%        are being tracked.
% mmax: integer equal to the number of columns in raw.frmr_prod2_dist_f/m.
%        This integer is used to specify how many former product 2 states
%        are being tracked.
% Outputs:
% ave_init_p#: vector of length num_years. The ith entry is the average
%        initiation rate for product # in year i for the specified age
%        range.
% ave_cess_p#: vector of length num_years. The ith entry is the average
%        cessation rate for product # in year i for the specified age
%        range.


[~,years]=size(new_init_p1_f);
ages=[min_age+1:max_age+1];

for k=1:years
    ave_init_p1(k,1)=sum([new_init_p1_f(ages,k)+ new_init_p1_m(ages,k)])/...
        sum(sum(pop_f(ages,1:smax+2:(smax+2)*(mmax+2),k)+pop_m(ages,1:smax+2:(smax+2)*(mmax+2),k)));

    ave_init_p2(k,1)=sum([new_init_p2_f(ages,k)+ new_init_p2_m(ages,k)])/...
        sum(sum(pop_f(ages,1:smax+2,k)+pop_m(ages,1:smax+2,k)));

    ave_cess_p1(k,1)=sum([new_cess_p1_f(ages,k)+ new_cess_p1_m(ages,k)])/...
        sum(sum(pop_f(ages,2:smax+2:(smax+2)*(mmax+2),k)+pop_m(ages,2:smax+2:(smax+2)*(mmax+2),k)));

    ave_cess_p2(k,1)=sum([new_cess_p2_f(ages,k)+ new_cess_p2_m(ages,k)])/...
        sum(sum(pop_f(ages,smax+2+[1:smax+2],k)+pop_m(ages,smax+2+[1:smax+2],k)));


end


end

