function [c] = athena_main_mod_initbyyear(input_path,varargin)
%ATHENA_MAIN Main body of the DSM model.
%   ATHENA_MAIN('InputPackage') runs the model with the behavior
%   specified the the package named InputPackage.
%   ATHENA_MAIN('InputPackage', PAD_CALC) runs the model with
%   behavior contained in 'InputPackage' and specifies whether or not to
%   perform Product Attributable Death (PAD) calculations. The default
%   value for PAD_CALC is true.
%   ATHENA_MAIN(_, 'PropertyName', PropertyValue,...)
%   runs the model and sets the named properties to the specified values.
%
%   Examples:
%
%       ATHENA_MAIN('one_prod')
%
%   Runs the model using the 'one_prod' package (contained in the directory
%   '+one_prod') to define to model's behavior.
%
%       ATHENA_MAIN('one_prod','clear',true)
%
%   The 'clear' property defaults to FALSE. When true the model will run
%   from the input files instead of the cached values from the last time
%   the model was run.
%
%   Properties:
%
%       'input_cache'   -   File name of the cache values for the parameter
%                           files. Defaults to 'inputs.mat'.
%       'output_path'   -   Path to the desired output folder. Defaults to
%                           './Output'.
%       'output_file'   -   File name the model should use to save the
%                           results of the run. Defaults to 'results.mat'.
%       'large_mats'    -   True or False. When true the model will keep
%                           track of the full death (and attributable death
%                           if PAD_CALC is true) matrices. As this requires
%                           a considerable amount of memory this input
%                           defaults to false.
%       'param_out_file'-   File name the model should use to save the
%                           parameters (default and explicit) set for this
%                           run. Defaults to 'params.csv'.
%       'load_rsrc_func'-   A handle to a function that loads all the raw
%                           data from the resource files. Defaults to
%                           @load_raw_data.
%       'resource_path' -   Path to the base parameter files (Also used to
%                           save the resource cache file). Defaults to
%                           'resources'.
%       'raw_inputs'    -   File name from which the model should read the
%                           base values for cigarettes, combustibles and
%                           smokeless tobaco. Defaults to
%                           'PSM_parameters_010213.xlsx'.
%       'policy_func'   -   A handle to a function that applies the policy.
%                           Default value is @policy.
%       'policy_count'  -   A numeric value which tells the model how many
%                           times to loop through in order to capture all
%                           the variations specified in the policy script.
%                           A policy count of 0 runs the model without
%                           calling the policy function.
%       'clear'         -   True or False. When true the model will ignore
%                           any previously cached inputs and load the data
%                           from file. Defaults to false.
%       'calc_subpops'  -   True or False. When true the model will keep
%                           track of sub-populations by product use status.
%                           This input is true by default.
%       'save_output'   -   True or False. Model outputs run results to
%                           file named by 'output_file'. Input defaults to
%                           True.
%       'num_years'     -   A numeric value between 1 and 50 telling the
%                           model how many years to run. Defaults to 50.
%       'post_process'  -   A handle to a function that accepts the output
%                           of the main script as input. Default value is
%                           @print_prev_file.
%       'transit_func'  -   A handle to a function that calculates
%                           transition probabilities. Defaults to
%                           @trans_probs_indep.
%       'mortality_func'-   A handle to a function that calculates
%                           mortality probabilities. Defaults to
%                           @mort_probs_dep.

% constants:
%prevalence_age_categories= [[18;(25:10:85)'] [(24:10:84)';100]];
%prevalence_age_categories= [[18;25;45;65] [24;44;64;100]];
prevalence_age_categories= [[18;25;45;65;18] [24;44;64;100;100]];
cumulative_difference_age_categories=...
    [35 64;
    65 84;
    35 84];

% default values:
pad_calc       = false;
input_cache    = 'inputs.mat';
output_path    = './output';
output_file    = 'results.mat';
large_mats     = false;
param_out_file = 'params.csv';
load_rsrc_func = @load_raw_data;
resrc_path     = 'resources';
resrc_cache    = 'resources.mat';
raw_inputs     = 'Two_Prod_Ind_PrevMat.xlsx';
policy_func    = @policy;
policy_count   = 1;
isClear        = false;
calc_subpops   = true;
save_output    = true;
num_years      = 50;
post_process   = @(a)(1);
transit_func   = @trans_probs_initbyyear;
%transit_func =@trans_probs_initbyyear_mentholbanSA; % coppy and paste the Menthol function.
mortality_func = @mort_func;

% DO NOT ALTER
% configure parser to read in and validate inputs:
parser = inputParser;
parser.FunctionName = 'standalone_main_script';
func_check = @(x)isa(x,'function_handle');
pc_check = @(x) ( isnumeric(x) & x >= 0 );
addRequired(parser, 'input_path', @ischar);
addOptional(parser, 'pad_calc', pad_calc, @islogical);
addParamValue(parser, 'input_cache', input_cache, @ischar); %#ok<*NVREPL>
addParamValue(parser, 'output_path', output_path, @ischar);
addParamValue(parser, 'output_file', output_file, @ischar);
addParamValue(parser, 'large_mats', large_mats, @islogical);
addParamValue(parser, 'param_out_file', param_out_file, @ischar);
addParamValue(parser, 'load_rsrc_func', load_rsrc_func, func_check);
addParamValue(parser, 'resource_path', resrc_path, @ischar);
addParamValue(parser, 'resource_cache', resrc_cache, @ischar);
addParamValue(parser, 'raw_inputs', raw_inputs, @ischar);
addParamValue(parser, 'policy_func', policy_func, func_check);
addParamValue(parser, 'policy_count', policy_count, pc_check);
addParamValue(parser, 'clear', isClear, @islogical);
addParamValue(parser, 'calc_subpops', calc_subpops, @islogical);
addParamValue(parser, 'save_output', save_output, @islogical);
addParamValue(parser, 'num_years', num_years, @isnumeric);
addParamValue(parser, 'post_process', post_process, func_check);
addParamValue(parser, 'transit_func', transit_func, func_check);
addParamValue(parser, 'mortality_func', mortality_func, func_check);

% DO NOT ALTER
% parse/validate inputs and assign them to variables:
parse(parser,input_path,varargin{:});
pad_calc       = parser.Results.pad_calc;
input_cache    = parser.Results.input_cache;
c.output_path  = parser.Results.output_path;
output_file    = parser.Results.output_file;
large_mats     = parser.Results.large_mats;
param_out_file = parser.Results.param_out_file;
load_rsrc_func = parser.Results.load_rsrc_func;
resrc_path     = parser.Results.resource_path;
resrc_cache    = parser.Results.resource_cache;
raw_inputs     = parser.Results.raw_inputs;
policy_func    = parser.Results.policy_func;
pc             = parser.Results.policy_count;
isClear        = parser.Results.clear;
subp           = parser.Results.calc_subpops;
save_pop       = parser.Results.save_output;
c.num_years    = parser.Results.num_years;
post_process   = parser.Results.post_process;
transit_func   = parser.Results.transit_func;
mortality_func = parser.Results.mortality_func;

% Load everything:
tic
disp('Loading data files');
[ raw ] ...
    = load_rsrc_func(resrc_path, resrc_cache, ...
    raw_inputs, isClear);
[c.age_cats, smax, mmax, ip_f, ip_m, ...
    nn1_f, nc1_f, cc1_f, cf1_f, ff1_f, nn1_m, nc1_m, cc1_m, cf1_m, ff1_m, ...
    nn2_f, nc2_f, cc2_f, cf2_f, ff2_f, nn2_m, nc2_m, cc2_m, cf2_m, ff2_m, ...
    inityear_exp1_f, inityear_exp1_m, inityear_dual_f, inityear_dual_m, inityear_exp2_f, inityear_exp2_m, ...
    births_aux, birth_rate, birth_frac_f, birth_frac_m, migration, ...
    migfrac_f, migfrac_m, migdist_f, migdist_m, rr_prod1_f, ...
    rr_prod1_m, rr_prod2_f, rr_prod2_m, die_nprod1_f, die_nprod1_m] ...
    = load_param_files_initbyyear(input_path, input_cache, isClear, raw);
%toc




% Start the main loop (runs backwards to pre-allocate the structures)
disp('Starting main loop');
%tic_id=tic;
for zzz=pc+1:-1:1

    [die_prob_f, die_prob_m] ...
        = mortality_func(c.age_cats, smax, mmax, raw);

    policy_ind=zzz-1;
    %load pop2012_021315.mat
    %load pop2012.mat
    %[ip_f,ip_m]=make_2012_pop_func(smax,mmax,c.age_cats,base2012_f,base2012_m);


    %tic

    [c.trans_prob_f, c.trans_prob_m] ...
        = transit_func(c.age_cats, inityear_exp1_f, inityear_exp1_m, ...
        inityear_dual_f, inityear_dual_m, ...
        inityear_exp2_f, inityear_exp2_m, ...
        cf1_f, cf1_m);
    if policy_ind > 0
        c = policy_func(c, policy_ind);
    end
    % toc

    % new lines 2/21/2019 to save trans prob
    c.trans_prob_f_saved{zzz} = c.trans_prob_f; c.trans_prob_m_saved{zzz} = c.trans_prob_m;

    %tic
    [ c.pop_f{zzz}, c.pop_m{zzz}, c.death_vec_f{zzz}, c.death_vec_m{zzz},...
        c.births{zzz}, c.age_cats, state_combs, c.mig_f{zzz}, c.mig_m{zzz},...
        c.birth_f{zzz}, c.birth_m{zzz}, c.new_init_p1_f{zzz}, c.new_init_p1_m{zzz}, ...
        c.new_init_p2_f{zzz}, c.new_init_p2_m{zzz}, c.new_cess_p1_f{zzz}, c.new_cess_p1_m{zzz}, ...
        c.new_cess_p2_f{zzz}, c.new_cess_p2_m{zzz}, c.new_cess_p1E_f{zzz}, c.new_cess_p1E_m{zzz}, ...
        c.new_cess_p1Swtch_f{zzz}, c.new_cess_p1Swtch_m{zzz}, ...
        death_mat_f, death_mat_m,...
        pad_mat_f, pad_mat_m, pad_vec_f, pad_vec_m, ...
        padP1_vec_f, padP1_vec_m, padP2_vec_f, padP2_vec_m,...
        padP1E_vec_f, padP1E_vec_m, padP2E_vec_f, padP2E_vec_m, padDUAL_vec_f, padDUAL_vec_m]...
        =athena_2prod_func( c.num_years, smax, mmax, raw.s_relmax, raw.m_relmax,...
        ip_f, ip_m, die_prob_f, die_prob_m, c.trans_prob_f, c.trans_prob_m,...
        migration, migfrac_f, migfrac_m, migdist_f, migdist_m, ...
        births_aux, birth_rate, birth_frac_f, birth_frac_m);
    if pad_calc == 1 && large_mats == 1
        c.pad_mat_f{zzz}=pad_mat_f;
        c.pad_mat_m{zzz}=pad_mat_m;
        c.pad_vec_f{zzz}=pad_vec_f;
        c.pad_vec_m{zzz}=pad_vec_m;
        c.death_mat_f{zzz}=death_mat_f;
        c.death_mat_m{zzz}=death_mat_m;
    elseif pad_calc == 1
        c.pad_vec_f{zzz}=pad_vec_f;
        c.pad_vec_m{zzz}=pad_vec_m;
        c.padP1_vec_f{zzz}=padP1_vec_f;
        c.padP1_vec_m{zzz}=padP1_vec_m;
        c.padP2_vec_f{zzz}=padP2_vec_f;
        c.padP2_vec_m{zzz}=padP2_vec_m;
        c.padP1E_vec_f{zzz}=padP1E_vec_f;
        c.padP1E_vec_m{zzz}=padP1E_vec_m;
        c.padP2E_vec_f{zzz}=padP2E_vec_f;
        c.padP2E_vec_m{zzz}=padP2E_vec_m;
        c.padDUAL_vec_f{zzz}=padDUAL_vec_f;
        c.padDUAL_vec_m{zzz}=padDUAL_vec_m;
    elseif large_mats == 1
        c.death_mat_f{zzz}=death_mat_f;
        c.death_mat_m{zzz}=death_mat_m;
    end
    clear('pad_mat_f','pad_mat_m','pad_vec_f','pad_vec_m',...
        'death_mat_f','death_mat_m');
    %toc



    if subp==1
        %tic
        [ c.pop_female1534{zzz}, c.pop_tot{zzz}, c.adult_pop{zzz}, c.adult_pop_n1{zzz}, c.adult_pop_c1{zzz}, c.adult_pop_f1{zzz}, ...
            c.adult_pop_n2{zzz}, c.adult_pop_c2{zzz}, c.adult_pop_f2{zzz},c.adult_pop_cc{zzz}, ...
            c.adult_prev_n1{zzz}, c.adult_prev_c1{zzz}, c.adult_prev_f1{zzz}, ...
            c.adult_prev_n2{zzz}, c.adult_prev_c2{zzz}, c.adult_prev_f2{zzz},c.adult_prev_cc{zzz},~]...
            = subpop_func_updated(c.pop_f{zzz}, c.pop_m{zzz}, smax, mmax, c.num_years, ...
            c.age_cats, state_combs);
        %toc
    end

    min_age=prevalence_age_categories(:,1);
    max_age=prevalence_age_categories(:,2);

    % This used be in calc_prevs
    for g=1:length(min_age)
        [c.prev_nn{zzz,g}, c.prev_nc{zzz,g}, c.prev_nf{zzz,g},...
            c.prev_cn{zzz,g}, c.prev_cc{zzz,g}, c.prev_cf{zzz,g},...
            c.prev_fn{zzz,g}, c.prev_fc{zzz,g}, c.prev_ff{zzz,g},...
            c.prev_nn_f{zzz,g}, c.prev_nc_f{zzz,g}, c.prev_nf_f{zzz,g},...
            c.prev_cn_f{zzz,g}, c.prev_cc_f{zzz,g}, c.prev_cf_f{zzz,g},...
            c.prev_fn_f{zzz,g}, c.prev_fc_f{zzz,g}, c.prev_ff_f{zzz,g},...
            c.prev_nn_m{zzz,g}, c.prev_nc_m{zzz,g}, c.prev_nf_m{zzz,g},...
            c.prev_cn_m{zzz,g}, c.prev_cc_m{zzz,g}, c.prev_cf_m{zzz,g},...
            c.prev_fn_m{zzz,g}, c.prev_fc_m{zzz,g}, c.prev_ff_m{zzz,g}, ...
            c.sub_pop_f{zzz,g}, c.sub_pop_m{zzz,g}, c.sub_pop{zzz,g}]...
            = prev_func_updated(  c.pop_f{zzz}, c.pop_m{zzz}, smax, mmax,...
            c.num_years, c.age_cats, min_age(g), max_age(g));
    end

    ad_age=[18 100];
    y_age=[12 17];
    [ c.ave_ad_init_p1{zzz}, c.ave_ad_cess_p1{zzz}, c.ave_ad_init_p2{zzz}, c.ave_ad_cess_p2{zzz} ] = ...
        ave_prob_func( c.pop_f{zzz}, c.pop_m{zzz}, c.new_init_p1_f{zzz}, ...
        c.new_init_p1_m{zzz}, c.new_init_p2_f{zzz}, c.new_init_p2_m{zzz},...
        c.new_cess_p1_f{zzz}, c.new_cess_p1_m{zzz}, c.new_cess_p2_f{zzz}, c.new_cess_p2_m{zzz}, ...
        ad_age(1), ad_age(2), smax, mmax );

    [ c.ave_y_init_p1{zzz}, c.ave_y_cess_p1{zzz}, c.ave_y_init_p2{zzz}, c.ave_y_cess_p2{zzz} ] = ...
        ave_prob_func( c.pop_f{zzz}, c.pop_m{zzz}, c.new_init_p1_f{zzz}, ...
        c.new_init_p1_m{zzz}, c.new_init_p2_f{zzz}, c.new_init_p2_m{zzz},...
        c.new_cess_p1_f{zzz}, c.new_cess_p1_m{zzz}, c.new_cess_p2_f{zzz}, c.new_cess_p2_m{zzz}, ...
        y_age(1), y_age(2), smax, mmax );

    [ c.lifeyears{zzz} ] = lifeyears_age_func( c.pop_f{zzz}, c.pop_m{zzz}, 0, 100 );
    [ c.smokers{zzz} ]   = smokers_by_age_func( c.pop_f{zzz}, c.pop_m{zzz}, smax, mmax );
    [ c.age_deaths{zzz} ] = death_age_func( c.death_vec_f{zzz}, c.death_vec_m{zzz}, 35, 84 );


    fprintf('Finished policy %d\n',zzz-1);
end
%toc(tic_id)

c.tt = 2000 : 2000 + c.num_years;

%tic
min_age = cumulative_difference_age_categories(:,1);
max_age = cumulative_difference_age_categories(:,2);
c.CumLifeYears   = cell(pc,length(min_age));
c.CumLifeYears_f = cell(pc,length(min_age));
c.CumLifeYears_m = cell(pc,length(min_age));
c.CumDifDeath    = cell(pc,length(min_age));
c.CumDifDeath_f  = cell(pc,length(min_age));
c.CumDifDeath_m  = cell(pc,length(min_age));
for k=1:pc
    for g=1:length(min_age)
        [ c.CumLifeYears{k,g}, c.CumLifeYears_f{k,g}, c.CumLifeYears_m{k,g} ] ...
            = cum_dif_life_func( c.pop_f{1}, c.pop_m{1}, c.pop_f{k+1},...
            c.pop_m{k+1}, min_age(g), max_age(g) );
        [ c.CumDifDeath{k,g}, c.CumDifDeath_f{k,g}, c.CumDifDeath_m{k,g} ] ...
            = cum_dif_death_func( c.death_vec_f{1}, c.death_vec_m{1},...
            c.death_vec_f{k+1}, c.death_vec_m{k+1}, min_age(g), max_age(g) );
    end
end
%toc

eq5d0=[ones(18,1); 0.935*ones(7,1); 0.913*ones(20,1); 0.860*ones(20,1);...
    0.831*ones(10,1);0.773*ones(26,1)];
eq5d1=[ones(18,1);0.893*ones(7,1);0.864*ones(20,1);0.809*ones(20,1);...
    0.799*ones(10,1);0.753*ones(26,1)];

for k=1:pc+1
    %[ c.ad_morb_qaly_lost{k} ] = morb_qaly_lost_func_age( c.pop_f{k}, c.pop_m{k}, eq5d0, eq5d1, smax, mmax, 35, 100 )
    [ c.ad_morb_qaly_lost{k} ] = morb_qaly_lost_func( c.pop_f{k}, c.pop_m{k}, eq5d0, eq5d1, smax, mmax );
    [ c.adult_qaly_f{k}, c.adult_qaly_m{k}, c.adult_qaly{k} ] = adult_qaly_func(c.pop_f{k}, c.pop_m{k}, eq5d0, eq5d1, smax, mmax );
end



if(exist(c.output_path,'dir')==0)
    mkdir(c.output_path);
end

if save_pop==1
    disp(['Saving ' output_file]);
    %tic
    save([c.output_path,filesep,output_file], 'c', '-v7.3' );
    %toc
end

disp(['Saving ' param_out_file]);
%tic
%     d = struct2table(parser.Results);
d = parser.Results;
d.load_rsrc_func = f2AtF(d.load_rsrc_func);
d.policy_func = f2AtF(d.policy_func);
d.post_process = f2AtF(d.post_process);
d.transit_func = f2AtF(d.transit_func);
d.mortality_func = f2AtF(d.mortality_func);
%     writetable(d,[c.output_path,filesep,param_out_file]);
f=fieldnames(d)';
dd=struct2cell(d)';
inputs={f{:};dd{:}};
%xlswrite([c.output_path,filesep,param_out_file],inputs);
%I commented this because it consumes too much memory during the execution for more
%than 4000 iterations
%toc

disp('Performing post processing');
%tic
post_process(c);
toc

end

function x = f2AtF(y)
% Takes a function handle and returns it in the form of a string prepended
% with '@'.
z=func2str(y);
if z(1)=='@'
    x=z;
else
    x=['@', func2str(y)];
end
end
