function [nn1_f, nc1_f, cc1_f, cf1_f, ff1_f, ...
    nn1_m, nc1_m, cc1_m, cf1_m, ff1_m, ...
    nn2_f, nc2_f, cc2_f, cf2_f, ff2_f, ...
    nn2_m, nc2_m, cc2_m, cf2_m, ff2_m, ...
    inityear_exp1_f, inityear_exp1_m, inityear_dual_f, inityear_dual_m, inityear_exp2_f, inityear_exp2_m] ...
    = trans_data_load_initbyyear(~, raw)
% This function calculates transition probability data for Product1 and Product2.
% This function is uniquely defined in each package.
% Inputs:
% age_cats: integer equal to the number of rows in raw.frmr_prod1_dist_f/m.
%        This integer is used throughout Athena to specify the number of
%        age categories used in population update calculations.
% raw: This input is the same MATLAB struct returned by load_rsrc_func. The
% function requires the following fields be present within the struct:
%      � init_quit_prod1_f/m
%      � init_quit_prod2_f/m.
% Outputs:
% Each output (listed below) is a vector of length age_cats, and the vector
% entries are the annual state transition probabilities for single
% products. The ith entry in AB#_$ is the annual probability that an
% individual with sex $ will transition from status A (N, C, or F) to
% status B for product #. (e.g. cf1_m contains the annual probabilities for
% transitioning from current use to former use of product 1 for males).
%
%        nn1_f     nn1_m     nn2_f     nn2_m
%        nc1_f     nc1_m     nc2_f     nc2_m
%        cc1_f     cc1_m     cc2_f     cc2_m
%        cf1_f     cf1_m     cf2_f     cf2_m
%        ff1_f     ff1_m     ff2_f     ff2_m

init_quit_prod1_f=raw.init_quit_prod1_f;
init_quit_prod1_m=raw.init_quit_prod1_m;

init_quit_prod2_f=raw.init_quit_prod2_f;
init_quit_prod2_m=raw.init_quit_prod2_m;

nn1_f=1-init_quit_prod1_f(:,1);
nc1_f=init_quit_prod1_f(:,1);
cc1_f=1-init_quit_prod1_f(:,2);
cf1_f=init_quit_prod1_f(:,2);
ff1_f=init_quit_prod1_f(:,3);

nn1_m=1-init_quit_prod1_m(:,1);
nc1_m=init_quit_prod1_m(:,1);
cc1_m=1-init_quit_prod1_m(:,2);
cf1_m=init_quit_prod1_m(:,2);
ff1_m=init_quit_prod1_m(:,3);

nn2_f=1-init_quit_prod2_f(:,1);
nc2_f=init_quit_prod2_f(:,1);
cc2_f=1-init_quit_prod2_f(:,2);
cf2_f=init_quit_prod2_f(:,2);
ff2_f=init_quit_prod2_f(:,3);

nn2_m=1-init_quit_prod2_m(:,1);
nc2_m=init_quit_prod2_m(:,1);
cc2_m=1-init_quit_prod2_m(:,2);
cf2_m=init_quit_prod2_m(:,2);
ff2_m=init_quit_prod2_m(:,3);

% time varying initiation rates for "exclusive prod1", "dual" and "exclusive prod2"
inityear_exp1_f = raw.inityear_exp1_f;
inityear_exp1_m = raw.inityear_exp1_m;

inityear_dual_f = raw.inityear_dual_f;
inityear_dual_m = raw.inityear_dual_m;

inityear_exp2_f = raw.inityear_exp2_f;
inityear_exp2_m = raw.inityear_exp2_m;


end