function [age_cats, smax, mmax, prod1_prev_f, prod1_prev_m, prod2_prev_f, prod2_prev_m,...
    frmr_prod1_dist_f, frmr_prod1_dist_m, frmr_prod2_dist_f, frmr_prod2_dist_m] ...
    = pop_data_load(raw)
%This function reads in the initial prevalence and distribution of former
% users, and outputs the full prevalence distribution matrix. This function
% is uniquely defined in each package.
% Inputs:
% raw: This input is the same MATLAB struct returned by load_rsrc_func. The
% function requires the following fields be present within the struct for a
% 2-product run with independence:
%    raw.prod1_prev2k_f    raw.frmr_prod1_dist_f
%    raw.prod1_prev2k_m    raw.frmr_prod1_dist_m
%    raw.prod2_prev2k_f    raw.frmr_prod1_dist_f
%    raw.prod2_prev2k_m    raw.frmr_prod1_dist_m
%
%
% Outputs:
% age_cats: integer equal to the number of rows in raw.frmr_prod1_dist_f/m.
%        This integer is used throughout Athena to specify the number of
%        age categories used in population update calculations.
% smax: integer equal to the number of columns in raw.frmr_prod1_dist_f/m.
%        This integer is used to specify how many former product 1 states
%        are being tracked.
% mmax: integer equal to the number of columns in raw.frmr_prod2_dist_f/m.
%        This integer is used to specify how many former product 2 states
%        are being tracked.
% prod1_prev_f/m: Two matrices of size age_cats by (smax+2) containing the
%        product 1 usage prevalence for all age categories and usage states
%        by sex for the initial population.
%       1st column contains prevalence values for never users of product 1
%       2nd column contains prevalence values for current users of product 1
%       3rd column contains prevalence values for former users of product
%        1 who quit within the past year
%       4th column contains prevalence values for former users of product
%        1 who quit between 1 and 2 years ago
%       
%       The smax+2 column contains prevalence values for former users of
%        product 1 who quit at least smax years ago
% prod2_prev_f/m: Two matrices (f, m) of size age_cats by (mmax+2)
%        containing the product 2 usage prevalence for all age categories
%        and usage states by sex for the initial population.
%       1st column contains prevalence values for never users of product 2
%       2nd column contains prevalence values for current users of product 2
%       3rd column contains prevalence values for former users of product
%        2 who quit within the past year
%       4th column contains prevalence values for former users of product
%        2 who quit between 1 and 2 years ago
%       
%       The smax+2 column contains prevalence values for former users of
%        product 2 who quit at least smax years ago.
% frmr_prod1_dist_$: Two matrices (f, m) of size age_cats by smax
%        containing the distribution of  former users of product 1 for all
%        age categories by sex $ for the initial population.
%       1st column contains the fraction (between 0 and 1) of former users
%        of product 1 who quit within the past year
%       2nd column contains the fraction of former users of product 1 who
%        quit between 1 and 2 years ago
%       and so forth
% frmr_prod2_dist_$: Two matrices (f, m) of size age_cats by smax
%        containing the distribution of  former users of product 2 for all
%        age categories by sex $ for the initial population.
%       1st column contains the fraction (between 0 and 1) of former users
%        of product 2 who quit within the past year.
%       2nd column contains the fraction of former users of product 2 who
%        quit between 1 and 2 years ago
%       and so forth

prod1_prev2k_f=raw.prod1_prev2k_f;
prod1_prev2k_m=raw.prod1_prev2k_m;

prod2_prev2k_f=raw.prod2_prev2k_f;
prod2_prev2k_m=raw.prod2_prev2k_m;

frmr_prod1_dist_f=raw.frmr_prod1_dist_f;
frmr_prod1_dist_m=raw.frmr_prod1_dist_m;

frmr_prod2_dist_f=raw.frmr_prod2_dist_f;
frmr_prod2_dist_m=raw.frmr_prod2_dist_m;

[age_cats,smax]=size(frmr_prod1_dist_f);
[~,mmax]=size(frmr_prod2_dist_f);

frmr_prod1_dist_f(:,1)=1-sum(frmr_prod1_dist_f(:,2:end),2);
frmr_prod1_dist_m(:,1)=1-sum(frmr_prod1_dist_m(:,2:end),2);

frmr_prod2_dist_f(:,1)=1-sum(frmr_prod2_dist_f(:,2:end),2);
frmr_prod2_dist_m(:,1)=1-sum(frmr_prod2_dist_m(:,2:end),2);

prod1_prev_f=[prod1_prev2k_f(:,1) prod1_prev2k_f(:,2) zeros(age_cats,smax)];
prod2_prev_f=[prod2_prev2k_f(:,1) prod2_prev2k_f(:,2) zeros(age_cats,mmax)];

prod1_prev_m=[prod1_prev2k_m(:,1) prod1_prev2k_m(:,2) zeros(age_cats,smax)];
prod2_prev_m=[prod2_prev2k_m(:,1) prod2_prev2k_m(:,2) zeros(age_cats,mmax)];


for i=1:smax
    prod1_prev_f(:,2+i)=prod1_prev2k_f(:,3).*frmr_prod1_dist_f(:,i);
    prod1_prev_m(:,2+i)=prod1_prev2k_m(:,3).*frmr_prod1_dist_m(:,i);
end

for i=1:mmax
    prod2_prev_f(:,2+i)=prod2_prev2k_f(:,3).*frmr_prod2_dist_f(:,i);
    prod2_prev_m(:,2+i)=prod2_prev2k_m(:,3).*frmr_prod2_dist_m(:,i);
end

end