function [ raw ] ...
    = load_raw_data(rpath, rfile, fname, isClear)
% This function loads all of the raw data from file or other source.
% Athena can be configured to use different functions by changing the
% load_rsrc_func property. The property defaults to @load_raw_data which
% is programmed to load everything the base packages might need.
% Inputs:
% rpath: Path to the resources directory (corresponds to the Athena
%        property resrc_path, defaults to ./resources/).
% rfile: File name - in rpath  contains the saved raw inputs from the
%        previous run (corresponds to the Athena property resrc_cache,
%        defaults to resources.mat).
% fname: File name - in rpath - the spreadsheet that holds all of the raw
%        numbers (corresponds to the Athena property raw_inputs, defaults
%        to Two_Prod_Ind_PrevMat.xlsx).
% isClear: T/F. Flag that controls whether or not the raw data is to be be
%        loaded from the spreadsheet. True means the data comes from
%        spreadsheet. False means that the spreadsheet is only accessed if
%        the resource cache file does not exist yet (corresponds to the
%        Athena property clear, defaults to False).
% Outputs:
% raw: A MATLAB struct that has fields for all the raw inputs that are
%        loaded by the function. (i.e. raw.msf_f)


fname=[rpath,filesep,fname];
%     ocfname=[rpath,filesep,ocfname];

if exist([rpath, filesep, rfile],'file') == 0 || isClear
    % from old cig_smkless_mort_data_load.m,
    % cig_oc_mort_data_load.m, and com_smkless_mort_data_load.m

    raw.die_nprod1_f=xlsread(fname,'','die_nprod1_f');
    raw.die_nprod1_m=xlsread(fname,'','die_nprod1_m');

    raw.adj_factor_f=xlsread(fname,'','adj_factor_f');
    raw.adj_factor_m=xlsread(fname,'','adj_factor_m');

    raw.s_relmax=0;
    raw.m_relmax=0;

    raw.msf_f=xlsread(fname,'','msf_f');
    raw.msf_m=xlsread(fname,'','msf_m');

    raw.rr_prod1_f=xlsread(fname,'','rr_prod1_f');
    raw.rr_prod1_m=xlsread(fname,'','rr_prod1_m');

    raw.rr_prod2_f=xlsread(fname,'','rr_prod2_f');
    raw.rr_prod2_m=xlsread(fname,'','rr_prod2_m');

    % from old cig_smkless_pop_data_load.m,
    % cig_oc_pop_data_load.m, and com_smkless_pop_data_load.m

    raw.pop2k_f=xlsread(fname,'','pop2k_f');
    raw.pop2k_m=xlsread(fname,'','pop2k_m');

    raw.birth_rate_f=xlsread(fname,'','birth_rate_f');
    raw.birth_rate_m=xlsread(fname,'','birth_rate_m');

    raw.migration=xlsread(fname,'','migration');
    raw.mig_frac_f=xlsread(fname,'','mig_frac_f');
    raw.mig_frac_m=xlsread(fname,'','mig_frac_m');

    raw.prod1_prev2k_f=xlsread(fname,'','prod1_prev2k_f');
    raw.prod1_prev2k_f=[1-raw.prod1_prev2k_f(:,2),...
        raw.prod1_prev2k_f(:,1),...
        raw.prod1_prev2k_f(:,2)-raw.prod1_prev2k_f(:,1)];
    raw.prod1_prev2k_m=xlsread(fname,'','prod1_prev2k_m');
    raw.prod1_prev2k_m=[1-raw.prod1_prev2k_m(:,2),...
        raw.prod1_prev2k_m(:,1),...
        raw.prod1_prev2k_m(:,2)-raw.prod1_prev2k_m(:,1)];

    raw.prod2_prev2k_f=xlsread(fname,'','prod2_prev2k_f');
    raw.prod2_prev2k_f=[1-raw.prod2_prev2k_f(:,2),...
        raw.prod2_prev2k_f(:,1),...
        raw.prod2_prev2k_f(:,2)-raw.prod2_prev2k_f(:,1)];
    raw.prod2_prev2k_m=xlsread(fname,'','prod2_prev2k_m');
    raw.prod2_prev2k_m=[1-raw.prod2_prev2k_m(:,2),...
        raw.prod2_prev2k_m(:,1),...
        raw.prod2_prev2k_m(:,2)-raw.prod2_prev2k_m(:,1)];

    raw.frmr_prod1_dist_f=xlsread(fname,'','frmr_prod1_dist_f');
    raw.frmr_prod1_dist_m=xlsread(fname,'','frmr_prod1_dist_m');

    raw.frmr_prod2_dist_f=xlsread(fname,'','frmr_prod2_dist_f');
    raw.frmr_prod2_dist_m=xlsread(fname,'','frmr_prod2_dist_m');

    % from old cig_smkless_trans_data_load.m,
    % cig_oc_trans_data_load.m, and com_smkless_trans_data_load.m

    raw.init_quit_prod1_f=[xlsread(fname,'','init_prod1_f'),xlsread(fname,'','quit_prod1_f'),xlsread(fname,'','relapse_prod1_f')];
    raw.init_quit_prod1_m=[xlsread(fname,'','init_prod1_m'),xlsread(fname,'','quit_prod1_m'),xlsread(fname,'','relapse_prod1_m')];

    raw.init_quit_prod2_f=[xlsread(fname,'','init_prod2_f'),xlsread(fname,'','quit_prod2_f'),xlsread(fname,'','relapse_prod2_f')];
    raw.init_quit_prod2_m=[xlsread(fname,'','init_prod2_m'),xlsread(fname,'','quit_prod2_m'),xlsread(fname,'','relapse_prod2_m')];

    % from old 2prod_1a/init_pop_from_file.m

    raw.twoprod_prev_mat_f=xlsread(fname,'','twoprod_prev_f');
    raw.twoprod_prev_mat_m=xlsread(fname,'','twoprod_prev_m');

    save([rpath, filesep, rfile],'raw');
elseif ~isClear
    load([rpath, filesep, rfile]);
    return;
end
end

