package org.fda.regression;

import java.io.Serializable;
import java.util.List;
import org.fda.data.Utilities;
import static org.fda.data.Utilities.numberFormatterSmall;

/**
 *
 * @author Gokhan.Yavas
 */
public class RegressionSubModel implements Serializable{
    private static final long serialVersionUID = -3261334363750582918L;
    private double intercept;
    private double thresholdCoeff;
    private double lengthCoeff;
    private List<DataValue> dvList;

    public RegressionSubModel(double lengthCoeff, double thresholdCoeff, double intercept, List<DataValue> dvList){    
        this.intercept=intercept;
        this.lengthCoeff = lengthCoeff;
        this.thresholdCoeff = thresholdCoeff;        
        this.dvList = dvList;
        
    }
    public void setIntercept(double intercept) {
        this.intercept = intercept;
    }

    public void setThresholdCoeff(double thresholdCoeff) {
        this.thresholdCoeff = thresholdCoeff;
    }

    public void setLengthCoeff(double lengthCoeff) {
        this.lengthCoeff = lengthCoeff;
    }

    public double getIntercept() {
        return intercept;
    }

    public double getThresholdCoeff() {
        return thresholdCoeff;
    }

    public double getLengthCoeff() {
        return lengthCoeff;
    }
    
    public double calculateValue(double length, double thre){
        return(length*lengthCoeff+thre*thresholdCoeff+intercept);
    }
    
    @Override
    public String toString(){
        String r =  Utilities.numberFormatterSmall.format(getLengthCoeff())+"\t"+Utilities.numberFormatterSmall.format(getThresholdCoeff())+"\t"+
                Utilities.numberFormatterSmall.format(getIntercept())+Utilities.ls;        
        return r;
    }        
    public String inTabDelimFormat(){
        String r =  "\tLength coefficient: "+getLengthCoeff()+Utilities.ls+"\tThreshold Coefficient: "+getThresholdCoeff()+Utilities.ls
                +"\tIntercept: "+getIntercept()+Utilities.ls;
        
        return r;        
    }
    
}
