package org.fda.regression;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.fda.data.Reference;
import org.fda.data.ReferenceSet;
import org.fda.data.Utilities;

/**
 *
 * @author Gokhan.Yavas
 */
public class RegressionModel implements Serializable{
    private final Map<Reference, RegressionSubModel> rmap;
    private final ReferenceSet rset;    
    private final Map<Reference, List<DataValue>> alldatamap;

    private static final long serialVersionUID = -324363750582918L;
    public RegressionSubModel getSubModel(Reference r){
        return rmap.get(r);
    }
    public Map<Reference, List<DataValue>> getAlldatamap() {
        return alldatamap;
    }
    public RegressionModel(ReferenceSet rset, Map<Reference, List<DataValue>> alldata){
        rmap = new TreeMap();
        this.rset = rset;
        this.alldatamap = alldata;
    }
    public boolean addSubModel(Reference r, RegressionSubModel mod){
        if(rset.findReference(r.getRefID())!=null){
            rmap.put(r, mod);        
            return true;
        }
        return false;
    }    

    public ReferenceSet getReferenceSet() {
        return rset;
    }
    
    public String toString(){
        StringBuilder ret = new StringBuilder("Total "+rset.getRefs().size()+" chromosomes in the reference:"+Utilities.ls);
        if(Utilities.showModelInTabularFormat)
            ret.append("Chromosome\tLength Coeff\tRelocaction Threshold Coeff\tIntercept"+Utilities.ls);
        for(Reference ref : rset.getRefs()){
            ret.append(ref.getRefID()+"\t");
            if(Utilities.showModelInTabularFormat)
                ret.append(this.rmap.get(ref).toString());
            else
                ret.append(this.rmap.get(ref).inTabDelimFormat());
            if(Utilities.showModelData){
                ret.append("\tName\tLength\tThreshold\tMisassembly"+Utilities.ls);        
                List<DataValue> dlist = alldatamap.get(ref);
                for(DataValue d : dlist)
                    ret.append("\t"+d+Utilities.ls);        
            }
            
        }        
        return ret.toString();
    }
    
    
}
