package org.fda.regression;

import java.io.File;
import org.fda.commands.ComputeModelCommand;
import org.fda.contiggenerator.ContigGeneratorForModel;
import org.fda.data.Enums;
import org.fda.data.Enums.AlignmentTool;
import org.fda.data.ReferenceSet;
import org.fda.data.Utilities;
import org.fda.dataaligner.DataAligner;
import org.fda.evaluator.Evaluator4Artifact;

/**
 *
 * @author Gokhan.Yavas
 */
public class ModelCompute {
    private final File destFolder;
    private final File refFile;
    private final ReferenceSet chrset;
    private File modelFile;
    

    public File getModelFile() {
        return modelFile;
    }
    public ModelCompute(File outfolder, File reffile, ReferenceSet chrset){
        destFolder = outfolder;
        refFile = reffile;
        this.chrset = chrset;
    
    }
//    public RegressionSubModel process(File alignerDir, boolean isscaffold){
    public RegressionModel process(File alignerDir, boolean justModelling){
        RegressionModel rm;
        File modelDir = new File(destFolder.getAbsolutePath()+File.separator+"MODEL");
        
        modelDir.mkdirs();
//        File simFile=refFile;
        File simFile;
        //int noparts=Math.min(100,chrset.getNumberOfReferences());
        int noparts;
        Utilities.current_cmd.startTimer4Process("Generating the synthetic contigs");
        simFile= new File(modelDir.getAbsolutePath()+File.separator+"sim.fa");        
        ContigGeneratorForModel g = new ContigGeneratorForModel(refFile, simFile);
        g.generateContigs();
        g.addRefAsContigs();        
        if(Utilities.alignmentTool==AlignmentTool.nucmer)
            noparts = Math.min(200,Math.max(1,g.getTotcontnumber()/10));                    
        else
            noparts=1;
        Utilities.current_cmd.endTimer4Process("Generating the synthetic contigs");
        
        Utilities.current_cmd.startTimer4Process("Aligning the reference and synthetic contigs back to reference");
        File tmpdivideDestFolder = new File(modelDir.getAbsolutePath()+File.separator+"CONTIG_ALIGNMENTS");
        tmpdivideDestFolder.mkdirs();        
        DataAligner d = new DataAligner(simFile, noparts, tmpdivideDestFolder, alignerDir, chrset);
        int n=d.setAligners(justModelling);
        if(n<0)
            return null;
        Utilities.waiter(d.getTouchFiles());                                                            
        Utilities.current_cmd.endTimer4Process("Aligning the reference and synthetic contigs back to reference");
        
        
        
        Utilities.current_cmd.startTimer4Process("Multiple Linear Model Computation for artifact prediction");
        Evaluator4Artifact e4m;
        if(Utilities.current_cmd.getClass().isInstance(ComputeModelCommand.class))
            e4m = new Evaluator4Artifact(tmpdivideDestFolder, destFolder, chrset, g.getRefContigIDMap(),new File(destFolder.getAbsolutePath()+File.separator+"model.bin"));
            //e4m = new Evaluator4Artifact(tmpdivideDestFolder, destFolder, chrset, null,new File(destFolder.getAbsolutePath()+File.separator+"model.bin"));
        else
            e4m = new Evaluator4Artifact(tmpdivideDestFolder, destFolder, chrset, g.getRefContigIDMap());
            //e4m = new Evaluator4Artifact(tmpdivideDestFolder, destFolder, chrset, null);
        

        e4m.process();
        rm =e4m.getRm();
        Utilities.current_cmd.endTimer4Process("Multiple Linear Model Computation for artifact prediction");
        Utilities.deleteFolder(modelDir);
        modelFile = e4m.getModelfile();
        return rm;
    }
    
}
