package org.fda.regression;

import java.io.Serializable;
import org.fda.data.Utilities;

/**
 *
 * @author Gokhan.Yavas
 */
public class DataValue implements Comparable<DataValue>, Serializable{
    private final double length; 
    private final String name;
    private final double thre; 
    private final double mis;
    private static final long serialVersionUID = 12516122882189L;
    public String getReferenceName() {
        return name;
    }
    public double getLength(){
        return length;
    }
    public double getThre() {
        return thre;
    }

    public double getMis() {
        return mis;
    }
    public DataValue(String name, double length, double thre, double mis){
        this.name=name;
        this.thre=thre;
        this.mis = mis;
        this.length = length;
    }

    @Override
    public int compareTo(DataValue o) {
        if(this.mis != o.getMis()){
//            return (int)(this.mis - o.getMis());
            if(this.mis > o.mis)
                return 1;
            else
                return -1;            
        }
        else if(this.length != o.length){
//            return (int)(this.length - o.getLength());
            if(this.length > o.length)
                return 1;
            else
                return -1;            
        }
        else{
//            return (int)(this.thre - o.getThre());
            if(this.thre > o.thre)
                return 1;
            else if(this.thre < o.thre)
                return -1;
            else
                return 0;            
        }
    }
    @Override
    public String toString(){
        return  name+"\t"+length + "\t"+thre + "\t"+mis ;
    }    
    
}
