
package org.fda.multithreading;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.fda.alignment.ScaffoldContig;
import org.fda.data.Enums.STOPOBJECT;

/**
 *
 * @author Gokhan.Yavas
 */
public class StandardQMonitor implements Runnable{
    private BlockingQueue queue;
    private List<ScaffoldContig> als;

    public int getContigCount() {
        return als.size();
    }
    
    public List<ScaffoldContig> getContigs(){
        return als;
    }
    public StandardQMonitor(BlockingQueue queue){
        this.queue = queue;
        this.als = new ArrayList<>();
    }
    

    @Override
    public void run() {

        Object o;


        while(true){            
            try {
                o = queue.take();                
                if(o instanceof STOPOBJECT){
                    break;
                }
                else if (o instanceof ScaffoldContig){
                    als.add(((ScaffoldContig)o));
                }                                                   
            } 
            catch(Exception io){ io.printStackTrace();}
        }
    }
}
