
package org.fda.inputdataparser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

/**
 *
 * @author Gokhan.Yavas
 */
public abstract class Reader {
    protected BufferedReader br;   
    protected long readrecordnumber = 0;
    protected Pattern gc_pattern = Pattern.compile("[GgCc]");
    public long getReadRecordNumber(){
        return readrecordnumber;
    }
    public void openFile(File f) throws FileNotFoundException, IOException{
        readrecordnumber = 0;
        if(f.getName().endsWith(".gz"))
            br = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(f))));
        else
            br = new BufferedReader(new FileReader(f));               
    }
    public void closeReader() throws FileNotFoundException, IOException{
        br.close();
    }
    
    public abstract ReadRecord readNextRecord();
    
    
}
