
package org.fda.inputdataparser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import static org.fda.data.Enums.AcceptedInputFileTypes;
import org.fda.data.Utilities;

/**
 *
 * @author Gokhan.Yavas
 */
public class InputReader {
    private long readrecordnumber = 0;
    private Reader ir;
    
    public long getReadRecordNumber(){
        return readrecordnumber;
    }
    public void openFile(File f) throws FileNotFoundException, IOException, Exception{
        
        readrecordnumber = 0;
        if(f.getName().endsWith(AcceptedInputFileTypes.FASTQGZ.toString()) || f.getName().endsWith(AcceptedInputFileTypes.FASTQ.toString()))
            ir = new FastqReader();
        else if(f.getName().endsWith(AcceptedInputFileTypes.FAGZ.toString()) || f.getName().endsWith(AcceptedInputFileTypes.FA.toString()) 
                || f.getName().endsWith(AcceptedInputFileTypes.FASTAGZ.toString()) || f.getName().endsWith(AcceptedInputFileTypes.FASTA.toString()))
            ir = new FastaReader();
        else {
            String message="Wrong input file type"+Utilities.ls+"Accepted file types are:";
            for(AcceptedInputFileTypes a : AcceptedInputFileTypes.values())
                message = message + " " + a.toString();
            throw new Exception(message+Utilities.ls);                   
        }
        ir.openFile(f);
    }
    public void closeReader(){
        try{
            ir.closeReader();
        }
        catch(Exception e){e.printStackTrace();}
    }
    public ReadRecord readNextRecord(){
        ReadRecord rr = ir.readNextRecord();
        if(rr!=null)
            readrecordnumber++;
        return rr;
    }
    
}
