
package org.fda.inputdataparser;

import org.fda.data.Utilities;

/**
 *
 * @author Gokhan.Yavas
 */
public class FastqRecord extends ReadRecord{
    protected String qstr;
    
    public FastqRecord(String header, String read, String qstr, int gc_count){                
//        this.header = header.replaceAll("\\s+", "_");
        this.header = header;
        this.read = read;
        this.qstr = qstr;
//        name = header.substring(1);
//        name = header.split("\\s+")[0].substring(1).replaceAll("[\\.\\|:]", "_");
        name = header.split("\\s+")[0].substring(1);
        this.gc_count = gc_count;
        this.gc_percent = Utilities.calcPercentage(gc_count, read.length());
    }

    public String getQualityStr(){
        return qstr;
    }
    @Override
    public String toString(){
//        return header + Utilities.ls + read+Utilities.ls+ "+"+qstr;
        return "@"+name + Utilities.ls + read+Utilities.ls+ "+"+Utilities.ls+qstr;
    }
    public String getInFasta(){
        return ">"+name + Utilities.ls + read;
    }
    
}
