package org.fda.inputdataparser;

import java.io.File;
import java.io.IOException;
import org.fda.data.Utilities;

/**
 *
 * @author Gokhan.Yavas
 */
public class FastaFilter {
    private File infile;
    private File outfile;
    public FastaFilter(File infile, File outfile){
        this.infile = infile;
        if(outfile!=null)
            this.outfile = outfile;        
        else{
            String[] n = infile.getName().split("\\.");            
            this.outfile = new File("filtered_"+n[0]+".fa");
        }
    }
    public void filter(){
        FastaReader fr = new FastaReader();
        FastaWriter frw = new FastaWriter(outfile);
        try{
            fr.openFile(infile);
            FastaRecord r;
            while((r=((FastaRecord)fr.readNextRecord()))!=null){
                if(r.getReadRecordLength() >= Utilities.fastarecordlengththreshold)
                    frw.write(r);
            }
            fr.closeReader();
        }
        catch(IOException io){io.printStackTrace();}
        finally{
            frw.closeWriter();
            
        }
        
    }
    
}
