package org.fda.graphdrawing.data;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.fda.data.Utilities;

/**
 *
 * @author Gokhan.Yavas
 */
public class CategoryLineChartDataset {
    private final List<CategoryLineChartDatasetSeries> data;
    private final List<String> colnames;
    //private final List<String> rownames;
    
    public CategoryLineChartDataset(){
        data = new ArrayList<>();
        colnames = new ArrayList<>();
        
    }

    public List<CategoryLineChartDatasetSeries> getData() {
        return data;
    }

    public List<String> getSeriesnames() {
        return colnames;
    }
    
    public void addSeries(CategoryLineChartDatasetSeries s){
        data.add(s);
        colnames.add(s.getSerieName());
    }
    
    public String toTable(){
        NumberFormat nr = Utilities.numberFormatter;  
        List<String> rownames = data.get(0).getXlist();
        StringBuilder sb = new StringBuilder();
        sb.append(" \t");
        for(int i=0;i<colnames.size();i++)
            sb.append(colnames.get(i)).append("\t");
        sb.append(Utilities.ls);
        for(int i=0;i<rownames.size();i++){
            sb.append(rownames.get(i)).append("\t");            
            for(int j=0;j<colnames.size();j++){
                if(data.get(j).getYlist().get(i)<0 || Double.compare(data.get(j).getYlist().get(i),Double.NaN)==0)
                    sb.append("-\t");
                else
                    sb.append(nr.format(data.get(j).getYlist().get(i))).append("\t");                
            }
            sb.append(Utilities.ls);
        }
        sb.append(Utilities.ls);
        return sb.toString();
    }
}
