
package org.fda.dataaligner;

import java.io.File;
import java.util.List;
import org.fda.basicstats.BasicStatsCompute;
import org.fda.data.ReferenceSet;


/**
 *
 * @author Gokhan.Yavas
 */
public class DataAligner {
    private final File inputFile;
    private final int numberofsubfolders;
    private final File targetFolder, nucmerFolder;    
    private final ReferenceSet chrset;
    
    private long totContigSize=0; 
    private long noContigs=0;
    //private final RunMode rm;
    private int minCL;
    private int maxCL;
    private List<File> touchFiles;

    public List<File> getTouchFiles() {
        return touchFiles;
    }
    public DataAligner(File inputFile, int numberofsubfolders, File targetFolder, File nucmerFolder, ReferenceSet cset){
        this.inputFile = inputFile;
        this.targetFolder = targetFolder;
        this.chrset = cset;
        this.nucmerFolder = nucmerFolder;

        this.numberofsubfolders = numberofsubfolders;
        //this.rm = rm;
    }
//    public DataAligner(File inputFile, File targetFolder, File nucmerFolder, ReferenceSet cset, InputDataType idt, RunMode rm){
//        this.inputFile = inputFile;
//        this.targetFolder = targetFolder;
//        this.chrset = cset;
//        this.nucmerFolder = nucmerFolder;
//        this.idt = idt;
//        this.numberofsubfolders = 0;
//        //this.rm = rm;
//    }
    
    // Called by the model compute
    public int setAligners(boolean justModelling){
        DataPartitioner d;      
        BasicStatsCompute bsc = new BasicStatsCompute(targetFolder, justModelling);
        //BasicStatsCompute bsc = new BasicStatsCompute(targetFolder, idt, true);
        int toRet=numberofsubfolders;

        // when we align the contigs to the reference
        d= new DataPartitioner(this.inputFile, this.numberofsubfolders, this.targetFolder, this.nucmerFolder, this.chrset, bsc);
        if(!d.divideDataAndCreateScripts())
            return -1;
        touchFiles = d.getTouchFiles();
        bsc.computeStats();
        totContigSize = bsc.getSum();
        noContigs = bsc.getNumberofContigs();
        minCL = bsc.getMin();
        maxCL = bsc.getMax();
        bsc.write2File();
        return toRet;
    }
    
    // Called by the evaluate
//    public int setAligners(Command c){
//        DataPartitioner d;      
//        BasicStatsCompute bsc = new BasicStatsCompute(targetFolder, idt, true);
//        int toRet=numberofsubfolders;
//
//        // when we align the contigs to the reference
//        d= new DataPartitioner(this.inputFile, this.numberofsubfolders, this.targetFolder, this.nucmerFolder, this.chrset, bsc);
//        if(!d.divideDataFile(c))
//            return -1;
//        //c.startTimer4Process("Aligning contigs to the reference genome");
//        touchFiles = d.getTouchFiles();
//        bsc.computeStats();
//        totContigSize = bsc.getSum();
//        noContigs = bsc.getNumberofContigs();
//        minCL = bsc.getMin();
//        maxCL = bsc.getMax();
//        bsc.write2File();
//        return toRet;
//    }
    
    public long getNoContigs(){
        return this.noContigs;
    }
    public long getTotalContigSize(){
        return this.totContigSize;
    }
    public int getMaxContigLength(){
        return maxCL;
    }
    public int getMinContigLength(){
        return minCL;
    }
    
}
