
package org.fda.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 *
 * @author Gokhan.Yavas
 */
public class TimeKeeper {
    private final Map<String, TimePoint> timePoints;
    private final String commandName;
    public TimeKeeper(String commandName){
        this.commandName = commandName;
        timePoints = new TreeMap<>();
        timePoints.put(commandName, new TimePoint(commandName, System.nanoTime()));
    }
    public boolean addStartTimePoint(String label){        
        timePoints.put(label, new TimePoint(label, System.nanoTime()));
        return true;
    }
    public boolean addEndTimePoint(String label){
        if(timePoints.containsKey(label)){
            timePoints.get(label).setEnd(System.nanoTime());
            return true;
        }
        else{
            return false;
        }
    }
    public boolean stopTimer(){
        return addEndTimePoint(commandName);
    }
    public String getPoints(){
        List<TimePoint> tpArr = new ArrayList(timePoints.values());
        StringBuilder sb = new StringBuilder();
        Collections.sort(tpArr);
        for(int i=(tpArr.size()-1); i>=0; i--){
            sb.append(tpArr.get(i)+Utilities.ls);                                
        }
        return sb.toString();
    }
    
}
