package org.fda.data;

import java.io.Serializable;
import org.fda.alignment.Alignment;
import org.fda.data.Enums.Inconsistency;
import org.fda.intervaltree.Interval;


/**
 *
 * @author Gokhan.Yavas
 */
public class Misassembly implements Serializable{
    private static final long serialVersionUID = 1L;
    
    private final Inconsistency type;
    private final Alignment A1;
    private final Alignment A2;
    
    
    public Misassembly(Inconsistency type, Alignment a1, Alignment a2){
        this.type= type;
        this.A1 = a1;
        this.A2 = a2;
    }

    public Inconsistency getType() {
        return type;
    }

    public Alignment getA1() {
        return A1;
    }

    public Alignment getA2() {
        return A2;
    }
    public String toString(){
        StringBuilder sb = new StringBuilder();
        sb.append(type+"\t");        
        Interval refInt, contigInt;
        contigInt=A1.getContigInterval();        
        sb.append(contigInt.toString()+"\t");
        contigInt=A2.getContigInterval();        
        sb.append(contigInt.toString()+"\t");        
        refInt=A1.getReferenceInterval();        
        sb.append(A1.getReference().getRefID()+":"+refInt.toString()+"\t");
        refInt=A2.getReferenceInterval();
        sb.append(A2.getReference().getRefID()+":"+refInt.toString());        
        return sb.toString();
    }
}
