package org.fda.contiggenerator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.fda.data.Enums;
import org.fda.data.Utilities;
import org.fda.exceptions.IllegalIntervalException;
import org.fda.inputdataparser.FastaReader;
import org.fda.inputdataparser.FastaRecord;
import org.fda.inputdataparser.FastaWriter;

/**
 *
 * @author Gokhan.Yavas
 */
public class ContigGenerator5 extends ContigGenerator4{
    private final Map<String, List<String>> map;

    public Map<String, List<String>> getRefContigIDMap() {
        return map;
    }
    public ContigGenerator5(File infile, File outfile){//, double mean, double sd, Enums.Distribution dist, boolean setseed, boolean isRandom, boolean createreport){
        super(infile, outfile, 0, 0, Enums.Distribution.UNIFORM, true, false, true);               
        map = new TreeMap();
    }
    
    @Override
    public void generateContigs(){
        FastaReader fr = new FastaReader();
        FastaWriter frw = new FastaWriter(outfile);   
        int w = (int)Utilities.depthCoverage;
        double f = Utilities.depthCoverage - w; 
        
        try{
            fr.openFile(infile);
            FastaRecord r;
                                                
            while((r=((FastaRecord)fr.readNextRecord()))!=null){
//                if(r.getReadRecordLength()<Utilities.simulation_mincontiglength){
//                    System.out.println("This reference chromosome is smaller than "+Utilities.simulation_mincontiglength+" base pairs, which is the minimum required length");
//                    System.out.println("Hence no contigs would be created using this reference chromosome");
//                    continue;
//                }
                // calculate the total gaps in reference r
                totalNReference+=r.getNcount();
                
                totrefnumber++;
                totrefsize+=r.getReadRecordLength();
                map.put(r.getName(), new ArrayList());
                setMean((double)r.getReadRecordLength());
                // now we read the reference sequence and create contigs to cover it "coverage" times                                    
                for(int i=0; i<w;i++){
                    if(setseed)
                        rand.setSeed((long)r.getReadRecordLength()+i);                    
                    map.get(r.getName()).addAll(createContigsOnReference(r, frw, 1));
                    //createContigsOnReference(r, frw, 1);
                }
                if(f!=0){
                    if(setseed)
                        rand.setSeed((long)r.getReadRecordLength()-1);                    

                    map.get(r.getName()).addAll(createContigsOnReference(r, frw, f));
                }
                // now we read the reference sequence and create contigs to cover it "coverage" times                                    
//                for(int i=0; i<Utilities.depthCoverage;i++){
//                    if(setseed)
//                        rand.setSeed((long)r.getReadRecordLength()+i);
//                    setMean((double)r.getReadRecordLength());
//                    map.get(r.getName()).addAll(createContigsOnReference(r, frw, 1));
//                }
            }            
        }
        catch(IOException io){io.printStackTrace();} 
        catch (IllegalIntervalException ex) {ex.printStackTrace();}
        finally{
            frw.closeWriter();
        }
        report();
        
    }
    
}
