package org.fda.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import com.beust.jcommander.validators.PositiveInteger;
import java.io.File;
import org.fda.data.Enums.RunCommand;
import org.fda.data.Utilities;
import org.fda.functionality.AlphaValidator;

/**
 *
 * @author Gokhan.Yavas
 */
@Parameters(commandDescription = "Re-compute a previous evaluation with given parameters")
public class ReevaluateCommand extends Command{
    @Parameter(names = {"-s","--sourcefolder"}, description = "The results output directory from a previous evaluation", required = true, converter = FileConverter.class)            
    protected File sourceFolder;
    @Parameter(names = {"-d","--evaldestfolder"}, description = "Re-evaluation destination directory", required = false, converter = FileConverter.class)            
    protected File destinationFolder=null;        
    @Parameter(names = {"-t","--threadno"}, description = "Number of threads", required = false, validateWith = PositiveInteger.class)            
    protected int t=Utilities.no_threads;
    // Add more parameters that will control the quality score calculation
    @Parameter(names = {"-l","--lengthscalingfactor"}, description = "The length scaling factor constant that is used to scale the quality value of a scaffold/contig based on its size. The default value is the size of the smallest chromosome of the reference genome which is used to compute the regression model ", required = false, validateWith = PositiveInteger.class)            
    protected Integer lengthScalingFactor=null;
    @Parameter(names = {"-m","--ov_dist_threshold"}, description = "Distance (or overlap) treshold for the alignments of consecutive parts of a contig to be considered a RELOCATION"
            , required = false, validateWith = PositiveInteger.class)            
    protected int distThreshold=Utilities.alignmentDistanceThreshold;
    @Parameter(names = {"-a","--alpha"}, description = "Alpha for reward", required = false,validateWith = AlphaValidator.class, hidden=true)            
    private double alpha=Utilities.alpha;
    public double getAlpha() {
        return alpha;
    }
    @Parameter(names = {"-b","--beta"}, description = "Beta for penalty", required = false,validateWith = AlphaValidator.class, hidden=true)            
    private double beta=Utilities.beta;
    public double getBeta() {
        return beta;
    }    
    public int getDistThreshold() {
        return distThreshold;
    }
    public ReevaluateCommand(){
        rcmd = RunCommand.AssemblyReevaluate;
    }
    public File getSourceFolder(){
        return this.sourceFolder;
    }
    public File getEvalDestFolder(){
        return this.destinationFolder;
    }
    public int getThreadNo() {
        return t;
    }
    public int getLengthScalingFactor() {
        if(lengthScalingFactor==null)
            return 0;        
        return lengthScalingFactor;
    }           
}
