package org.fda.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import com.beust.jcommander.validators.PositiveInteger;
import java.io.File;
import org.fda.data.Enums;

/**
 *
 * @author Gokhan.Yavas
 */
@Parameters(commandDescription = "Recompute the model based on the model filter coefficient")
public class FilterCommand extends Command{
    @Parameter(names = {"-i"}, description = "Input fasta file", required = true, converter = FileConverter.class)            
    protected File inputFile;

    @Parameter(names = {"-o"}, description = "Output fasta file", required = false)            
    protected File outFile=null;

    @Parameter(names = {"-l"}, description = "Length to filter", required = false,  validateWith = PositiveInteger.class)            
    protected int length;

    public int getLength() {
        return length;
    }
    
    protected File destinationFolder=new File(System.getProperty("user.dir"));
    public FilterCommand(){
        this.rcmd = Enums.RunCommand.Filter;
    }
    public File getInputFile() {
        return inputFile;
    }
    public File getOutputFile() {
        return outFile;
    }
    
}
