
package org.fda.commands;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import java.io.File;
import org.fda.data.Enums;
import org.fda.data.Enums.RunCommand;
import org.fda.data.Utilities;
import org.fda.functionality.AlphaValidator;
import org.fda.functionality.DistributionConverter;
import org.fda.functionality.PositiveReal;
/**
 *
 * @author Gokhan.Yavas
 */
@Parameters(commandDescription = "Contig Generate command type 3. This command can generate contigs with three types of distributions: NORMAL, GAMMA and UNIFORM "
        + "with the characteristics of these distributions and total number of "
        + "contigs are specified by the user.")
public class ContigGenerateCommand3 extends Command{
    @Parameter(names = {"-f","--infile"}, description = "Input reference file path", required = true, converter = FileConverter.class)            
    protected File inputFile;
    @Parameter(names = {"-o","--outfile"}, description = "Output contig file path", required = false, converter = FileConverter.class)            
    protected File outputFile=new File("contigs.fa");
    
    @Parameter(names = {"-l","--length distribution"}, description = "Length distribution", required = true, converter = DistributionConverter.class)            
    protected Enums.Distribution distribution;

    public Enums.Distribution getDistribution() {
        return distribution;
    }
    
    @Parameter(names = {"-n","--numberFile"}, description = "A file containing info about the number of contigs in new file", required = true, converter = FileConverter.class)            
    protected File numberFile;
    
    @Parameter(names = {"-s"}, description = "if -l is set to \"NORMAL\" then this represents the standard deviation of the Normal distribution, else if it is set to be \"GAMMA\", then this represents the "
            + "shape of the Gamma distribution, else if it set to be \"UNIFORM\", then this parameter is not required at all, where these distributions correspond to the methods"
            + "used to generate contig lengths"
            + "", required = false, validateWith=PositiveReal.class)            
    protected Double contigSizeDev=(double)1;
    
    @Parameter(names = {"-m"}, description = "if -l is set to \"NORMAL\" then this represents the mean of the Normal distribution, else if it is set to be \"GAMMA\", then this represents the "
            + "scale of the Gamma distribution, else if it set to be \"UNIFORM\", then this represents the maximum value for the distribution, where these distributions correspond to the methods"
            + "used to generate contig lengths"
            + "", required = true, validateWith=PositiveReal.class)                
    protected Double meanContigSize;

    @Parameter(names = {"-w","--contigsoverlap"}, description = "Generated contigs allowed to overlap or not?", required = false)            
    protected final boolean contigsOverlap=Utilities.contigsOverlap;
    @Parameter(names = {"-g","--nratio"}, description = "The allowed percentage of the Ns in a contig", required = false, validateWith = AlphaValidator.class)            
    protected final double nratio=Utilities.nratio;

    protected File destinationFolder=new File(System.getProperty("user.dir"));

    
    public double getNratio() {
        return nratio;
    }

        
    public ContigGenerateCommand3(){
        rcmd = RunCommand.ContigGenerate3;
    }    
    public File getOutputFile(){
        return outputFile;
    }

    public File getInputFile() {
        return inputFile;
    }

    public File getNumberFile() {
        return numberFile;
    }

    public double getMeanContigSize() {
        return meanContigSize;
    }

    public double getContigSizeDev() {
        return contigSizeDev;
    }

    public File getDestinationFolder() {
        return destinationFolder;
    }

    public boolean doesContigsOverlap() {
        return contigsOverlap;
    }

}
