
package org.fda.commands;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import com.beust.jcommander.validators.PositiveInteger;
import java.io.File;
import org.fda.data.Enums;
import org.fda.data.Enums.RunCommand;
import org.fda.data.Utilities;
import org.fda.functionality.AlignmentToolConverter;
import org.fda.functionality.ScriptRunModeConverter;
/**
 *
 * @author Gokhan.Yavas
 */
@Parameters(commandDescription = "Given a reference compute a multiple linear regression model to be used in evaluation")
public class ComputeModelCommand extends Command{
    @Parameter(names = {"-r","--referencefile"}, description = "Input reference file path", required = true, converter = FileConverter.class)            
    protected File inputFile;
    @Parameter(names = {"-q","--alignmentTool"}, description = "Tool used for the alignment of the contigs/scaffolds back to reference", required = false, converter = AlignmentToolConverter.class)            
    private Enums.AlignmentTool alignmentTool=Utilities.alignmentTool;    

    public Enums.AlignmentTool getAlignmentTool() {
        return alignmentTool;
    }

    @Parameter(names = {"-d","--modeldestfolder"}, description = "Model file destination directory", required = false, converter = FileConverter.class)    
    protected File destinationFolder=new File("MODEL");
    @Parameter(names = {"-j","--jobcommand"}, description = "Alignment job submission command", required = false, converter = ScriptRunModeConverter.class)            
    protected Enums.ScriptRunMode jobcommand=Utilities.submitJobs;
    @Parameter(names = {"-p","--jobcommandparams"}, description = "Alignment job submission command parameters in quotes", required = false)            
    protected String jobcommandparams=Utilities.submitJobsParameters; 
    @Parameter(names = {"-t","--threadno"}, description = "Number of threads", required = false, validateWith = PositiveInteger.class)            
    protected int t=Utilities.no_threads;
    public int getThreadNo() {
        return t;
    }
    
    public Enums.ScriptRunMode getJobCommand(){
        return this.jobcommand;
    }
    public String getJobCommandParams(){
        return jobcommandparams;
    }
    
        
    public ComputeModelCommand(){
        rcmd = RunCommand.ComputeModel;
    }    

    public File getInputFile() {
        return inputFile;
    }


    public File getDestinationFolder() {
        return destinationFolder;
    }


}
