
package org.fda.checksum;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.fda.data.Utilities;

/**
 *
 * @author Gokhan.Yavas
 */

public class FileHashGenerator {
    public static byte[] generateMD5(String message) {
        return hashString(message, "MD5");
    }
 
    public static byte[] generateSHA1(String message){
        return hashString(message, "SHA-1");
    }
 
    public static byte[] generateSHA256(String message){
        return hashString(message, "SHA-256");
    }
    public static byte[] generateMD5(File file){
        return hashFile(file, "MD5");
    }

    public static byte[] generateSHA1(File file){
        return hashFile(file, "SHA-1");
    }

    public static byte[] generateSHA256(File file){
        return hashFile(file, "SHA-256");
    }    
 
    private static byte[] hashString(String message, String algorithm){
        byte[] ret =null;
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] hashedBytes = digest.digest(message.getBytes("UTF-8"));
            
            ret=hashedBytes;
        } catch (NoSuchAlgorithmException | UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return ret;
    }
    
    private static byte[] hashFile(File file, String algorithm){
        byte[] ret=null;
        try (FileInputStream inputStream = new FileInputStream(file)) {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] bytesBuffer = new byte[1024];
            int bytesRead = -1;
            while ((bytesRead = inputStream.read(bytesBuffer)) != -1) {
                digest.update(bytesBuffer, 0, bytesRead);
            }
            byte[] hashedBytes = digest.digest();
            ret = hashedBytes;
        } catch (NoSuchAlgorithmException | IOException ex) {
            ex.printStackTrace();
        }
        return ret;
    }
    

    public static void main(String[] args) {
        try {
            //byte[] b1 =FileHashGenerator.generateSHA256("ABCBCBCBCBCBCBCBC BCBCBCBC");
            //byte[] b2 = FileHashGenerator.generateSHA256("ABCBCBCBCBCBCBCBC BCBCBCBCCCC");
            MessageDigest digest1 = MessageDigest.getInstance(Utilities.hashalg.toString());
            MessageDigest digest2 = MessageDigest.getInstance(Utilities.hashalg.toString());
            digest1.update("ABXA".getBytes("UTF-8"));
            digest1.update("B".getBytes("UTF-8"));
            digest1.update("A".getBytes("UTF-8"));
            digest1.update("BCAB".getBytes("UTF-8"));

            digest2.update("AB".getBytes("UTF-8"));
            digest2.update("XAB".getBytes("UTF-8"));
            digest2.update("AB".getBytes("UTF-8"));
            digest2.update("CAB".getBytes("UTF-8"));
            

            byte[] arr1 = digest1.digest();
            byte[] arr2 = digest2.digest();
            for(byte b : arr1)
                System.out.print(b+" ");
            System.out.println("");
            for(byte b : arr2)
                System.out.print(b+" ");
 
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
 
}