package org.fda.checks;

import java.io.File;

/**
 *
 * @author Gokhan.Yavas
 */
interface ICheckAligner{
    boolean checkExecutables(String[] binaryFileNames);
}
public class CheckAligner implements ICheckAligner{    
    protected File packageFolder;
    public CheckAligner(File exeFolder){
        this.packageFolder =exeFolder;
    }
    public boolean checkExecutables(String[] binaryFileNames){        
        for(String s : binaryFileNames){
            if(!new File(packageFolder.getAbsolutePath()+File.separator+s).exists())
                return false;            
        }
        return true;
    }    
}
