package org.fda.alignmentparser.paf;

import org.fda.data.Enums;
import org.fda.data.Enums.Orientation;
import org.fda.data.Reference;
import org.fda.data.ReferenceSet;

/**
 *
 * @author Gokhan.Yavas
 */
public class PafRecord {
    private final Reference reference;
    private final String contigID;
    private int contSt, contEnd, refSt, refEnd;
    private final Enums.Orientation orientation;
    private final int contigLength,refSize;
    private final int qual;    
    private Cigar cigar =null;
    
    public PafRecord(String s, ReferenceSet refset){
        String[] arr = s.split("\t");
        contigID = arr[0];
        contigLength = Integer.parseInt(arr[1]);
        contSt = Integer.parseInt(arr[2])+1;
        contEnd = Integer.parseInt(arr[3]);
        //orientation = Enums.Orientation.valueOf(arr[4]);
        orientation = arr[4].equals("+")?Orientation.F:Orientation.R;
        reference = refset.findReference(arr[5]);
        refSize = Integer.parseInt(arr[6]);
        refSt = Integer.parseInt(arr[7])+1;
        refEnd = Integer.parseInt(arr[8]);
        qual = Integer.parseInt(arr[11]);
        String cigarstr=TextCigarCodec.NO_ALIGNMENT_CIGAR;
        for(int i = 12; i<arr.length; i++)
            if(arr[i].startsWith("cg")){
                cigarstr = arr[i].substring(5);
                //cigarstr = arr[i];
            }        
        cigar = TextCigarCodec.decode(cigarstr);        
    }

    public Reference getReference() {
        return reference;
    }

    public String getContigID() {
        return contigID;
    }

    public int getContSt() {
        return contSt;
    }

    public int getContEnd() {
        return contEnd;
    }

    public int getRefSt() {
        return refSt;
    }

    public int getRefEnd() {
        return refEnd;
    }

    public Enums.Orientation getOrientation() {
        return orientation;
    }

    public int getContigLength() {
        return contigLength;
    }

    public int getRefSize() {
        return refSize;
    }

    public int getQual() {
        return qual;
    }

    public Cigar getCigar() {
        return cigar;
    }
    
    @Override
    public String toString(){
        StringBuilder br = new StringBuilder();
        br.append(getContigID()+"\t"+getReference().getRefID()+"\t"+getContSt()+"\t"+getContEnd()+"\t"+getRefSt()+"\t"+getRefEnd());
        return br.toString();
    }
}
