
package org.fda.alignment;

import org.fda.data.Utilities;

/**
 *
 * @author Gokhan.Yavas
 */
public class AlignmentWrapper implements Comparable<AlignmentWrapper>{
    private Alignment alignment=null;
    private long score=0;
    private long diff=0;
    private int from=-1;
    private boolean used=false;
    AlignmentWrapper(Alignment alignment){
        this.alignment=alignment;
    }
    public void setScore(long score){
        this.score = score;
    }
    public void setDiff(long diff){
        this.diff = diff;
    }
    public void setFrom(int from){
        this.from = from;
    }
    public void setUsed(boolean used){
        this.used = used;
    }

    public Alignment getAlign(){
        return this.alignment;
    }    
    
    public long getScore(){
        return this.score;
    }
    public long getDiff(){
        return this.diff ;
    }
    public int getFrom(){
        return this.from;
    }
    public boolean getUsed(){
        return this.used ;
    }
    @Override
    public int compareTo(AlignmentWrapper o) {
        if(getAlign().getContSt() < o.getAlign().getContSt())            
            return -1;
        else if(getAlign().getContSt() > o.getAlign().getContSt())
            return 1;
//        else if(Utilities.scoreLocal(0, getAlign().getContEnd() - getAlign().getContSt() + 1, 0, 0, getAlign().getIdentity(), 0) > 
//                Utilities.scoreLocal(0, o.getAlign().getContEnd() - o.getAlign().getContSt() + 1, 0, 0, o.getAlign().getIdentity(), 0))
        else{ 
            long a = Utilities.scoreLocal(0, getAlign().getContigAlignmentLength(), 0, 0, getAlign().getIdentity(), 0);
            long b = Utilities.scoreLocal(0, o.getAlign().getContigAlignmentLength(), 0, 0, o.getAlign().getIdentity(), 0);
            if(a == b){                
                return 0;
                //return this.getAlign().getReference().compareTo(o.getAlign().getReference());                
            }
            else if(a>b)
                return -1;
            else
                return 1;
        }
    }
    
}
